/*
 * Decompiled with CFR 0.152.
 */
package rcm.util;

import java.util.StringTokenizer;

public abstract class Str {
    private static final int INT = 0;
    private static final int FRAC = 1;
    private static final int EXP = 2;

    public static int indexOfAnyChar(String subject, String chars) {
        return Str.indexOfAnyChar(subject, chars, 0);
    }

    public static int indexOfAnyChar(String subject, String chars, int start) {
        int i = start;
        while (i < subject.length()) {
            if (chars.indexOf(subject.charAt(i)) != -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static String replace(String subject, String original, String replacement) {
        int i;
        StringBuffer output = new StringBuffer();
        int p = 0;
        while ((i = subject.indexOf(original, p)) != -1) {
            void var5_5;
            output.append(subject.substring(p, (int)var5_5));
            output.append(replacement);
            p = var5_5 + original.length();
        }
        if (p < subject.length()) {
            output.append(subject.substring(p));
        }
        return output.toString();
    }

    public static String escape(String subject, char escapeChar, String metachars) {
        return Str.escape(subject, metachars, escapeChar, metachars);
    }

    /*
     * WARNING - void declaration
     */
    public static String escape(String subject, String chars, char escapeChar, String metachars) {
        int i;
        StringBuffer output = new StringBuffer();
        int p = 0;
        while ((i = Str.indexOfAnyChar(subject, chars, p)) != -1) {
            void var6_6;
            output.append(subject.substring(p, (int)var6_6));
            char c = subject.charAt((int)var6_6);
            int k = chars.indexOf(c);
            char metac = metachars.charAt(k);
            output.append(escapeChar);
            output.append(metac);
            p = var6_6 + true;
        }
        if (p < subject.length()) {
            output.append(subject.substring(p));
        }
        return output.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String unescape(String subject, char escapeChar, String metachars, String chars, boolean keepUntranslatedEscapes) {
        int i;
        StringBuffer output = new StringBuffer();
        int p = 0;
        int len = subject.length();
        while ((i = subject.indexOf(escapeChar, p)) != -1) {
            void var7_8;
            output.append(subject.substring(p, (int)var7_8));
            if (var7_8 + true == len) break;
            char metac = subject.charAt((int)(var7_8 + true));
            int k = metachars.indexOf(metac);
            if (k == -1) {
                if (keepUntranslatedEscapes) {
                    output.append(escapeChar);
                }
                output.append(metac);
            } else {
                output.append(chars.charAt(k));
            }
            p = var7_8 + 2;
        }
        if (p < len) {
            output.append(subject.substring(p));
        }
        return output.toString();
    }

    public static Number parseNumber(String s) throws NumberFormatException {
        boolean p = false;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (Character.isDigit(c)) {
                int start = i++;
                int end = i;
                int state = 0;
                if (start > 0 && s.charAt(start - 1) == '.') {
                    --start;
                    state = 1;
                }
                if (start > 0 && s.charAt(start - 1) == '-') {
                    --start;
                }
                block9: while (i < s.length()) {
                    switch (s.charAt(i)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            end = ++i;
                            break;
                        }
                        case '.': {
                            if (state != 0) break block9;
                            state = 1;
                            ++i;
                            break;
                        }
                        case ',': {
                            ++i;
                            break;
                        }
                        case 'E': 
                        case 'e': {
                            state = 2;
                            if (++i >= s.length() || (c = s.charAt(i)) != '+' && c != '-') continue block9;
                            ++i;
                            break;
                        }
                        default: {
                            break block9;
                        }
                    }
                }
                String num = s.substring(start, end);
                num = Str.replace(num, ",", "");
                try {
                    if (state == 0) {
                        return new Integer(num);
                    }
                    return new Float(num);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("internal error: " + e);
                }
            }
            ++i;
        }
        throw new NumberFormatException(s);
    }

    public static String repeat(String s, int n) {
        StringBuffer out = new StringBuffer();
        while (--n >= 0) {
            out.append(s);
        }
        return out.toString();
    }

    public static String compressWhitespace(String s) {
        StringBuffer output = new StringBuffer();
        int p = 0;
        boolean inSpace = true;
        int i = 0;
        int len = s.length();
        while (i < len) {
            if (Character.isWhitespace(s.charAt(i))) {
                if (!inSpace) {
                    output.append(s.substring(p, i));
                    output.append(' ');
                    inSpace = true;
                }
            } else if (inSpace) {
                p = i;
                inSpace = false;
            }
            ++i;
        }
        if (!inSpace) {
            output.append(s.substring(p));
        }
        return output.toString();
    }

    public static boolean isWhitespace(String s) {
        int i = 0;
        int n = s.length();
        while (i < n) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String join(String[] list, String sep) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < list.length) {
            if (i > 0) {
                result.append(sep);
            }
            result.append(list[i]);
            ++i;
        }
        return result.toString();
    }

    public static String abbreviate(String s, int max) {
        if ((s = Str.compressWhitespace(s)).length() < max) {
            return s;
        }
        max = Math.max(max - 3, 2);
        int half = max / 2;
        return s.substring(0, half) + "..." + s.substring(s.length() - half);
    }

    public static String abbreviateLines(String s, int maxLines, String message) {
        int nLines = Str.countLines(s);
        if (nLines < maxLines) {
            return s;
        }
        maxLines = Math.max(maxLines - 1, 2);
        int half = maxLines / 2;
        return s.substring(0, Str.nthLine(s, half)) + Str.replace(message, "%d", String.valueOf(nLines - half * 2)) + s.substring(Str.nthLine(s, -half));
    }

    static int countLines(String s) {
        int n = 1;
        int i = -1;
        while ((i = s.indexOf(10, i + 1)) != -1) {
            ++n;
        }
        return n;
    }

    static int nthLine(String s, int n) {
        if (n >= 0) {
            int i = -1;
            while (n > 0 && (i = s.indexOf(10, i + 1)) != -1) {
                --n;
            }
            return i + 1;
        }
        int i = s.length();
        while (n < 0 && (i = s.lastIndexOf(10, i - 1)) != -1) {
            ++n;
        }
        return i + 1;
    }

    public static String before(String s, String pat) {
        int i = s.indexOf(pat);
        return i >= 0 ? s.substring(0, i) : s;
    }

    public static String after(String s, String pat) {
        int i = s.indexOf(pat);
        return i >= 0 ? s.substring(i + pat.length()) : "";
    }

    public static boolean startsWithIgnoreCase(String s, String prefix) {
        int prefixLen;
        int sLen = s.length();
        return sLen >= (prefixLen = prefix.length()) && s.substring(0, prefixLen).equalsIgnoreCase(prefix);
    }

    public static boolean endsWithIgnoreCase(String s, String suffix) {
        int suffixLen;
        int sLen = s.length();
        return sLen >= (suffixLen = suffix.length()) && s.substring(sLen - suffixLen).equalsIgnoreCase(suffix);
    }

    public static String untabify(String s, int tabsize) {
        if (s.indexOf(9) == -1) {
            return s;
        }
        int col = 0;
        StringBuffer result = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(s, "\t\r\n", true);
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            switch (tok.charAt(0)) {
                case '\t': {
                    int oldcol = col;
                    col = (col / tabsize + 1) * tabsize;
                    result.append(Str.repeat(" ", col - oldcol));
                    break;
                }
                case '\n': 
                case '\r': {
                    col = 0;
                    result.append(tok);
                    break;
                }
                default: {
                    col += tok.length();
                    result.append(tok);
                }
            }
        }
        return result.toString();
    }

    public static String reverse(String s) {
        StringBuffer t = new StringBuffer(s.length());
        int i = s.length() - 1;
        while (i >= 0) {
            t.append(s.charAt(i));
            --i;
        }
        return t.toString();
    }

    public static String longestCommonPrefix(String s, String t) {
        return s.substring(0, Str.longestCommonPrefixLength(s, t));
    }

    public static int longestCommonPrefixLength(String s, String t) {
        int m = Math.min(s.length(), t.length());
        int k = 0;
        while (k < m) {
            if (s.charAt(k) != t.charAt(k)) {
                return k;
            }
            ++k;
        }
        return m;
    }

    public static String longestCommonSuffix(String s, String t) {
        return s.substring(s.length() - Str.longestCommonSuffixLength(s, t));
    }

    public static int longestCommonSuffixLength(String s, String t) {
        int i = s.length() - 1;
        int j = t.length() - 1;
        while (i >= 0 && j >= 0) {
            if (s.charAt(i) != t.charAt(j)) {
                return s.length() - (i + 1);
            }
            --i;
            --j;
        }
        return s.length() - (i + 1);
    }

    public static String longestCommonPrefixIgnoreCase(String s, String t) {
        return s.substring(0, Str.longestCommonPrefixLengthIgnoreCase(s, t));
    }

    public static int longestCommonPrefixLengthIgnoreCase(String s, String t) {
        int m = Math.min(s.length(), t.length());
        int k = 0;
        while (k < m) {
            if (Character.toLowerCase(s.charAt(k)) != Character.toLowerCase(t.charAt(k))) {
                return k;
            }
            ++k;
        }
        return m;
    }

    public static String longestCommonSuffixIgnoreCase(String s, String t) {
        return s.substring(s.length() - Str.longestCommonSuffixLengthIgnoreCase(s, t));
    }

    public static int longestCommonSuffixLengthIgnoreCase(String s, String t) {
        int i = s.length() - 1;
        int j = t.length() - 1;
        while (i >= 0 && j >= 0) {
            if (Character.toLowerCase(s.charAt(i)) != Character.toLowerCase(t.charAt(j))) {
                return s.length() - (i + 1);
            }
            --i;
            --j;
        }
        return s.length() - (i + 1);
    }

    static {
        INT = 0;
        FRAC = 1;
        EXP = 2;
    }
}

