/*
 * Decompiled with CFR 0.152.
 */
package rcm.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Panel;

public class BorderPanel
extends Panel {
    int left;
    int top;
    int bottom;
    int right;

    public BorderPanel(Insets insets) {
        this.left = insets.left;
        this.top = insets.top;
        this.bottom = insets.bottom;
        this.right = insets.right;
    }

    public BorderPanel(int left, int top, int bottom, int right) {
        this.left = left;
        this.top = top;
        this.bottom = bottom;
        this.right = right;
    }

    public void layout() {
        Dimension d = this.getSize();
        int x = this.left;
        int y = this.top;
        int w = d.width - this.left - this.right;
        int h = d.height - this.top - this.bottom;
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            comps[i].setBounds(x, y, w, h);
            ++i;
        }
    }

    public Dimension getPreferredSize() {
        Dimension max = new Dimension(0, 0);
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            Dimension d = comps[i].getPreferredSize();
            max.width = Math.max(d.width, max.width);
            max.height = Math.max(d.height, max.height);
            ++i;
        }
        max.width += this.left + this.right;
        max.height += this.top + this.bottom;
        return max;
    }

    public Dimension getMinimumSize() {
        Dimension max = new Dimension(0, 0);
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            Dimension d = comps[i].getMinimumSize();
            max.width = Math.max(d.width, max.width);
            max.height = Math.max(d.height, max.height);
            ++i;
        }
        max.width += this.left + this.right;
        max.height += this.top + this.bottom;
        return max;
    }

    public static Panel wrap(Component comp, Insets insets) {
        BorderPanel p = new BorderPanel(insets);
        p.add(comp);
        return p;
    }

    public static Panel wrap(Component comp, int left, int top, int bottom, int right) {
        BorderPanel p = new BorderPanel(left, top, bottom, right);
        p.add(comp);
        return p;
    }

    public static Panel wrap(Component comp, int horiz, int vert) {
        BorderPanel p = new BorderPanel(horiz, vert, horiz, vert);
        p.add(comp);
        return p;
    }

    public static Panel wrap(Component comp, int all) {
        BorderPanel p = new BorderPanel(all, all, all, all);
        p.add(comp);
        return p;
    }
}

