/*
 * Decompiled with CFR 0.152.
 */
package gd;

import gd.GDAlgorithm;
import graph.Barycenter;
import graph.Coords;
import graph.Edge;
import graph.Graph;
import graph.My;
import graph.Node;

public class QuadTreeAlgorithm
extends GDAlgorithm {
    private double[] previousX;
    private double[] previousY;
    private double[] moveX;
    private double[] moveY;

    public QuadTreeAlgorithm(double d, double d2) {
        this.springConstant = d;
        this.nodeCharge = d2;
    }

    public synchronized double improveGraph(Graph graph) {
        if (graph.sizeNodes == 0) {
            return 0.0;
        }
        if (this.previousX == null || this.previousX.length < graph.sizeNodes) {
            this.previousX = new double[graph.sizeNodes];
            this.previousY = new double[graph.sizeNodes];
            this.moveX = new double[graph.sizeNodes];
            this.moveY = new double[graph.sizeNodes];
        }
        int n = 0;
        while (n < graph.sizeNodes) {
            this.previousX[n] = graph.nodes[n].x;
            this.previousY[n] = graph.nodes[n].y;
            ++n;
        }
        double d = this.energy(graph);
        double d2 = graph.barycenter.x;
        double d3 = graph.barycenter.y;
        this.improveBarycenter(graph.barycenter);
        int n2 = 0;
        while (n2 < graph.sizeNodes) {
            this.moveX[n2] = graph.nodes[n2].x - this.previousX[n2];
            this.moveY[n2] = graph.nodes[n2].y - this.previousY[n2];
            ++n2;
        }
        this.improveAll(graph, d);
        graph.center(d2, d3);
        return this.energy(graph) - d;
    }

    private synchronized void moveAll(Graph graph, double d) {
        int n = 0;
        while (n < graph.sizeNodes) {
            graph.placeNode(graph.nodes[n], this.previousX[n] + d * this.moveX[n], this.previousY[n] + d * this.moveY[n]);
            ++n;
        }
    }

    private synchronized void improveAll(Graph graph, double d) {
        double d2 = this.energy(graph);
        this.moveAll(graph, -2.0);
        double d3 = this.energy(graph);
        double d4 = d2 + d3 - 2.0 * d;
        if (d4 == 0.0) {
            this.moveAll(graph, 2.0);
            return;
        }
        double d5 = (d2 - d3) / 2.0;
        double d6 = -d5 / (2.0 * d4);
        this.moveAll(graph, d6 + 2.0);
        if (this.energy(graph) >= d) {
            this.moveAll(graph, 1.0 - d6);
        }
    }

    public synchronized double energy(Graph graph) {
        return this.energy(graph.barycenter);
    }

    private synchronized double energy(Barycenter barycenter) {
        if (barycenter.NW == null) {
            return this.localEnergy(barycenter);
        }
        return this.groupEnergy(barycenter, 0.0, 0.0) + this.energy(barycenter.NW) + this.energy(barycenter.NE) + this.energy(barycenter.SW) + this.energy(barycenter.SE);
    }

    private synchronized void improveBarycenter(Barycenter barycenter) {
        if (barycenter.sizeNodes == 0) {
            return;
        }
        Coords coords = this.groupForce(barycenter, 0.0, 0.0);
        double d = Math.sqrt(My.square(coords.x) + My.square(coords.y));
        if (d != 0.0) {
            coords.x /= d;
            coords.y /= d;
            double d2 = this.groupEnergy(barycenter, 0.0, 0.0);
            double d3 = this.quadApprox(barycenter, d2, coords);
            if (d3 == 0.0) {
                double d4 = coords.x;
                coords.x = coords.y;
                coords.y = -d4;
                if ((d3 += this.quadApprox(barycenter, d2 + d3, coords)) == 0.0) {
                    coords.x = Math.random();
                    coords.y = Math.random();
                    d3 += this.quadApprox(barycenter, d2 + d3, coords);
                }
            }
        }
        if (barycenter.NW != null) {
            this.improveBarycenter(barycenter.NW);
            this.improveBarycenter(barycenter.NE);
            this.improveBarycenter(barycenter.SW);
            this.improveBarycenter(barycenter.SE);
            return;
        }
        this.locallyImprove(barycenter);
    }

    private synchronized Coords groupForce(Barycenter barycenter, double d, double d2) {
        if (barycenter.parent == null) {
            return new Coords(0.0, 0.0);
        }
        return this.repulsionForce(barycenter, d, d2).add(this.springForce(barycenter, d, d2));
    }

    private synchronized double groupEnergy(Barycenter barycenter, double d, double d2) {
        if (barycenter.parent == null) {
            return 0.0;
        }
        return this.repulsionEnergy(barycenter, d, d2) + this.springEnergy(barycenter, d, d2);
    }

    private synchronized Coords springForce(Node node, Edge edge, double d, double d2) {
        if (!edge.from.placed || !edge.to.placed) {
            return new Coords(0.0, 0.0);
        }
        double d3 = edge.to.x - edge.from.x;
        double d4 = edge.to.y - edge.from.y;
        if (node == edge.from) {
            d3 -= d;
            d4 -= d2;
        } else {
            d3 += d;
            d4 += d2;
        }
        double d5 = Math.sqrt(My.square(d3) + My.square(d4));
        double d6 = d5 - edge.restLength;
        double d7 = 2.0 * this.springConstant * d6 / d5;
        if (node == edge.to) {
            d7 = -d7;
        }
        Coords coords = new Coords(d7 * d3, d7 * d4);
        if (edge.directed && d4 > edge.restLength) {
            coords.y -= 2.0 * this.springConstant * (d4 - edge.restLength) / 2.0;
        }
        return coords;
    }

    private synchronized Coords springForce(Barycenter barycenter, double d, double d2) {
        Coords coords = new Coords(0.0, 0.0);
        int n = 0;
        while (n < barycenter.sizeEdges) {
            Edge edge = barycenter.edges[n];
            if (edge.from.barycenter == barycenter) {
                coords.add(this.springForce(edge.from, edge, d, d2));
            } else {
                coords.add(this.springForce(edge.to, edge, d, d2));
            }
            ++n;
        }
        return coords;
    }

    private synchronized double springEnergy(Edge edge, Node node, double d, double d2) {
        if (!edge.from.placed || !edge.to.placed) {
            return 0.0;
        }
        double d3 = edge.to.x - edge.from.x;
        double d4 = edge.to.y - edge.from.y;
        if (node == edge.from) {
            d3 -= d;
            d4 -= d2;
        } else {
            d3 += d;
            d4 += d2;
        }
        double d5 = Math.sqrt(My.square(d3) + My.square(d4));
        double d6 = this.springConstant * My.square(d5 - edge.restLength);
        if (edge.directed && d4 > edge.restLength) {
            d6 -= this.springConstant * My.square(d4 - edge.restLength) / 2.0;
        }
        return d6;
    }

    private synchronized double springEnergy(Barycenter barycenter, double d, double d2) {
        double d3 = 0.0;
        new Coords(0.0, 0.0);
        int n = 0;
        while (n < barycenter.sizeEdges) {
            Edge edge = barycenter.edges[n];
            d3 = edge.from.barycenter == barycenter ? (d3 += this.springEnergy(edge, edge.from, d, d2)) : (d3 += this.springEnergy(edge, edge.to, d, d2));
            ++n;
        }
        return d3;
    }

    private synchronized Coords repulsionForce(Barycenter barycenter, double d, double d2) {
        if (barycenter == null || barycenter.sizeNodes == 0 || barycenter.parent == null) {
            return new Coords(0.0, 0.0);
        }
        int n = barycenter.sizeNodes;
        int n2 = barycenter.parent.sizeNodes;
        if (n == n2) {
            return new Coords(0.0, 0.0);
        }
        double d3 = (barycenter.parent.x * (double)n2 - barycenter.x * (double)n) / (double)(n2 - n);
        double d4 = (barycenter.parent.y * (double)n2 - barycenter.y * (double)n) / (double)(n2 - n);
        double d5 = barycenter.x + d - d3;
        double d6 = barycenter.y + d2 - d4;
        if (d5 == 0.0 && d6 == 0.0) {
            d5 = Math.random() - 0.5;
            d6 = Math.random() - 0.5;
        }
        double d7 = My.square((barycenter.width + barycenter.parent.width + 1.0) * d5) + My.square((barycenter.height + barycenter.parent.height + 1.0) * d6);
        double d8 = My.square(this.nodeCharge) * (double)n * barycenter.degree * (double)n2 * barycenter.parent.degree / Math.pow(d7, 1.5);
        return new Coords(d8 * d5, d8 * d6).add(this.repulsionForce(barycenter.parent, d * (double)n / (double)n2, d2 * (double)n / (double)n2));
    }

    private synchronized double repulsionEnergy(Barycenter barycenter, double d, double d2) {
        if (barycenter == null || barycenter.sizeNodes == 0 || barycenter.parent == null) {
            return 0.0;
        }
        int n = barycenter.sizeNodes;
        int n2 = barycenter.parent.sizeNodes;
        if (n == n2) {
            return 0.0;
        }
        double d3 = (barycenter.parent.x * (double)n2 - barycenter.x * (double)n) / (double)(n2 - n);
        double d4 = (barycenter.parent.y * (double)n2 - barycenter.y * (double)n) / (double)(n2 - n);
        double d5 = barycenter.x + d - d3;
        double d6 = barycenter.y + d2 - d4;
        if (d5 == 0.0 && d6 == 0.0) {
            d5 = Math.random() - 0.5;
            d6 = Math.random() - 0.5;
        }
        double d7 = My.square((barycenter.width + barycenter.parent.width + 1.0) * d5) + My.square((barycenter.height + barycenter.parent.height + 1.0) * d6);
        double d8 = My.square(this.nodeCharge) * (double)n * barycenter.degree * (double)n2 * barycenter.parent.degree;
        return d8 / Math.sqrt(d7) + this.repulsionEnergy(barycenter.parent, d * (double)n / (double)n2, d2 * (double)n / (double)n2);
    }

    private synchronized double quadApprox(Barycenter barycenter, double d, Coords coords) {
        double d2;
        double d3;
        double d4 = this.groupEnergy(barycenter, coords.x, coords.y);
        double d5 = (d4 - (d3 = this.groupEnergy(barycenter, -coords.x, -coords.y))) / 2.0;
        double d6 = -d5 / (2.0 * (d2 = d4 + d3 - 2.0 * d));
        double d7 = this.groupEnergy(barycenter, d6 * coords.x, d6 * coords.y);
        if (d7 < d) {
            barycenter.translate(d6 * coords.x, d6 * coords.y);
            return d - d7;
        }
        return 0.0;
    }

    private synchronized double locallyImprove(Barycenter barycenter) {
        double d = this.localEnergy(barycenter);
        int n = 0;
        while (n < barycenter.sizeNodes) {
            this.locallyImprove(barycenter.nodes[n]);
            ++n;
        }
        return this.localEnergy(barycenter) - d;
    }

    private synchronized double locallyImprove(Node node) {
        if (node.degree == 0 || node.fixed || !node.placed) {
            return 0.0;
        }
        Coords coords = this.localForce(node, 0.0, 0.0);
        double d = Math.sqrt(My.square(coords.x) + My.square(coords.y));
        if (d == 0.0) {
            return 0.0;
        }
        coords.x /= d;
        coords.y /= d;
        double d2 = this.localEnergy(node, 0.0, 0.0);
        double d3 = this.quadApprox(node, d2, coords);
        if (d3 == 0.0) {
            double d4 = coords.x;
            coords.x = coords.y;
            coords.y = -d4;
            if ((d3 += this.quadApprox(node, d2 + d3, coords)) == 0.0) {
                coords.x = Math.random();
                coords.y = Math.random();
                d3 += this.quadApprox(node, d2 + d3, coords);
            }
        }
        return d3;
    }

    private synchronized Coords localForce(Node node, double d, double d2) {
        Coords coords = new Coords(0.0, 0.0);
        int n = 0;
        while (n < node.degree) {
            coords.add(this.springForce(node, node.incidentEdges[n], d, d2));
            ++n;
        }
        Barycenter barycenter = node.barycenter;
        double d3 = barycenter.sizeNodes;
        if (d3 > 1.0) {
            double d4 = (barycenter.x * d3 - node.x) / (d3 - 1.0);
            double d5 = (barycenter.y * d3 - node.y) / (d3 - 1.0);
            double d6 = (barycenter.width * d3 - (double)node.width) / (d3 - 1.0);
            double d7 = (barycenter.height * d3 - (double)node.height) / (d3 - 1.0);
            double d8 = (barycenter.degree * d3 - (double)node.degree) / (d3 - 1.0);
            double d9 = node.x + d - d4;
            double d10 = node.y + d2 - d5;
            if (d9 == 0.0 && d10 == 0.0) {
                d9 = Math.random() - 0.5;
                d10 = Math.random() - 0.5;
            }
            double d11 = My.square(((double)node.width + d6 + 1.0) * d9) + My.square(((double)node.height + d7 + 1.0) * d10);
            double d12 = My.square(this.nodeCharge) * (d3 - 1.0) * (double)node.degree * d8 / Math.pow(d11, 1.5);
            coords.x += d12 * d9;
            coords.y += d12 * d10;
        }
        Coords coords2 = this.repulsionForce(node.barycenter, d / d3, d2 / d3);
        coords.x += coords2.x;
        coords.y += coords2.y;
        return coords;
    }

    private synchronized double localEnergy(Node node, double d, double d2) {
        double d3;
        double d4 = 0.0;
        int n = 0;
        while (n < node.degree) {
            d4 += this.springEnergy(node.incidentEdges[n], node, d, d2);
            ++n;
        }
        Barycenter barycenter = node.barycenter;
        double d5 = barycenter.sizeNodes;
        if (d5 > 1.0) {
            d3 = (barycenter.x * d5 - node.x) / (d5 - 1.0);
            double d6 = (barycenter.y * d5 - node.y) / (d5 - 1.0);
            double d7 = (barycenter.width * d5 - (double)node.width) / (d5 - 1.0);
            double d8 = (barycenter.height * d5 - (double)node.height) / (d5 - 1.0);
            double d9 = (barycenter.degree * d5 - (double)node.degree) / (d5 - 1.0);
            double d10 = node.x + d - d3;
            double d11 = node.y + d2 - d6;
            if (d10 == 0.0 && d11 == 0.0) {
                return 1.7976931348623156E306;
            }
            double d12 = My.square(((double)node.width + d7 + 1.0) * d10) + My.square(((double)node.height + d8 + 1.0) * d11);
            double d13 = My.square(this.nodeCharge) * (d5 - 1.0) * (double)node.degree * d9;
            d4 += d13 / Math.sqrt(d12);
        }
        d3 = this.repulsionEnergy(node.barycenter, d / d5, d2 / d5);
        return d4 + d3;
    }

    private synchronized double localEnergy(Barycenter barycenter) {
        double d = 0.0;
        int n = 0;
        while (n < barycenter.sizeNodes) {
            d += this.localEnergy(barycenter.nodes[n], 0.0, 0.0);
            ++n;
        }
        return d;
    }

    private synchronized double quadApprox(Node node, double d, Coords coords) {
        double d2;
        double d3;
        double d4 = this.localEnergy(node, coords.x, coords.y);
        double d5 = (d4 - (d3 = this.localEnergy(node, -coords.x, -coords.y))) / 2.0;
        double d6 = -d5 / (2.0 * (d2 = d4 + d3 - 2.0 * d));
        double d7 = this.localEnergy(node, d6 * coords.x, d6 * coords.y);
        if (d7 < d) {
            double d8 = node.x + d6 * coords.x;
            double d9 = node.y + d6 * coords.y;
            node.barycenter.moveNode(node, d8, d9);
            node.x = d8;
            node.y = d9;
            return d - d7;
        }
        return 0.0;
    }
}

