/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.util.HashMap;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibFileRef;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.type.ObjectIdentifierType;
import net.percederberg.mibble.value.ObjectIdentifierValue;

class DefaultContext
implements MibContext {
    public static final String CCITT = "ccitt";
    public static final String ISO = "iso";
    public static final String JOINT_ISO_CCITT = "joint-iso-ccitt";
    private HashMap<String, MibSymbol> symbols = new HashMap();

    DefaultContext() {
        this.initialize();
    }

    private void initialize() {
        this.symbols.put(CCITT, this.createRootOid(CCITT, 0));
        this.symbols.put(ISO, this.createRootOid(ISO, 1));
        this.symbols.put(JOINT_ISO_CCITT, this.createRootOid(JOINT_ISO_CCITT, 2));
    }

    private MibValueSymbol createRootOid(String name, int value) {
        ObjectIdentifierValue oid = new ObjectIdentifierValue(name, value);
        MibValueSymbol sym = new MibValueSymbol(new MibFileRef(), null, name, new ObjectIdentifierType(), oid);
        oid.setSymbol(sym);
        return sym;
    }

    @Override
    public MibSymbol findSymbol(String name, boolean expanded) {
        return this.symbols.get(name);
    }

    public ObjectIdentifierValue findOid(String oid) {
        MibValue value = ((MibValueSymbol)this.symbols.get(ISO)).getValue();
        ObjectIdentifierValue match = ((ObjectIdentifierValue)value).find(oid);
        if (match == null) {
            value = ((MibValueSymbol)this.symbols.get(CCITT)).getValue();
            match = ((ObjectIdentifierValue)value).find(oid);
        }
        if (match == null) {
            value = ((MibValueSymbol)this.symbols.get(JOINT_ISO_CCITT)).getValue();
            match = ((ObjectIdentifierValue)value).find(oid);
        }
        return match;
    }

    public String toString() {
        return "<defaults>";
    }
}

