/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import uk.co.westhawk.snmp.beans.UsmDiscoveryBean;
import uk.co.westhawk.snmp.event.RequestPduListener;
import uk.co.westhawk.snmp.pdu.DiscoveryPdu;
import uk.co.westhawk.snmp.stack.AbstractSnmpContext;
import uk.co.westhawk.snmp.stack.AsnDecoderv3;
import uk.co.westhawk.snmp.stack.AsnEncoderv3;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnPduSequence;
import uk.co.westhawk.snmp.stack.AsnSequence;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.stack.DefaultUsmAgent;
import uk.co.westhawk.snmp.stack.EncodingException;
import uk.co.westhawk.snmp.stack.ListeningContextPool;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContextv3Face;
import uk.co.westhawk.snmp.stack.TimeWindow;
import uk.co.westhawk.snmp.stack.TimeWindowNode;
import uk.co.westhawk.snmp.stack.UsmAgent;
import uk.co.westhawk.snmp.util.SnmpUtilities;

public abstract class SnmpContextv3Basis
extends AbstractSnmpContext
implements SnmpContextv3Face,
Cloneable {
    private static final String version_id = "@(#)$Id: SnmpContextv3Basis.java,v 3.17 2009/03/05 15:51:42 birgita Exp $ Copyright Westhawk Ltd";
    protected String userName = "initial";
    protected boolean useAuthentication = false;
    protected String userAuthenticationPassword;
    protected byte[] userAuthKeyMD5 = null;
    protected byte[] userAuthKeySHA1 = null;
    protected int authenticationProtocol = 0;
    protected int privacyProtocol = 2;
    protected boolean usePrivacy = false;
    protected String userPrivacyPassword;
    protected byte[] userPrivKeyMD5 = null;
    protected byte[] userPrivKeySHA1 = null;
    protected byte[] contextEngineId = new byte[0];
    protected String contextName = "";
    protected UsmAgent usmAgent = null;
    private Hashtable msgIdHash = new Hashtable(20);
    private static int next_id = 1;

    public SnmpContextv3Basis(String host, int port) throws IOException {
        this(host, port, null, "Standard");
    }

    public SnmpContextv3Basis(String host, int port, String typeSocketA) throws IOException {
        this(host, port, null, typeSocketA);
    }

    public SnmpContextv3Basis(String host, int port, String bindAddress, String typeSocketA) throws IOException {
        super(host, port, bindAddress, typeSocketA);
        if (TimeWindow.getCurrent() == null) {
            TimeWindow timew = new TimeWindow();
        }
        this.setUsmAgent(this.createUsmAgent());
    }

    public int getVersion() {
        return 3;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String newUserName) {
        this.userName = newUserName;
    }

    public boolean isUseAuthentication() {
        return this.useAuthentication;
    }

    public void setUseAuthentication(boolean newUseAuthentication) {
        this.useAuthentication = newUseAuthentication;
    }

    public String getUserAuthenticationPassword() {
        return this.userAuthenticationPassword;
    }

    public void setUserAuthenticationPassword(String newUserAuthPassword) {
        if (newUserAuthPassword != null && !newUserAuthPassword.equals(this.userAuthenticationPassword)) {
            this.userAuthenticationPassword = newUserAuthPassword;
            this.userAuthKeyMD5 = null;
            this.userAuthKeySHA1 = null;
        }
    }

    public void setAuthenticationProtocol(int protocol) throws IllegalArgumentException {
        if (protocol == 0 || protocol == 1) {
            if (protocol != this.authenticationProtocol) {
                this.authenticationProtocol = protocol;
            }
        } else {
            throw new IllegalArgumentException("Authentication Protocol should be MD5 or SHA1");
        }
    }

    public int getAuthenticationProtocol() {
        return this.authenticationProtocol;
    }

    public void setPrivacyProtocol(int protocol) throws IllegalArgumentException {
        if (protocol == 2 || protocol == 3) {
            if (protocol != this.privacyProtocol) {
                this.privacyProtocol = protocol;
            }
        } else {
            throw new IllegalArgumentException("Privacy Encryption should be AES or DES");
        }
    }

    public int getPrivacyProtocol() {
        return this.privacyProtocol;
    }

    byte[] getAuthenticationPasswordKeyMD5() {
        if (this.userAuthKeyMD5 == null) {
            this.userAuthKeyMD5 = SnmpUtilities.passwordToKeyMD5(this.userAuthenticationPassword);
        }
        return this.userAuthKeyMD5;
    }

    byte[] getAuthenticationPasswordKeySHA1() {
        if (this.userAuthKeySHA1 == null) {
            this.userAuthKeySHA1 = SnmpUtilities.passwordToKeySHA1(this.userAuthenticationPassword);
        }
        return this.userAuthKeySHA1;
    }

    byte[] getPrivacyPasswordKeyMD5() {
        if (this.userPrivKeyMD5 == null) {
            this.userPrivKeyMD5 = SnmpUtilities.passwordToKeyMD5(this.userPrivacyPassword);
        }
        return this.userPrivKeyMD5;
    }

    byte[] getPrivacyPasswordKeySHA1() {
        if (this.userPrivKeySHA1 == null) {
            this.userPrivKeySHA1 = SnmpUtilities.passwordToKeySHA1(this.userPrivacyPassword);
        }
        return this.userPrivKeySHA1;
    }

    public boolean isUsePrivacy() {
        return this.usePrivacy;
    }

    public void setUsePrivacy(boolean newUsePrivacy) {
        this.usePrivacy = newUsePrivacy;
    }

    public String getUserPrivacyPassword() {
        return this.userPrivacyPassword;
    }

    public void setUserPrivacyPassword(String newUserPrivacyPassword) {
        if (newUserPrivacyPassword != null && !newUserPrivacyPassword.equals(this.userPrivacyPassword)) {
            this.userPrivacyPassword = newUserPrivacyPassword;
            this.userPrivKeyMD5 = null;
            this.userPrivKeySHA1 = null;
        }
    }

    public void setContextEngineId(byte[] newContextEngineId) throws IllegalArgumentException {
        if (newContextEngineId == null) {
            throw new IllegalArgumentException("contextEngineId is null");
        }
        this.contextEngineId = newContextEngineId;
    }

    public byte[] getContextEngineId() {
        return this.contextEngineId;
    }

    public void setContextName(String newContextName) {
        this.contextName = newContextName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public boolean addDiscoveryPdu(DiscoveryPdu pdu) throws IOException, PduException {
        return this.addPdu(pdu, false);
    }

    public boolean addPdu(Pdu pdu) throws IOException, PduException {
        return this.addPdu(pdu, true);
    }

    protected UsmAgent createUsmAgent() {
        return new DefaultUsmAgent();
    }

    public void setUsmAgent(UsmAgent agent) {
        this.usmAgent = agent;
    }

    public UsmAgent getUsmAgent() {
        return this.usmAgent;
    }

    protected boolean addPdu(Pdu pdu, boolean checkDiscovery) throws IOException, PduException {
        Integer msgId = pdu.snmpv3MsgId;
        if (msgId == null) {
            msgId = new Integer(next_id++);
        } else if (pdu.isExpectingResponse()) {
            msgId = new Integer(next_id++);
        }
        pdu.snmpv3MsgId = msgId;
        this.msgIdHash.put(msgId, new Integer(pdu.req_id));
        if (AsnObject.debug > 6) {
            System.out.println(this.getClass().getName() + ".addPdu(): msgId=" + msgId.toString() + ", Pdu reqId=" + pdu.req_id);
        }
        if (checkDiscovery && !this.isAuthoritative(pdu.getMsgType())) {
            this.discoverIfNeeded(pdu);
        }
        boolean added = super.addPdu(pdu);
        return added;
    }

    public synchronized boolean removePdu(int rid) {
        boolean removed = super.removePdu(rid);
        if (removed) {
            Enumeration keys = this.msgIdHash.keys();
            Integer msgIdI = null;
            boolean found = false;
            while (keys.hasMoreElements() && !found) {
                msgIdI = (Integer)keys.nextElement();
                Integer pduIdI = (Integer)this.msgIdHash.get(msgIdI);
                found = pduIdI == rid;
            }
            if (found) {
                this.msgIdHash.remove(msgIdI);
            }
        }
        return removed;
    }

    public byte[] encodeDiscoveryPacket(byte msg_type, int rId, int errstat, int errind, Enumeration ve, Object obj) throws IOException, EncodingException {
        String engineId = "";
        TimeWindow tWindow = TimeWindow.getCurrent();
        if (tWindow.isSnmpEngineIdKnown(this.getSendToHostAddress(), this.hostPort)) {
            engineId = tWindow.getSnmpEngineId(this.getSendToHostAddress(), this.hostPort);
        }
        TimeWindowNode node = new TimeWindowNode(engineId, 0, 0);
        return this.actualEncodePacket(msg_type, rId, errstat, errind, ve, node, obj);
    }

    public byte[] encodePacket(byte msg_type, int rId, int errstat, int errind, Enumeration ve, Object obj) throws IOException, EncodingException {
        TimeWindowNode node = null;
        if (this.isDestroyed) {
            throw new EncodingException("Context can no longer be used, since it is already destroyed");
        }
        TimeWindow tWindow = TimeWindow.getCurrent();
        if (this.isAuthoritative(msg_type)) {
            this.usmAgent.setSnmpContext(this);
            if (this.usmAgent.getSnmpEngineId() == null) {
                throw new EncodingException("UsmAgent " + this.usmAgent.getClass().getName() + " should provide Engine ID!");
            }
            tWindow.updateTimeWindow(this.usmAgent.getSnmpEngineId(), this.usmAgent.getSnmpEngineBoots(), this.usmAgent.getSnmpEngineTime(), this.isUseAuthentication());
            node = tWindow.getTimeLine(this.usmAgent.getSnmpEngineId());
        } else {
            if (!tWindow.isSnmpEngineIdKnown(this.getSendToHostAddress(), this.hostPort)) {
                throw new EncodingException("Engine ID of host " + this.getSendToHostAddress() + ", port " + this.hostPort + " is unknown (rId=" + rId + "). Perform discovery.");
            }
            String engineId = tWindow.getSnmpEngineId(this.getSendToHostAddress(), this.hostPort);
            node = new TimeWindowNode(engineId, 0, 0);
            if (this.isUseAuthentication()) {
                if (tWindow.isTimeLineKnown(engineId)) {
                    node = tWindow.getTimeLine(engineId);
                } else {
                    throw new EncodingException("Time Line of Engine ID of host " + this.getSendToHostAddress() + ", port " + this.hostPort + " is unknown. " + "Perform discovery.");
                }
            }
        }
        return this.actualEncodePacket(msg_type, rId, errstat, errind, ve, node, obj);
    }

    protected String checkContextSanity() {
        String ret = null;
        if (this.usePrivacy) {
            if (this.userPrivacyPassword == null) {
                ret = "userPrivacyPassword is null, but usePrivacy is true";
            } else if (this.userPrivacyPassword.length() == 0) {
                ret = "userPrivacyPassword is empty, but usePrivacy is true";
            } else if (!this.useAuthentication) {
                ret = "useAuthentication is false, but usePrivacy is true";
            }
        }
        if (this.useAuthentication) {
            if (this.userAuthenticationPassword == null) {
                ret = "userAuthenticationPassword is null, but useAuthentication is true";
            } else if (this.userAuthenticationPassword.length() == 0) {
                ret = "userAuthenticationPassword is empty, but useAuthentication is true";
            }
        }
        return ret;
    }

    protected byte[] actualEncodePacket(byte msg_type, int rId, int errstat, int errind, Enumeration ve, TimeWindowNode node, Object obj) throws IOException, EncodingException {
        AsnEncoderv3 enc = new AsnEncoderv3();
        String msg = this.checkContextSanity();
        if (msg != null) {
            throw new EncodingException(msg);
        }
        int msgId = (Integer)obj;
        if (AsnObject.debug > 6) {
            System.out.println(this.getClass().getName() + ".actualEncodePacket(): msgId=" + msgId + ", Pdu reqId=" + rId);
        }
        byte[] packet = enc.EncodeSNMPv3(this, msgId, node, msg_type, rId, errstat, errind, ve);
        return packet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processIncomingResponse(ByteArrayInputStream in) throws DecodingException, IOException {
        AsnDecoderv3 rpdu = new AsnDecoderv3();
        byte[] bu = null;
        int nb = in.available();
        bu = new byte[nb];
        in.read(bu);
        in = new ByteArrayInputStream(bu);
        AsnSequence asnTopSeq = rpdu.DecodeSNMPv3(in);
        int msgId = rpdu.getMsgId(asnTopSeq);
        Integer rid = (Integer)this.msgIdHash.get(new Integer(msgId));
        if (rid != null) {
            if (AsnObject.debug > 6) {
                System.out.println(this.getClass().getName() + ".processIncomingResponse(): msgId=" + msgId + ", Pdu reqId=" + rid);
            }
            Pdu pdu = this.getPdu(rid);
            try {
                AsnPduSequence pduSeq = rpdu.processSNMPv3(this, asnTopSeq, bu, false);
                if (pduSeq != null) {
                    Integer rid2 = new Integer(pduSeq.getReqId());
                    if (AsnObject.debug > 6) {
                        System.out.println(this.getClass().getName() + ".processIncomingResponse():" + " rid2=" + rid2);
                    }
                    Pdu newPdu = null;
                    if (rid2.intValue() != rid.intValue()) {
                        newPdu = this.getPdu(rid2);
                        if (AsnObject.debug > 3) {
                            System.out.println(this.getClass().getName() + ".processIncomingResponse(): " + "pduReqId of msgId (" + rid + ") != pduReqId of Pdu (" + rid2 + ")");
                        }
                        if (newPdu == null && AsnObject.debug > 3) {
                            System.out.println(this.getClass().getName() + ".processIncomingResponse(): " + "Using pduReqId of msgId (" + rid + ")");
                        }
                    }
                    if (newPdu != null) {
                        pdu = newPdu;
                    }
                } else if (AsnObject.debug > 6) {
                    System.out.println(this.getClass().getName() + ".processIncomingResponse():" + " pduSeq is null.");
                }
                if (pdu != null) {
                    pdu.fillin(pduSeq);
                    return;
                }
                if (AsnObject.debug <= 6) return;
                System.out.println(this.getClass().getName() + ".processIncomingResponse(): No Pdu with reqid " + rid);
                return;
            }
            catch (DecodingException exc) {
                if (pdu == null) throw exc;
                pdu.setErrorStatus(19, exc);
                pdu.fillin(null);
                return;
            }
        } else {
            if (AsnObject.debug > 3) {
                System.out.println(this.getClass().getName() + ".processIncomingResponse(): Pdu of msgId " + msgId + " is already answered");
            }
            rid = new Integer(-1);
        }
    }

    protected boolean isAuthoritative(byte msg_type) {
        return msg_type == -94 || msg_type == -89 || msg_type == -88;
    }

    void discoverIfNeeded(Pdu pdu) throws IOException, PduException {
        UsmDiscoveryBean discBean = null;
        boolean isNeeded = false;
        TimeWindow tWindow = TimeWindow.getCurrent();
        String engineId = tWindow.getSnmpEngineId(this.getSendToHostAddress(), this.hostPort);
        if (engineId == null) {
            isNeeded = true;
            discBean = new UsmDiscoveryBean(this.getSendToHostAddress(), this.hostPort, this.bindAddr, this.typeSocket);
            discBean.setRetryIntervals(pdu.getRetryIntervals());
        }
        if (this.isUseAuthentication()) {
            if (isNeeded) {
                discBean.setAuthenticationDetails(this.userName, this.userAuthenticationPassword, this.authenticationProtocol);
            } else if (!tWindow.isTimeLineKnown(engineId)) {
                isNeeded = true;
                discBean = new UsmDiscoveryBean(this.getSendToHostAddress(), this.hostPort, this.bindAddr, this.typeSocket);
                discBean.setAuthenticationDetails(this.userName, this.userAuthenticationPassword, this.authenticationProtocol);
                discBean.setRetryIntervals(pdu.getRetryIntervals());
            }
            if (isNeeded && this.isUsePrivacy()) {
                discBean.setPrivacyDetails(this.userPrivacyPassword, this.privacyProtocol);
            }
        }
        if (isNeeded) {
            discBean.startDiscovery();
        }
        if (this.contextEngineId == null || this.contextEngineId.length == 0) {
            engineId = tWindow.getSnmpEngineId(this.getSendToHostAddress(), this.hostPort);
            this.setContextEngineId(SnmpUtilities.toBytes(engineId));
        }
    }

    public void addRequestPduListener(RequestPduListener l, ListeningContextPool lcontext) throws IOException {
        super.addRequestPduListener(l, lcontext);
        this.usmAgent.setSnmpContext(this);
        TimeWindow tWindow = TimeWindow.getCurrent();
        if (this.usmAgent.getSnmpEngineId() == null) {
            throw new IOException("UsmAgent " + this.usmAgent.getClass().getName() + " should provide Engine ID!");
        }
        tWindow.setSnmpEngineId("_myusmagent", this.hostPort, this.usmAgent.getSnmpEngineId());
        tWindow.updateTimeWindow(this.usmAgent.getSnmpEngineId(), this.usmAgent.getSnmpEngineBoots(), this.usmAgent.getSnmpEngineTime(), this.isUseAuthentication());
    }

    public Object cloneParameters(SnmpContextv3Face clContext) {
        clContext.setUserName(new String(this.userName));
        clContext.setUseAuthentication(this.useAuthentication);
        if (this.userAuthenticationPassword != null) {
            clContext.setUserAuthenticationPassword(new String(this.userAuthenticationPassword));
        }
        clContext.setAuthenticationProtocol(this.authenticationProtocol);
        clContext.setUsePrivacy(this.usePrivacy);
        if (this.userPrivacyPassword != null) {
            clContext.setUserPrivacyPassword(new String(this.userPrivacyPassword));
        }
        clContext.setPrivacyProtocol(this.privacyProtocol);
        clContext.setContextName(new String(this.contextName));
        int l = this.contextEngineId.length;
        byte[] newContextEngineId = new byte[l];
        System.arraycopy(this.contextEngineId, 0, newContextEngineId, 0, l);
        clContext.setContextEngineId(newContextEngineId);
        clContext.setUsmAgent(this.usmAgent);
        return clContext;
    }

    public String getHashKey() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.hostname);
        buffer.append("_").append(this.hostPort);
        buffer.append("_").append(this.bindAddr);
        buffer.append("_").append(this.typeSocket);
        buffer.append("_").append(this.useAuthentication);
        buffer.append("_").append(SnmpContextv3Face.ProtocolNames[this.authenticationProtocol]);
        buffer.append("_").append(SnmpContextv3Face.ProtocolNames[this.privacyProtocol]);
        buffer.append("_").append(this.userAuthenticationPassword);
        buffer.append("_").append(this.userName);
        buffer.append("_").append(this.usePrivacy);
        buffer.append("_").append(this.userPrivacyPassword);
        buffer.append("_").append(SnmpUtilities.toHexString(this.contextEngineId));
        buffer.append("_").append(this.contextName);
        buffer.append("_v").append(this.getVersion());
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName() + "[");
        buffer.append("host=").append(this.hostname);
        buffer.append(", sendToHost=").append(this.getSendToHostAddress());
        buffer.append(", port=").append(this.hostPort);
        buffer.append(", bindAddress=").append(this.bindAddr);
        buffer.append(", socketType=").append(this.typeSocket);
        buffer.append(", contextEngineId=").append(SnmpUtilities.toHexString(this.contextEngineId));
        buffer.append(", contextName=").append(this.contextName);
        buffer.append(", userName=").append(this.userName);
        buffer.append(", useAuthentication=").append(this.useAuthentication);
        buffer.append(", authenticationProtocol=").append(SnmpContextv3Face.ProtocolNames[this.authenticationProtocol]);
        buffer.append(", userAuthenticationPassword=").append(this.userAuthenticationPassword);
        buffer.append(", usePrivacy=").append(this.usePrivacy);
        buffer.append(", privacyProtocol=").append(SnmpContextv3Face.ProtocolNames[this.privacyProtocol]);
        buffer.append(", userPrivacyPassword=").append(this.userPrivacyPassword);
        buffer.append(", #trapListeners=").append(this.trapSupport.getListenerCount());
        buffer.append(", #pduListeners=").append(this.pduSupport.getListenerCount());
        buffer.append("]");
        return buffer.toString();
    }
}

