/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.math.BigInteger;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibFileRef;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.StringValue;

public class ValueRangeConstraint
implements Constraint {
    private MibFileRef fileRef;
    private MibValue lower;
    private MibValue upper;
    private boolean strictLower;
    private boolean strictUpper;

    public ValueRangeConstraint(MibFileRef fileRef, MibValue lower, boolean strictLower, MibValue upper, boolean strictUpper) {
        this.fileRef = fileRef;
        this.lower = lower;
        this.upper = upper;
        this.strictLower = strictLower;
        this.strictUpper = strictUpper;
    }

    @Override
    public void initialize(MibType type, MibLoaderLog log) throws MibException {
        if (this.lower != null) {
            this.lower = this.lower.initialize(log, type);
        }
        if (this.upper != null) {
            this.upper = this.upper.initialize(log, type);
        }
        if (this.fileRef != null && !this.isCompatible(type)) {
            String msg = "value range constraint not compatible with this type";
            log.addWarning(this.fileRef, msg);
        }
        this.fileRef = null;
    }

    @Override
    public boolean isCompatible(MibType type) {
        return !(type != null && this.lower != null && !type.isCompatible(this.lower) || type != null && this.upper != null && !type.isCompatible(this.upper));
    }

    @Override
    public boolean isCompatible(MibValue value) {
        return !(this.lower != null && !this.isLessThan(this.strictLower, this.lower, value) || this.upper != null && !this.isLessThan(this.strictUpper, value, this.upper));
    }

    public boolean isCompatible(Number value) {
        Number low = null;
        if (this.lower instanceof NumberValue) {
            low = (Number)this.lower.toObject();
        }
        Number high = null;
        if (this.upper instanceof NumberValue) {
            high = (Number)this.upper.toObject();
        }
        return !(low != null && !this.isLessThan(this.strictLower, low, value) || high != null && !this.isLessThan(this.strictUpper, value, high));
    }

    private boolean isLessThan(boolean strict, MibValue value1, MibValue value2) {
        if (value1 instanceof NumberValue && value2 instanceof NumberValue) {
            return this.isLessThan(strict, (Number)value1.toObject(), (Number)value2.toObject());
        }
        if (value1 instanceof StringValue && value2 instanceof StringValue) {
            return this.isLessThan(strict, (String)value1.toObject(), (String)value2.toObject());
        }
        return false;
    }

    private boolean isLessThan(boolean strict, Number value1, Number value2) {
        if (value1 instanceof Float) {
            return value1.floatValue() == Float.NEGATIVE_INFINITY;
        }
        if (value2 instanceof Float) {
            return value1.floatValue() == Float.POSITIVE_INFINITY;
        }
        return this.isLessThan(strict, new BigInteger(value1.toString()), new BigInteger(value2.toString()));
    }

    private boolean isLessThan(boolean strict, BigInteger value1, BigInteger value2) {
        if (strict) {
            return value1.compareTo(value2) < 0;
        }
        return value1.compareTo(value2) <= 0;
    }

    private boolean isLessThan(boolean strict, String value1, String value2) {
        if (strict) {
            return value1.compareTo(value2) < 0;
        }
        return value1.compareTo(value2) <= 0;
    }

    public MibValue getLowerBound() {
        return this.lower;
    }

    public MibValue getUpperBound() {
        return this.upper;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.lower == null) {
            buffer.append("MIN");
        } else {
            buffer.append(this.lower);
        }
        if (this.strictLower) {
            buffer.append("<");
        }
        buffer.append("..");
        if (this.strictUpper) {
            buffer.append("<");
        }
        if (this.upper == null) {
            buffer.append("MAX");
        } else {
            buffer.append(this.upper);
        }
        return buffer.toString();
    }
}

