/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.browser;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.percederberg.mibble.MibLocator;
import net.percederberg.mibble.MibSource;
import net.percederberg.mibble.MibbleBrowser;

public class OpenDialog
extends JDialog {
    public static String lastDir = System.getProperty("user.dir", ".");
    public String[] mibs = null;
    private JTree tree;
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode();

    public OpenDialog(JFrame parent, MibbleBrowser browser) {
        super((Frame)parent, true);
        this.initialize();
        this.buildTree(browser);
        this.setLocationRelativeTo(parent);
    }

    private void initialize() {
        this.setTitle("Load MIB");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        ActionListener closeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenDialog.this.dispose();
            }
        };
        KeyStroke escKey = KeyStroke.getKeyStroke(27, 0);
        int focus = 2;
        this.getRootPane().registerKeyboardAction(closeAction, escKey, focus);
        JLabel label = new JLabel("Filter:");
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(4, 5, 4, 5);
        this.getContentPane().add((Component)label, c);
        final JTextField textField = new JTextField(15);
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                OpenDialog.this.filterTree(textField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OpenDialog.this.filterTree(textField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                OpenDialog.this.filterTree(textField.getText());
            }
        });
        c = new GridBagConstraints();
        c.gridx = 1;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 1;
        c.insets = new Insets(4, 5, 4, 5);
        this.getContentPane().add((Component)textField, c);
        this.tree = new JTree();
        ((DefaultTreeModel)this.tree.getModel()).setRoot(this.root);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    OpenDialog.this.loadMibs();
                }
            }
        });
        c = new GridBagConstraints();
        c.gridy = 1;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(4, 5, 4, 5);
        this.getContentPane().add((Component)new JScrollPane(this.tree), c);
        JButton button = new JButton("Import MIB File...");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenDialog.this.openFile();
            }
        });
        c = new GridBagConstraints();
        c.gridy = 2;
        c.gridwidth = 2;
        c.anchor = 17;
        c.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)button, c);
        button = new JButton("Cancel");
        button.addActionListener(closeAction);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 2;
        c.anchor = 13;
        c.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)button, c);
        button = new JButton("Load MIB");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenDialog.this.loadMibs();
            }
        });
        SwingUtilities.getRootPane(this).setDefaultButton(button);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 2;
        c.anchor = 13;
        c.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)button, c);
        this.pack();
    }

    private void buildTree(MibbleBrowser browser) {
        for (String dir : browser.loader.getResourceDirs()) {
            MibLocator loc = new MibLocator(this.getClass().getClassLoader(), dir);
            ArrayList<String> mibs = new ArrayList<String>();
            for (MibSource src : loc.getNameMap().values()) {
                mibs.add(src.getFile().toString());
            }
            Collections.sort(mibs);
            if (mibs.size() <= 0) continue;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(dir);
            for (String path : mibs) {
                String mibName = path.substring(dir.length() + 1);
                node.add(new DefaultMutableTreeNode(mibName));
            }
            this.root.add(node);
        }
        MibLocator mibDir = new MibLocator(new File(lastDir));
        ArrayList<File> files = new ArrayList<File>();
        for (MibSource src : mibDir.getContentMap().values()) {
            files.add(src.getFile());
        }
        if (files.size() > 0) {
            Collections.sort(files);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(lastDir);
            for (File file : files) {
                node.add(new FileTreeNode(file));
            }
            this.root.add(node);
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
    }

    protected void filterTree(String text) {
        if ((text = text.toUpperCase().trim()).isEmpty()) {
            ((DefaultTreeModel)this.tree.getModel()).setRoot(this.root);
        } else {
            DefaultMutableTreeNode newRoot = this.filterTreeNode(text, this.root);
            ((DefaultTreeModel)this.tree.getModel()).setRoot(newRoot);
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                this.tree.expandRow(i);
            }
        }
    }

    private DefaultMutableTreeNode filterTreeNode(String text, TreeNode parent) {
        DefaultMutableTreeNode newParent = new DefaultMutableTreeNode(parent.toString());
        for (int i = 0; i < parent.getChildCount(); ++i) {
            TreeNode child = parent.getChildAt(i);
            if (child.getChildCount() > 0) {
                DefaultMutableTreeNode newChild = this.filterTreeNode(text, child);
                if (newChild.getChildCount() <= 0) continue;
                newParent.add(newChild);
                continue;
            }
            if (!child.toString().toUpperCase().contains(text)) continue;
            if (child instanceof DefaultMutableTreeNode) {
                Object obj = ((DefaultMutableTreeNode)child).clone();
                newParent.add((DefaultMutableTreeNode)obj);
                continue;
            }
            newParent.add(new DefaultMutableTreeNode(child.toString()));
        }
        return newParent;
    }

    protected void loadMibs() {
        ArrayList<String> res = new ArrayList<String>();
        TreePath[] paths = this.tree.getSelectionPaths();
        for (int i = 0; paths != null && i < paths.length; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
            if (!node.isLeaf()) continue;
            res.add(node.getUserObject().toString());
        }
        if (!res.isEmpty()) {
            this.mibs = res.toArray(new String[res.size()]);
            this.dispose();
        }
    }

    protected void openFile() {
        FileDialog dialog = new FileDialog(this, "Select MIB File");
        dialog.setDirectory(lastDir);
        dialog.setVisible(true);
        if (dialog.getFile() != null) {
            File file = new File(dialog.getDirectory(), dialog.getFile());
            lastDir = dialog.getDirectory();
            this.mibs = new String[]{file.getAbsolutePath()};
        }
        this.dispose();
    }

    private class FileTreeNode
    extends DefaultMutableTreeNode {
        public FileTreeNode(File file) {
            super(file);
        }

        @Override
        public Object clone() {
            return new FileTreeNode(this.getFile());
        }

        @Override
        public String toString() {
            return this.getFile().getName();
        }

        public File getFile() {
            return (File)this.getUserObject();
        }
    }
}

