/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.browser;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LicenseDialog
extends JDialog {
    public LicenseDialog(JFrame parent) {
        super((Frame)parent, true);
        this.initialize();
        this.setLocationRelativeTo(parent);
    }

    private void initialize() {
        StringBuilder license = new StringBuilder();
        this.setTitle("Mibble License");
        this.setSize(600, 600);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        URL url = this.getClass().getClassLoader().getResource("LICENSE.txt");
        if (url == null) {
            license.append("Couldn't locate license file (LICENSE.txt).");
        } else {
            try {
                String str;
                InputStreamReader in = new InputStreamReader(url.openStream());
                BufferedReader reader = new BufferedReader(in);
                while ((str = reader.readLine()) != null) {
                    if (!str.equals("\f")) {
                        license.append(str);
                    }
                    license.append("\n");
                }
                reader.close();
            }
            catch (IOException e) {
                license.append("Error reading license file ");
                license.append("(LICENSE.txt):\n\n");
                license.append(e.getMessage());
            }
        }
        JTextArea textArea = new JTextArea(license.toString());
        textArea.setEditable(false);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(4, 5, 4, 5);
        this.getContentPane().add((Component)new JScrollPane(textArea), c);
        JButton button = new JButton("Close");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseDialog.this.dispose();
            }
        });
        c = new GridBagConstraints();
        c.gridy = 1;
        c.anchor = 10;
        c.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)button, c);
    }
}

