/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.beans;

import java.io.IOException;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import uk.co.westhawk.snmp.beans.SNMPRunBean;
import uk.co.westhawk.snmp.pdu.GetPdu_vec;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.varbind;

public class OneNTServiceBean
extends SNMPRunBean
implements Observer {
    private static final String version_id = "@(#)$Id: OneNTServiceBean.java,v 1.13 2006/01/25 18:08:56 birgit Exp $ Copyright Westhawk Ltd";
    private GetPdu_vec pdu;
    private boolean isPduInFlight;
    private Date lastUpdateDate = null;
    private String index = "";
    private String name = "";
    private String instState = "";
    private String operState = "";
    private boolean canUninst = false;
    private boolean canPause = false;
    private static final int NR_OID = 5;
    private static final String svSvcName = "1.3.6.1.4.1.77.1.2.3.1.1";
    private static final String svSvcInstalledState = "1.3.6.1.4.1.77.1.2.3.1.2";
    private static final String svSvcOperatingState = "1.3.6.1.4.1.77.1.2.3.1.3";
    private static final String svSvcCanBeUninstalled = "1.3.6.1.4.1.77.1.2.3.1.4";
    private static final String svSvcCanBePaused = "1.3.6.1.4.1.77.1.2.3.1.5";
    public static final String[] msg_inst_state = new String[]{"unknown", "uninstalled", "install pending", "uninstall pending", "installed"};
    public static final String[] msg_oper_state = new String[]{"unknown", "active", "continue pending", "pause pending", "paused"};
    public static final int cannot_be_uninstalled = 1;
    public static final int can_be_uninstalled = 2;
    public static final int cannot_be_paused = 1;
    public static final int can_be_paused = 2;

    public OneNTServiceBean() {
    }

    public OneNTServiceBean(String h, int p) {
        this(h, p, null);
    }

    public OneNTServiceBean(String h, int p, String b) {
        this();
        this.setHost(h);
        this.setPort(p);
        this.setBindAddress(b);
    }

    public void setIndex(String ind) {
        if (ind != null && ind.length() > 0) {
            this.index = ind;
        }
    }

    public String getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getInstalledState() {
        return this.instState;
    }

    public String getOperatingState() {
        return this.operState;
    }

    public boolean getCanBeUninstalled() {
        return this.canUninst;
    }

    public boolean getCanBePaused() {
        return this.canPause;
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void action() {
        if (this.isHostPortReachable()) {
            this.lastUpdateDate = new Date();
            this.isPduInFlight = false;
            this.setRunning(true);
        }
    }

    public void run() {
        while (this.context != null && this.isRunning()) {
            String ind = this.getIndex();
            if (!this.isPduInFlight && ind != null && ind.length() > 0) {
                this.isPduInFlight = true;
                this.pdu = new GetPdu_vec(this.context, 5);
                this.pdu.addObserver(this);
                this.pdu.addOid("1.3.6.1.4.1.77.1.2.3.1.1." + ind);
                this.pdu.addOid("1.3.6.1.4.1.77.1.2.3.1.2." + ind);
                this.pdu.addOid("1.3.6.1.4.1.77.1.2.3.1.3." + ind);
                this.pdu.addOid("1.3.6.1.4.1.77.1.2.3.1.4." + ind);
                this.pdu.addOid("1.3.6.1.4.1.77.1.2.3.1.5." + ind);
                try {
                    this.pdu.send();
                }
                catch (PduException exc) {
                    System.out.println("PduException " + exc.getMessage());
                }
                catch (IOException exc) {
                    System.out.println("IOException " + exc.getMessage());
                }
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void update(Observable obs, Object ov) {
        this.pdu = (GetPdu_vec)obs;
        varbind[] varbinds = (varbind[])ov;
        if (this.pdu.getErrorStatus() == 0) {
            this.name = ((AsnOctets)varbinds[0].getValue()).getValue();
            int nr = ((AsnInteger)varbinds[1].getValue()).getValue();
            this.instState = msg_inst_state[nr];
            nr = ((AsnInteger)varbinds[2].getValue()).getValue();
            this.operState = msg_oper_state[nr];
            nr = ((AsnInteger)varbinds[3].getValue()).getValue();
            this.canUninst = nr == 2;
            nr = ((AsnInteger)varbinds[4].getValue()).getValue();
            this.canPause = nr == 2;
            this.lastUpdateDate = new Date();
            this.isPduInFlight = false;
            this.firePropertyChange("NTService", null, null);
        }
    }
}

