/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.visualbasic;

import java.io.PrintWriter;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeElementContainer;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.visualbasic.VisualBasicComment;
import net.percederberg.grammatica.code.visualbasic.VisualBasicModifier;

public abstract class VisualBasicType
extends CodeElementContainer {
    protected int modifiers;
    protected String name;
    protected String[] extendTypes;
    protected VisualBasicComment comment = null;

    protected VisualBasicType(int modifiers, String name, String extendType) {
        this.modifiers = modifiers;
        this.name = name;
        if (extendType == null || extendType.equals("")) {
            this.extendTypes = new String[0];
        } else {
            this.extendTypes = new String[1];
            this.extendTypes[0] = extendType;
        }
    }

    protected VisualBasicType(int modifiers, String name, String[] extendTypes) {
        this.modifiers = modifiers;
        this.name = name;
        this.extendTypes = extendTypes;
    }

    public String toString() {
        return this.name;
    }

    public void addComment(VisualBasicComment comment) {
        this.comment = comment;
    }

    protected void print(PrintWriter out, CodeStyle style, int indent, String type) {
        StringBuffer buf = new StringBuffer();
        String indentStr = style.getIndent(indent);
        if (this.comment != null) {
            this.comment.print(out, style, indent);
        }
        buf.append(indentStr);
        buf.append(VisualBasicModifier.createModifierDecl(this.modifiers));
        buf.append(type);
        buf.append(" ");
        buf.append(this.name);
        buf.append("\n");
        for (int i = 0; i < this.extendTypes.length; ++i) {
            buf.append(style.getIndent(indent + 1));
            buf.append("Inherits ");
            buf.append(this.extendTypes[i]);
            buf.append("\n");
        }
        out.print(buf.toString());
        this.printContents(out, style, indent + 1);
        out.println(indentStr + "End " + type);
    }

    protected void printSeparator(PrintWriter out, CodeStyle style, CodeElement prev, CodeElement next) {
        if (prev != null && next != null) {
            out.println();
        }
    }
}

