/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica;

import java.util.HashMap;
import net.percederberg.grammatica.Grammar;
import net.percederberg.grammatica.GrammarAnalyzer;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.TokenPattern;

class FirstPassAnalyzer
extends GrammarAnalyzer {
    private Grammar grammar;
    private int nextTokenId = 1001;
    private int nextProductionId = 2001;
    private HashMap names = new HashMap();

    public FirstPassAnalyzer(Grammar grammar) {
        this.grammar = grammar;
    }

    protected Node exitIgnore(Token node) {
        String str = node.getImage();
        if (!(str = str.substring(7, str.length() - 1).trim()).equals("")) {
            node.addValue(str);
        }
        return node;
    }

    protected Node exitError(Token node) {
        String str = node.getImage();
        if (!(str = str.substring(6, str.length() - 1).trim()).equals("")) {
            node.addValue(str);
        }
        return node;
    }

    protected Node exitIdentifier(Token node) {
        node.addValue(node.getImage());
        return node;
    }

    protected Node exitQuotedString(Token node) {
        String str = node.getImage();
        node.addValue(str.substring(1, str.length() - 1));
        return node;
    }

    protected Node exitRegexp(Token node) {
        String str = node.getImage();
        StringBuffer buf = new StringBuffer();
        str = str.substring(2, str.length() - 2);
        for (int i = 0; i < str.length(); ++i) {
            if (str.startsWith("\\<", i)) {
                buf.append('<');
                ++i;
                continue;
            }
            if (str.startsWith("\\>", i)) {
                buf.append('>');
                ++i;
                continue;
            }
            buf.append(str.charAt(i));
        }
        node.addValue(buf.toString());
        return node;
    }

    protected Node exitHeaderPart(Production node) {
        return null;
    }

    protected Node exitHeaderDeclaration(Production node) throws ParseException {
        String name = this.getStringValue(this.getChildAt(node, 0), 0);
        String value = this.getStringValue(this.getChildAt(node, 2), 0);
        this.grammar.addDeclaration(name, value);
        return null;
    }

    protected Node exitTokenPart(Production node) {
        return null;
    }

    protected Node exitTokenDeclaration(Production node) throws ParseException {
        String name = this.getIdentifier((Token)this.getChildAt(node, 0));
        Node child = this.getChildAt(node, 2);
        int type = this.getIntValue(child, 0);
        String str = this.getStringValue(child, 1);
        TokenPattern pattern = new TokenPattern(this.nextTokenId++, name, type, str);
        if (node.getChildCount() == 4) {
            child = this.getChildAt(node, 3);
            Token token = (Token)this.getValue(child, 0);
            str = null;
            if (child.getValueCount() == 2) {
                str = this.getStringValue(child, 1);
            }
            switch (token.getId()) {
                case 1004: {
                    if (str == null) {
                        pattern.setIgnore();
                        break;
                    }
                    pattern.setIgnore(str);
                    break;
                }
                case 1005: {
                    if (str == null) {
                        pattern.setError();
                        break;
                    }
                    pattern.setError(str);
                }
            }
        }
        this.grammar.addToken(pattern, node.getStartLine(), node.getEndLine());
        return null;
    }

    protected Node exitTokenValue(Production node) throws ParseException {
        switch (this.getChildAt(node, 0).getId()) {
            case 1020: {
                node.addValue(new Integer(1));
                break;
            }
            case 1021: {
                node.addValue(new Integer(2));
            }
        }
        node.addValue(this.getStringValue(this.getChildAt(node, 0), 0));
        return node;
    }

    protected Node exitTokenHandling(Production node) throws ParseException {
        Node child = this.getChildAt(node, 0);
        node.addValue(child);
        if (child.getValueCount() > 0) {
            node.addValue(this.getValue(child, 0));
        }
        return node;
    }

    protected Node exitProductionDeclaration(Production node) throws ParseException {
        String name = this.getIdentifier((Token)this.getChildAt(node, 0));
        ProductionPattern production = new ProductionPattern(this.nextProductionId++, name);
        this.grammar.addProduction(production, node.getStartLine(), node.getEndLine());
        return node;
    }

    private String getIdentifier(Token token) throws ParseException {
        String name = token.getImage();
        StringBuffer buf = new StringBuffer(name.toUpperCase());
        if (token.getId() != 1019) {
            throw new ParseException(0, null, token.getStartLine(), token.getStartColumn());
        }
        for (int i = 0; i < buf.length(); ++i) {
            char c = buf.charAt(i);
            if ('A' <= c && c <= 'Z' || '0' <= c && c <= '9') continue;
            buf.deleteCharAt(i--);
        }
        if (this.names.containsKey(buf.toString())) {
            throw new ParseException(6, "duplicate identifier '" + name + "' is similar or " + "equal to previously defined identifier '" + this.names.get(buf.toString()) + "'", token.getStartLine(), token.getStartColumn());
        }
        this.names.put(buf.toString(), name);
        return name;
    }
}

