/*
 *(c) 2003, visigoth <visigoth@securitycentric.com>
 * This source code is distributed under a BSD license,
 * please see the LICENSE file for details
 *
 * OracleUsers.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;
import java.util.Vector;

/**
 *
 * @author  visigoth
 */
public class OracleUsers extends AbstractDatabaseProbe {
    
    /** Creates a new instance of OracleUsers */
    public OracleUsers() {
        
        setName("Oracle Users");
        setFamily("Oracle");
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        setVersion("$Id: OracleUsers.java,v 1.7 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(8);
        
        addDepends("oracle/connection");
        
        addProvides("oracle/users","Vector of strings of user names");
        addProvides("oracle/hashes","Vector of strings of password hashes");
        
        setReport("Found Oracle Users: \n");
        
        setHelp("This probe attemtps to enumerate DB users and passwords. "+
                "It will only be capable of doing so if the JDBC Connection "+
                "stored in oracle/connection has sufficient privelages\n");
    }
    
    public void probe() throws ProbeException {
        
        try {
            
            if (! kbHas("oracle/connection"))
                return;
            Vector users = new Vector();
            Vector hashes = new Vector();
            con = (Connection) kbGet("oracle/connection");
            
            Statement stmt = con.createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE,ResultSet.CONCUR_UPDATABLE);
            res = stmt.executeQuery("SELECT username,password,account_status from sys.dba_users");
            
            setReportable(true);

            addResultSet(res);

            res.beforeFirst();
            
            while (res.next()) {
                users.add(res.getString("username"));
                hashes.add(res.getString("password"));
            }
            
            kbPut("oracle/users",users);
            kbPut("oracle/hashes",hashes);
                
        } catch (SQLException se) {
            throw(new ProbeException(se.getMessage()));
        }
    }

    Connection con;
    ResultSet res;
}
