/*
 *
 * (c) 2003, visigoth <visigoth@securitycentric.com>
 *
 * OracleSysPrivs.java
 *
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;
import java.util.*;

/**
 *
 * @author  
 */
public class OracleSysPrivs extends AbstractDatabaseProbe {
    
    /** Creates a new instance of OracleSysPrivs */
    public OracleSysPrivs() {
        
        setName("Oracle System Privs");
        setFamily("Oracle");
        setVersion("$Id: OracleSysPrivs.java,v 1.2 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(29);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        setSeverity(0);
        
        addDepends("oracle/connection");
        
        setReport("Users/Roles have the following system privileges:\n"+
                  "=============================\n");
        
        setHelp("This probe audits the system level privileges assigned to each Oracle user/role.");
    }
    
    public void probe() throws ProbeException {
        
        try {
            
            if (! kbHas("oracle/connection"))
                return;

            con = (Connection) kbGet("oracle/connection");

            Statement stmt = con.createStatement();
            PreparedStatement pstmt = con.prepareStatement("select * from sys.dba_sys_privs where grantee = ?");
            
            setReportable(true);

            ResultSet res = stmt.executeQuery("select unique(grantee) from sys.dba_sys_privs");

            while (res.next()) {
                String grantee = res.getString("grantee");
                addReport("\n"+grantee);
                pstmt.setString(1,grantee);
                ResultSet subres = pstmt.executeQuery();
                while (subres.next()) {
                    addReport("\t"+subres.getString("privilege"));
                }
            }

        } catch (SQLException se) {
            throw(new ProbeException(se.getMessage()));
        }
    }
    Connection con;
    ResultSet res;
}
