/*
 *
 * (c) 2003, visigoth <visigoth@securitycentric.com>
 *
 * OracleRoleAudit.java
 *
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;
import java.util.*;

/**
 *
 * @author  
 */
public class OracleRoleAudit extends AbstractDatabaseProbe {
    
    /** Creates a new instance of OracleRoleAudit */
    public OracleRoleAudit() {
        
        setName("Oracle Role Audit");
        setFamily("Oracle");
        setVersion("$Id: OracleRoleAudit.java,v 1.4 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(28);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        setSeverity(0);
        
        addDepends("oracle/connection");
        addProvides("oracle/roles","Vector of strings for role names");
        
        setReport("The following roles and user assignments exits:\n"+
                  "=============================\n");
        
        setHelp("This probe enumerates the available roles and the subsequent user assignments from the Oracle instance.");
    }
    
    public void probe() throws ProbeException {
        
        roles = new Vector();

        try {
            
            if (! kbHas("oracle/connection"))
                return;

            con = (Connection) kbGet("oracle/connection");
            
            Statement stmt = con.createStatement();
            PreparedStatement pstmt = con.prepareStatement("select * from sys.dba_role_privs where granted_role = ?");
            res = stmt.executeQuery("SELECT * FROM sys.dba_roles");
            
            setReportable(true);

            // Get some metadata and do some formatting...
            while (res.next()) {
                String role = res.getString("role");
                roles.add(role);
                addReport("\n"+role);
                pstmt.setString(1,role);
                ResultSet subres = pstmt.executeQuery();
                while (subres.next()) {
                    addReport("\t"+subres.getString("grantee"));
                }
            }

            kbPut("oracle/roles",roles);

        } catch (SQLException se) {
            throw(new ProbeException(se.getMessage()));
        }
    }

    Connection con;
    ResultSet res;
    Vector roles;
}
