/*
 *
 * (c) 2003, visigoth <visigoth@securitycentric.com>
 *
 * OracleRbacStatus.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;
import java.util.*;

/**
 *
 * @author  
 */
public class OracleRbacStatus extends AbstractDatabaseProbe {
    
    /** Creates a new instance of OracleRbacStatus */
    public OracleRbacStatus() {
        
        setName("Oracle RBAC Status");
        setFamily("Oracle");
        setVersion("$Id: OracleRbacStatus.java,v 1.6 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(27);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        setSeverity(0);
        
        addDepends("oracle/connection");
        
        setReport("The following users have directly asigned privileges:\n");
        
        setHelp("This probe enumerates all user accounts which have directly assigned permissions.  Ideally, this should be empty or only contain default accounts such as SYS and all real users should be assigned roles exclusivly");
    }
    
    public void probe() throws ProbeException {
        
        try {
            
            if (! kbHas("oracle/connection"))
                return;

            con = (Connection) kbGet("oracle/connection");
            
            Statement stmt = con.createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE,ResultSet.CONCUR_UPDATABLE);
            res = stmt.executeQuery("select unique(username) from sys.objauth$ inner join sys.dba_users on grantee# = user_id");
            
            setReportable(true);

            addResultSet(res);

            res.last();
            count = res.getRow();

            if (20 > count && count  > 8)
                setSeverity(1);

            else if (count >= 20)
                setSeverity(2);

        } catch (SQLException se) {
            throw(new ProbeException(se.getMessage()));
        }
    }

    Connection con;
    ResultSet res;
    int count = 0;
}
