/*
 * (c) 2003, visigoth <visigoth@securitycentric.com>
 *
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

/**
 *
 * @author  visigoth
 */
public class MysqlWorldWriteFiles extends AbstractVersionProbe {
    
    /** Creates a new instance of MysqlWorldWriteFiles */
    public MysqlWorldWriteFiles() {
        
        setName("Mysql World Write Files");
        setFamily("MySQL");
        setVersion("$Id: MysqlWorldWriteFiles.java,v 1.2 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(43);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        
        addDepends("mysql/Version");
        
        setHelp("This probe checks for Mysql Version < 3.23.56 to enumerate"+
		" CVE: CAN-2003-0150 (Mysql Creates World Writable Files)");

        setReport("MySQL 3.23.55 and earlier creates world-writeable files "+
		  "and allows mysql users to gain root privileges by using " +
		  "the SELECT * INFO OUTFILE operator to overwrite a "+
		  "configuration file and cause mysql to run as root upon "+
		  "restart. CVE: CAN-2003-0150");
        setSeverity(3);

        setKbKey("mysql/Version");
        setMatchRelease(true);
        setTestVersion("3.23.56");
    }
}
