/*
 * (c) 2003, visigoth <visigoth@securitycentric.com>
 *
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

/**
 *
 * @author  visigoth
 */
public class MssqlSp2 extends AbstractVersionProbe {
    
    /** Creates a new instance of MssqlSp2 */
    public MssqlSp2() {
        
        setName("MSSQL SP2");
        setFamily("MS SQL");
        setVersion("$Id: MssqlSp2.java,v 1.7 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(24);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        
        addDepends("mssql/Version");
        
        setHelp("This probe checks for MSSQL 2000 Service Pack 2");

        setReport("MSSQL Service Pack 2 is not installed.\n\n"+
                  "Service pack two addresses multiple known exploitable\n"+
                  "security vulnerabilities.  Please see MS support for \n"+
                  "details:\n\n"+
                  "http://support.microsoft.com/default.aspx?scid=kb;[LN];306908");
        setSeverity(3);

        setKbKey("mssql/Version");
        setMatchRelease(true);
        setTestVersion("8.0.532");
    }
}
