/*
 *(c) 2003, visigoth <visigoth@securitycentric.com>
 * This source code is distributed under a BSD license,
 * please see the LICENSE file for details
 *
 * MssqlRunas.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;

/**
 *
 * @author  visigoth
 */
public class MssqlRunas extends AbstractDatabaseProbe {
    
    /** Creates a new instance of MssqlRunas */
    public MssqlRunas() {
        
        setName("MSSQL Runnnig As");
        setFamily("MS SQL");
        setVersion("$Id: MssqlRunas.java,v 1.6 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(20);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        addDepends("mssql/connection");

        setHelp("This probe checks what account the MSSQL server runs as. "+
                "It will only be capable of doing so if the JDBC Connection "+
                "stored in mssql/connection has sufficient privelages\n");
    }
    
    public void probe() throws ProbeException {
        
        try {
            
            if (! kbHas("mssql/connection"))
                return;
            
            con = (Connection) kbGet("mssql/connection");

            PreparedStatement stmt = con.prepareStatement("exec xp_regread ?,?,?");
            stmt.setString(1,"HKEY_LOCAL_MACHINE");
            stmt.setString(2,"SYSTEM\\CurrentControlSet\\Services\\MSSQLSERVER");
            stmt.setString(3,"ObjectName");

            res = stmt.executeQuery();
            
            setReportable(true);
            
            while (res.next()) {
                setReport("MSSQL Runs As "+res.getString("Data"));
                if (res.getString("Data").matches("LocalSystem"))
                    setSeverity(3);
            }

        } catch (SQLException se) {
            throw(new ProbeException("Lack of Permission? " + se.getMessage()));
        }
    }

    Connection con;
    ResultSet res;
}
