/*
 *(c) 2003, visigoth <visigoth@securitycentric.com>
 * This source code is distributed under a BSD license,
 * please see the LICENSE file for details
 *
 * MssqlLoginMode.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;

/**
 *
 * @author  visigoth
 */
public class MssqlLoginMode extends AbstractDatabaseProbe {
    
    /** Creates a new instance of MssqlLoginMode */
    public MssqlLoginMode() {
        
        setName("MSSQL Login Mode");
        setFamily("MS SQL");
        setVersion("$Id: MssqlLoginMode.java,v 1.4 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(22);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        
        addDepends("mssql/connection");

        setHelp("This probe checks the current LoginMode config of MSSQL. "+
                "It will only be capable of doing so if the JDBC Connection "+
                "stored in mssql/connection has sufficient privelages\n");
    }
    
    public void probe() throws ProbeException {
        
        try {
            
            if (! kbHas("mssql/connection"))
                return;
            
            con = (Connection) kbGet("mssql/connection");

            PreparedStatement stmt = con.prepareStatement("exec xp_regread ?,?,?");
            stmt.setString(1,"HKEY_LOCAL_MACHINE");
            stmt.setString(2,"Software\\Microsoft\\MSSQLServer\\MSSQLServer");
            stmt.setString(3,"LoginMode");

            res = stmt.executeQuery();
            
            setReportable(true);
            
            while (res.next()) {
                setReport("MSSQL Login Mode: ");

                int m = res.getInt("Data");
                switch (m) {
                    case 0:
                        addReport("SQL Only");
                        break;
                    case 1:
                        addReport("Windows Only");
                        break;
                    case 2:
                        addReport("Windows and SQL");
                        break;
                }
            }

        } catch (SQLException se) {
            throw(new ProbeException("Lack of Permission? " + se.getMessage()));
        }
    }

    Connection con;
    ResultSet res;
}
