/*
 * (c) 2003, visigoth <visigoth@securitycentric.com>
 *
 * Mssql7Sp4.java
 *
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

/**
 *
 * @author  USERNAME
 */
public class Mssql7Sp4 extends AbstractVersionProbe {
    
    /** Creates a new instance of Mssql7Sp4 */
    public Mssql7Sp4() {
        
        setName("MSSQL 7 SP4");
        setFamily("MS SQL");
        setVersion("$Id: Mssql7Sp4.java,v 1.2 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(40);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        
        addDepends("mssql/Version");
        
        setHelp("This probe checks MSSQL 7 for SP4");

        setReport("MSSQL 7 Service Pack 4 is not installed.\n\nService pack two addresses multiple known exploitable\nsecurity vulnerabilities.  Please see MS support for \ndetails:\n\nhttp://support.microsoft.com/default.aspx?scid=kb;[LN];301511");
        setSeverity(3);

        setKbKey("mssql/Version");
        setMatchRelease(true);
        setTestVersion("7.0.1063");
    }
}
