/*
 * (c) 2003, visigoth <visigoth@securitycentric.com>
 *
 * Mssql7Sp1.java
 *
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

/**
 *
 * @author  USERNAME
 */
public class Mssql7Sp1 extends AbstractVersionProbe {
    
    /** Creates a new instance of Mssql7Sp1 */
    public Mssql7Sp1() {
        
        setName("MSSQL 7 SP1");
        setFamily("MS SQL");
        setVersion("$Id: Mssql7Sp1.java,v 1.2 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(37);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        
        addDepends("mssql/Version");
        
        setHelp("This probe checks MSSQL Server 7 for having SP1");

        setReport("MSSQL 7 Service Pack 1 is not installed.\n\nService pack one addresses multiple known exploitable\nsecurity vulnerabilities.  Please see MS support for\ndetails:\n\nhttp://support.microsoft.com/default.aspx?scid=kb;[LN];301511");
        setSeverity(3);

        setKbKey("mssql/Version");
        setMatchRelease(true);
        setTestVersion("7.0.699");
    }
}
