-- $Id: OraclePortScanner.sql,v 1.1 2003/06/21 02:09:35 visigoth_6 Exp $
-- Oracle Portscanner
DECLARE
    cnt number := MIN_PORT; -- Replaced at runtime
    c  utl_tcp.connection;  -- TCP/IP connection

BEGIN

while cnt < MAX_PORT LOOP

  BEGIN
    c := utl_tcp.open_connection(remote_host => 'TARGET', 
                                 remote_port =>  cnt);  -- open connection
    dbms_output.put_line('tcp/'||cnt);

  EXCEPTION
    WHEN utl_tcp.network_error THEN NULL;
  END;

  BEGIN
    utl_tcp.close_connection(c);

  EXCEPTION
    WHEN utl_tcp.network_error THEN NULL;

  END;

  cnt := cnt+1;

END LOOP;

END;
