/*
 *
 * PROBE_COPYRIGHT
 *
 * PROBE_JAVA_NAME.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;
import java.util.*;

/**
 *
 * @author  
 */
public class PROBE_JAVA_NAME extends AbstractDatabaseProbe {
    
    /** Creates a new instance of PROBE_JAVA_NAME */
    public PROBE_JAVA_NAME() {
        
        setName("PROBE_NAME");
	setFamily("PROBE_FAMILY");
        setVersion("PROBE_VERSION");
        setProbeId(PROBE_ID);
        setCopyright("PROBE_COPYRIGHT");
        setSeverity(PROBE_SEVERITY);
        
        addDepends("PROBE_CONNECTION");
        
        setReport("PROBE_REPORT");
        
        setHelp("PROBE_HELP");
    }
    
    public void probe() throws ProbeException {
        
        try {
            
            if (! kbHas("PROBE_CONNECTION"))
                return;

            con = (Connection) kbGet("PROBE_CONNECTION");
            
            Statement stmt = con.createStatement();
            res = stmt.executeQuery("PROBE_QUERY");
            
            setReportable(true);

            cols = res.getMetaData().getColumnCount();

            for (int i = 1; i <= cols; i++) {
                colNames = colNames.concat(res.getMetaData().getColumnName(i)+"\t");
            }

            addReport("\n"+colNames);
            
            // Get some metadata and do some formatting...
            while (res.next()) {
                String line = new String();
                for (int i = 1; i <= cols; i++) {
                    String resStr = res.getString(i);

                    if (matchTest) {
                        if (resStr.matches("PROBE_MATCH_STR"))
                            matched = true;
                    }

                    line = line.concat(resStr+"\t");
                }
                addReport(line);
            }

            if (matched) {
                addReport("\n"+"PROBE_APPEND_REPORT");
                setSeverity(PROBE_APPEND_SEVERITY);
            }

        } catch (SQLException se) {
            throw(new ProbeException(se.getMessage()));
        }
    }

    Connection con;
    ResultSet res;
    boolean matched = false;
    boolean matchTest = PROBE_MATCH_TEST;
    int cols;
    String colNames = new String();
}
