/*
 *(c) 2003, visigoth <visigoth@securitycentric.com>
 * This source code is distributed under a BSD license,
 * please see the LICENSE file for details
 *
 * MssqlRegread.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;

/**
 *
 * @author  visigoth
 */
public class MssqlRegread extends AbstractDatabaseProbe {
    
    /** Creates a new instance of MssqlRegread */
    public MssqlRegread() {
        
        setName("Read Reg Entries");
	setFamily("MS SQL");
        setVersion("$Id: MssqlRegread.java,v 1.2 2003/09/21 22:44:36 visigoth_6 Exp $");
        setProbeId(-1);
        
        addDepends("mssql/connection");

        addOption("hive","HKEY_LOCAL_MACHINE");
        addOption("key","SOFTWARE\\VMware, Inc.\\VMware Tools");
        addOption("entry","InstallPath");
        
        setHelp("This probe attemtps to read the specified registry key. "+
                "It will only be capable of doing so if the JDBC Connection "+
                "stored in mssql/connection has sufficient privelages\n");
    }
    
    public void probe() throws ProbeException {
        
        try {
            
            if (! kbHas("mssql/connection"))
                return;
            
            con = (Connection) kbGet("mssql/connection");

            String hive = getOption("hive");
            String key = getOption("key");
            String entry = getOption("entry");
            
            PreparedStatement stmt = con.prepareStatement("exec xp_regread ?,?,?");
            stmt.setString(1,hive);
            stmt.setString(2,key);
            stmt.setString(3,entry);

            res = stmt.executeQuery();
            
            setReportable(true);
            setReport("Registry entries in:\n"+
                      hive+"\\"+key+"\n"+
                      "--------------------------\n");
            
            while (res.next()) {
                addReport(res.getString("Value") + "\t" + 
                          res.getString("Data") + "\n");
            }

        } catch (SQLException se) {
            throw(new ProbeException("Lack of Permission? " + se.getMessage()));
        }
    }

    Connection con;
    ResultSet res;
}
