/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.writer;

import com.sun.msv.grammar.AnyNameClass;
import com.sun.msv.grammar.ChoiceNameClass;
import com.sun.msv.grammar.DifferenceNameClass;
import com.sun.msv.grammar.Grammar;
import com.sun.msv.grammar.NameClass;
import com.sun.msv.grammar.NameClassVisitor;
import com.sun.msv.grammar.NamespaceNameClass;
import com.sun.msv.grammar.NotNameClass;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SimpleNameClass;
import com.sun.msv.writer.GrammarWriter;
import com.sun.msv.writer.SAXRuntimeException;
import com.sun.msv.writer.XMLWriter;
import com.sun.msv.writer.relaxng.Context;
import com.sun.msv.writer.relaxng.PatternWriter;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.ClassItem;
import com.sun.tools.xjc.grammar.FieldItem;
import com.sun.tools.xjc.grammar.FieldUse;
import com.sun.tools.xjc.grammar.IgnoreItem;
import com.sun.tools.xjc.grammar.InterfaceItem;
import com.sun.tools.xjc.grammar.JavaItem;
import com.sun.tools.xjc.grammar.JavaItemVisitor;
import com.sun.tools.xjc.grammar.OccurrenceExp;
import com.sun.tools.xjc.grammar.PrimitiveItem;
import com.sun.tools.xjc.grammar.SuperClassItem;
import com.sun.tools.xjc.grammar.WildcardItem;
import java.io.OutputStream;
import java.util.Stack;
import java.util.Vector;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

public class Writer
implements GrammarWriter,
Context {
    private final boolean noNS;
    private final boolean signatureOnly;
    private final XMLWriter writer = new XMLWriter();
    private final PatternWriter patternWriter = new SmartWriter(this);

    public Writer(boolean _noNS, boolean _sigOnly) {
        this.noNS = _noNS;
        this.signatureOnly = _sigOnly;
    }

    public static void writeToConsole(boolean noNS, Grammar grammar) {
        Writer.writeToConsole(noNS, false, grammar);
    }

    public static void writeToConsole(boolean noNS, boolean signatureOnly, Grammar grammar) {
        try {
            Writer w = new Writer(noNS, signatureOnly);
            OutputFormat format = new OutputFormat("xml", null, true);
            format.setIndent(1);
            w.setDocumentHandler((DocumentHandler)new XMLSerializer((OutputStream)System.out, format));
            w.write(grammar);
        }
        catch (SAXException e) {
            throw new InternalError();
        }
    }

    public XMLWriter getWriter() {
        return this.writer;
    }

    public String getTargetNamespace() {
        return null;
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.writer.setDocumentHandler(handler);
    }

    public void write(Grammar g) throws SAXException {
        this.write((AnnotatedGrammar)g);
    }

    public void write(AnnotatedGrammar grammar) throws SAXException {
        try {
            DocumentHandler handler = this.writer.getDocumentHandler();
            handler.setDocumentLocator(new LocatorImpl());
            handler.startDocument();
            this.writer.start("bgm");
            this.writer.start("root");
            grammar.getTopLevel().visit(this.patternWriter);
            this.writer.end("root");
            ClassItem[] cs = grammar.getClasses();
            int i = 0;
            while (i < cs.length) {
                this.writeClass(cs[i]);
                ++i;
            }
            InterfaceItem[] is = grammar.getInterfaces();
            int i2 = 0;
            while (i2 < is.length) {
                this.writeInterface(is[i2]);
                ++i2;
            }
            this.writer.end("bgm");
            handler.endDocument();
        }
        catch (SAXRuntimeException sre) {
            throw sre.e;
        }
    }

    private void writeClass(ClassItem item) {
        this.writer.start("class", new String[]{"name", item.getType().fullName()});
        if (item.getSuperClass() != null) {
            this.writer.element("extends", new String[]{"name", item.getSuperClass().name});
        }
        this.writer.start("field-summary");
        FieldUse[] fus = item.getDeclaredFieldUses();
        int i = 0;
        while (i < fus.length) {
            FieldUse fu = fus[i];
            Vector<String> vec = new Vector<String>();
            vec.add("name");
            vec.add(fu.name);
            vec.add("type");
            vec.add(fu.type.name());
            vec.add("occurs");
            vec.add(fu.multiplicity.toString());
            if (fu.getRealization() != null) {
                vec.add("realization");
                vec.add(fu.getRealization().getClass().getName());
            }
            this.writer.element("field", vec.toArray(new String[0]));
            ++i;
        }
        this.writer.end("field-summary");
        if (!this.signatureOnly) {
            this.patternWriter.visitUnary(item.exp);
        }
        this.writer.end("class");
    }

    private void writeInterface(InterfaceItem item) {
        this.writer.start("interface", new String[]{"name", item.name});
        this.patternWriter.visitUnary(item.exp);
        this.writer.end("interface");
    }

    public void writeNameClass(NameClass nc) {
        nc.visit(new NameClassVisitor(){

            public Object onAnyName(AnyNameClass nc) {
                Writer.this.writer.element("anyName");
                return null;
            }

            public Object onNsName(NamespaceNameClass nc) {
                Writer.this.writer.element("nsName", new String[]{"ns", nc.namespaceURI});
                return null;
            }

            public Object onNot(NotNameClass nc) {
                Writer.this.writer.start("not");
                nc.child.visit(this);
                Writer.this.writer.end("not");
                return null;
            }

            public Object onSimple(SimpleNameClass nc) {
                if (Writer.this.noNS) {
                    Writer.this.writer.start("name");
                } else {
                    Writer.this.writer.start("name", new String[]{"ns", nc.namespaceURI});
                }
                Writer.this.writer.characters(nc.localName);
                Writer.this.writer.end("name");
                return null;
            }

            public Object onDifference(DifferenceNameClass nc) {
                Writer.this.writer.start("difference");
                nc.nc1.visit(this);
                nc.nc2.visit(this);
                Writer.this.writer.end("difference");
                return null;
            }

            public Object onChoice(ChoiceNameClass nc) {
                Writer.this.writer.start("choice");
                this.processChoice(nc);
                Writer.this.writer.end("choice");
                return null;
            }

            private void processChoice(ChoiceNameClass nc) {
                Stack<NameClass> s = new Stack<NameClass>();
                s.push(nc.nc1);
                s.push(nc.nc2);
                while (!s.empty()) {
                    NameClass n = (NameClass)s.pop();
                    if (n instanceof ChoiceNameClass) {
                        s.push(((ChoiceNameClass)n).nc1);
                        s.push(((ChoiceNameClass)n).nc2);
                        continue;
                    }
                    n.visit(this);
                }
            }
        });
    }

    private class SmartWriter
    extends PatternWriter
    implements JavaItemVisitor {
        SmartWriter(Context context) {
            super(context);
        }

        public void onRef(ReferenceExp exp) {
            if (exp.name == null) {
                exp.exp.visit(this);
            } else {
                this.writer.start("ref", new String[]{"name", exp.name});
                exp.exp.visit(this);
                this.writer.end("ref");
            }
        }

        public void onOther(OtherExp exp) {
            if (exp instanceof JavaItem) {
                ((JavaItem)exp).visitJI(this);
            } else if (exp instanceof OccurrenceExp) {
                OccurrenceExp oe = (OccurrenceExp)exp;
                this.writer.start("occurrence", new String[]{"min", Integer.toString(oe.minOccurs), "max", Integer.toString(oe.maxOccurs)});
                exp.exp.visit(this);
                this.writer.end("occurrence");
            } else {
                exp.exp.visit(this);
            }
        }

        public Object onClass(ClassItem item) {
            this.writer.element("class-ref", new String[]{"name", item.name});
            return null;
        }

        public Object onInterface(InterfaceItem item) {
            this.writer.element("interface-ref", new String[]{"interface", item.name});
            return null;
        }

        public Object onWildcard(WildcardItem item) {
            this.writer.start("wildcard");
            Writer.this.writeNameClass(item.range);
            this.writer.end("wildcard");
            return null;
        }

        private String getClassName(Object o) {
            String name = o.getClass().getName();
            int idx = name.lastIndexOf(46);
            if (idx < 0) {
                return name;
            }
            return name.substring(idx + 1);
        }

        public Object onPrimitive(PrimitiveItem item) {
            this.writer.start("primitive", new String[]{"type", item.xducer.toString()});
            this.visitUnary(item.exp);
            this.writer.end("primitive");
            return null;
        }

        public Object onSuper(SuperClassItem item) {
            this.writer.start("superClass");
            this.visitUnary(item.exp);
            this.writer.end("superClass");
            return null;
        }

        public Object onIgnore(IgnoreItem item) {
            this.writer.start("ignore");
            this.writer.end("ignore");
            return null;
        }

        public Object onField(FieldItem item) {
            Vector<String> vec = new Vector<String>();
            vec.add("name");
            vec.add(item.name);
            if (item.defaultValues != null) {
                vec.add("hasDefaultValue");
                vec.add("true");
            }
            this.writer.start("field", vec.toArray(new String[vec.size()]));
            this.visitUnary(item.exp);
            this.writer.end("field");
            return null;
        }
    }
}

