/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema.transformer;

import com.sun.tools.xjc.reader.xmlschema.transformer.DOMForest;
import com.sun.xml.bind.unmarshaller.DOMScanner;
import com.sun.xml.xsom.impl.parser.XMLParser;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class DOMForestParser
implements XMLParser {
    private final DOMForest forest;
    private final XMLParser fallbackParser;

    public DOMForestParser(DOMForest forest, XMLParser fallbackParser) {
        this.forest = forest;
        this.fallbackParser = fallbackParser;
    }

    public void parse(InputSource source, ContentHandler contentHandler) throws SAXException, IOException {
        String systemId = source.getSystemId();
        Document dom = this.forest.get(systemId);
        if (dom == null) {
            this.fallbackParser.parse(source, contentHandler);
            return;
        }
        DOMScanner scanner = new DOMScanner();
        LocationResolver resolver = new LocationResolver(scanner);
        resolver.setContentHandler(contentHandler);
        scanner.parse(dom.getDocumentElement(), resolver);
    }

    private class LocationResolver
    extends XMLFilterImpl
    implements Locator {
        private final DOMScanner parent;
        private boolean inStart = false;

        LocationResolver(DOMScanner _parent) {
            this.parent = _parent;
        }

        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(this);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.inStart = true;
            super.endElement(namespaceURI, localName, qName);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.inStart = false;
            super.startElement(namespaceURI, localName, qName, atts);
        }

        private Locator findLocator() {
            Node n = this.parent.getCurrentLocation();
            if (n instanceof Element) {
                Element e = (Element)n;
                if (this.inStart) {
                    return ((DOMForestParser)DOMForestParser.this).forest.locatorTable.getStartLocation(e);
                }
                return ((DOMForestParser)DOMForestParser.this).forest.locatorTable.getEndLocation(e);
            }
            return null;
        }

        public int getColumnNumber() {
            Locator l = this.findLocator();
            if (l != null) {
                return l.getColumnNumber();
            }
            return -1;
        }

        public int getLineNumber() {
            Locator l = this.findLocator();
            if (l != null) {
                return l.getLineNumber();
            }
            return -1;
        }

        public String getPublicId() {
            Locator l = this.findLocator();
            if (l != null) {
                return l.getPublicId();
            }
            return null;
        }

        public String getSystemId() {
            Locator l = this.findLocator();
            if (l != null) {
                return l.getSystemId();
            }
            return null;
        }
    }
}

