/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JJavaName;
import com.sun.codemodel.util.JavadocEscapeWriter;
import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.grammar.Expression;
import com.sun.tools.xjc.grammar.xducer.BuiltinDatatypeTransducerFactory;
import com.sun.tools.xjc.grammar.xducer.EnumerationXducer;
import com.sun.tools.xjc.grammar.xducer.IdentityTransducer;
import com.sun.tools.xjc.grammar.xducer.Transducer;
import com.sun.tools.xjc.reader.NameConverter;
import com.sun.tools.xjc.reader.xmlschema.BGMBuilder;
import com.sun.tools.xjc.reader.xmlschema.Messages;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIConversion;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIEnum;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIEnumMember;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BindInfo;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSListSimpleType;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSUnionSimpleType;
import com.sun.xml.xsom.impl.util.SchemaWriter;
import com.sun.xml.xsom.visitor.XSSimpleTypeFunction;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.relaxng.datatype.DatatypeException;
import org.xml.sax.Locator;

final class ConversionFinder
implements XSSimpleTypeFunction {
    private final BGMBuilder builder;
    private static final HashMap emptyHashMap = new HashMap();
    private static final Set builtinTypeSafeEnumCapableTypes;
    private final Map builtinConversions = new Hashtable();

    ConversionFinder(BGMBuilder _builder) {
        this.builder = _builder;
        JCodeModel codeModel = this.builder.grammar.codeModel;
        String[] names = new String[]{"anySimpleType", "ID", "IDREF", "boolean", "base64Binary", "hexBinary", "float", "decimal", "integer", "long", "unsignedInt", "int", "unsignedShort", "short", "unsignedByte", "byte", "double", "QName", "token", "normalizedString", "date", "dateTime", "time"};
        try {
            int i = 0;
            while (i < names.length) {
                this.add(names[i], BuiltinDatatypeTransducerFactory.get(this.builder.grammar, DatatypeFactory.getTypeByName(names[i])));
                ++i;
            }
        }
        catch (DatatypeException e) {
            e.printStackTrace();
            throw new InternalError();
        }
    }

    private void add(String name, Transducer t) {
        this.builtinConversions.put(name, new BIConversion(null, t));
    }

    public BIConversion find(XSSimpleType type) {
        return (BIConversion)type.apply(this);
    }

    public Object listSimpleType(XSListSimpleType type) {
        return this.lookup(type);
    }

    public Object unionSimpleType(XSUnionSimpleType type) {
        return this.lookup(type);
    }

    public Object restrictionSimpleType(XSRestrictionSimpleType type) {
        BIConversion conv = this.lookup(type);
        if (conv != null) {
            return conv;
        }
        if (this.shouldBeMappedToTypeSafeEnumByDefault(type)) {
            conv = this.bindToTypeSafeEnum(type, null, null, emptyHashMap, null);
            BindInfo info = this.builder.getBindInfo(type);
            info.addDecl(conv);
            return conv;
        }
        return type.getSimpleBaseType().apply(this);
    }

    private boolean shouldBeMappedToTypeSafeEnumByDefault(XSRestrictionSimpleType type) {
        if (type.isLocal()) {
            return false;
        }
        if (!this.canBeMappedToTypeSafeEnum(type)) {
            return false;
        }
        if (type.getDeclaredFacet("enumeration") == null) {
            return false;
        }
        XSSimpleType t = type;
        do {
            if (!t.isGlobal() || !this.builder.getGlobalBinding().canBeMappedToTypeSafeEnum(t)) continue;
            return true;
        } while ((t = t.getSimpleBaseType()) != null);
        return false;
    }

    private boolean canBeMappedToTypeSafeEnum(XSSimpleType type) {
        do {
            String localName;
            if (!"http://www.w3.org/2001/XMLSchema".equals(type.getTargetNamespace()) || (localName = type.getName()) == null) continue;
            if (localName.equals("anySimpleType")) {
                return false;
            }
            if (localName.equals("ID") || localName.equals("IDREF")) {
                return false;
            }
            if (!builtinTypeSafeEnumCapableTypes.contains(localName)) continue;
            return true;
        } while ((type = type.getSimpleBaseType()) != null);
        return false;
    }

    private BIConversion bindToTypeSafeEnum(XSRestrictionSimpleType type, String className, String javadoc2, HashMap members, Locator loc) {
        if (loc == null) {
            loc = type.getLocator();
        }
        if (className == null) {
            if (!type.isGlobal()) {
                this.builder.errorReporter.error(loc, "ConversionFinder.NoEnumNameAvailable");
                return new BIConversion(type.getLocator(), new IdentityTransducer(this.builder.grammar.codeModel, "preserve"));
            }
            className = type.getName();
        }
        className = this.builder.getNameConverter().toClassName(className);
        JDefinedClass clazz = this.builder.codeModelClassFactory.createClass(this.builder.selector.getPackage(type.getTargetNamespace()), className, type.getLocator());
        StringWriter out = new StringWriter();
        SchemaWriter sw = new SchemaWriter(new JavadocEscapeWriter(out));
        type.visit(sw);
        JDocComment jdoc = clazz.javadoc();
        jdoc.appendComment(javadoc2 != null ? javadoc2 + "\n\n" : "");
        jdoc.appendComment(Messages.format("ClassSelector.JavadocHeading", type.getName()));
        jdoc.appendComment("\n<p>\n<pre>\n");
        jdoc.appendComment(out.getBuffer().toString());
        jdoc.appendComment("</pre>");
        boolean needsToGenerateMemberName = this.checkIfMemberNamesNeedToBeGenerated(type, members);
        HashMap memberMap = new HashMap();
        int idx = 1;
        Expression exp = Expression.nullSet;
        XSDatatype baseDt = this.builder.simpleTypeBuilder.datatypeBuilder.build(type.getSimpleBaseType());
        Iterator itr = type.iterateDeclaredFacets();
        while (itr.hasNext()) {
            XSFacet facet2 = (XSFacet)itr.next();
            if (!facet2.getName().equals("enumeration")) continue;
            Expression vexp = this.builder.pool.createValue(baseDt, baseDt.createValue(facet2.getValue(), facet2.getContext()));
            if (needsToGenerateMemberName) {
                memberMap.put(vexp, new EnumerationXducer.MemberInfo("value" + idx++, null));
            } else {
                BIEnumMember mem = (BIEnumMember)members.get(facet2.getValue());
                if (mem == null) {
                    mem = (BIEnumMember)this.builder.getBindInfo(facet2).get(BIEnumMember.NAME);
                }
                if (mem != null) {
                    memberMap.put(vexp, mem.createMemberInfo());
                }
            }
            exp = this.builder.pool.createChoice(exp, vexp);
        }
        if (memberMap.isEmpty()) {
            memberMap = emptyHashMap;
        }
        BIConversion conv = new BIConversion(type.getLocator(), new EnumerationXducer(NameConverter.standard, clazz, exp, memberMap, loc));
        conv.markAsAcknowledged();
        this.builder.getBindInfo(type).addDecl(conv);
        return conv;
    }

    private boolean checkIfMemberNamesNeedToBeGenerated(XSRestrictionSimpleType type, HashMap members) {
        Iterator itr = type.iterateDeclaredFacets();
        while (itr.hasNext()) {
            String value;
            XSFacet facet2 = (XSFacet)itr.next();
            if (!facet2.getName().equals("enumeration") || members.containsKey(value = facet2.getValue()) || JJavaName.isJavaIdentifier(this.builder.getNameConverter().toConstantName(facet2.getValue()))) continue;
            return this.builder.getGlobalBinding().needsToGenerateEnumMemberName();
        }
        return false;
    }

    private BIConversion lookup(XSSimpleType type) {
        String name;
        BindInfo info = this.builder.getBindInfo(type);
        BIConversion conv = (BIConversion)info.get(BIConversion.NAME);
        if (conv != null) {
            conv.markAsAcknowledged();
            return conv;
        }
        BIEnum bIEnum = (BIEnum)info.get(BIEnum.NAME);
        if (bIEnum != null) {
            bIEnum.markAsAcknowledged();
            if (!this.canBeMappedToTypeSafeEnum(type)) {
                this.builder.errorReporter.error(bIEnum.getLocation(), "ConversionFinder.CannotBeTypeSafeEnum");
                this.builder.errorReporter.error(type.getLocator(), "ConversionFinder.CannotBeTypeSafeEnum.Location");
                return null;
            }
            return this.bindToTypeSafeEnum((XSRestrictionSimpleType)type, bIEnum.getClassName(), bIEnum.getJavadoc(), bIEnum.getMembers(), bIEnum.getLocation());
        }
        if (type.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema") && (name = type.getName()) != null) {
            return this.lookupBuiltin(name);
        }
        return null;
    }

    private BIConversion lookupBuiltin(String typeName) {
        return (BIConversion)this.builtinConversions.get(typeName);
    }

    private static void _assert(boolean b) {
        if (!b) {
            throw new InternalError();
        }
    }

    static {
        HashSet<String> s = new HashSet<String>();
        String[] typeNames = new String[]{"string", "boolean", "float", "decimal", "double", "anyURI"};
        int i = 0;
        while (i < typeNames.length) {
            s.add(typeNames[i]);
            ++i;
        }
        builtinTypeSafeEnumCapableTypes = Collections.unmodifiableSet(s);
    }
}

