/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema;

import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.InterleaveExp;
import com.sun.msv.grammar.SequenceExp;
import com.sun.tools.xjc.grammar.BGMWalker;
import com.sun.tools.xjc.grammar.FieldItem;
import com.sun.tools.xjc.grammar.SuperClassItem;
import com.sun.tools.xjc.reader.xmlschema.BGMBuilder;
import java.util.AbstractCollection;
import java.util.HashSet;
import org.xml.sax.Locator;

public class AggregationChecker
extends BGMWalker {
    private BGMBuilder builder;
    private final String[] reservedWords = new String[]{"Class"};

    public AggregationChecker(BGMBuilder builder) {
        this.builder = builder;
    }

    public void check(Expression exp) {
        exp.visit(this);
    }

    private void compare(Expression left, Expression right) {
        FieldWalker fields = new FieldWalker();
        left.visit(fields);
        Object[] leftFields = ((AbstractCollection)fields.visited).toArray();
        fields.clear();
        right.visit(fields);
        Object[] rightFields = ((AbstractCollection)fields.visited).toArray();
        int i = 0;
        while (i < leftFields.length) {
            FieldItem leftField = (FieldItem)leftFields[i];
            String leftName = leftField.name;
            if (leftName != null) {
                int j = 0;
                while (j < rightFields.length) {
                    FieldItem rightField = (FieldItem)rightFields[j];
                    if (leftName.equals(rightField.name)) {
                        Locator locator = null;
                        if (leftField.locator != null) {
                            locator = leftField.locator;
                        } else if (rightField.locator != null) {
                            locator = rightField.locator;
                        }
                        this.error(locator, "BGMBuilder.PropertyNameCollision", leftName);
                        if (leftField.locator != null && rightField.locator != null) {
                            this.error(rightField.locator, "BGMBuilder.PropertyNameCollision.Source", rightField.name);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void error(Locator locator, String message, String name) {
        this.builder.errorReporter.error(locator, message, name);
    }

    private boolean isReserved(FieldItem item) {
        if (item.name == null) {
            return false;
        }
        int i = 0;
        while (i < this.reservedWords.length) {
            if (this.reservedWords[i].equals(item.name.trim())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object onField(FieldItem item) {
        if (this.isReserved(item)) {
            this.error(item.locator, "BGMBuilder.ReservedWordCollision", item.name);
        }
        return null;
    }

    public void onInterleave(InterleaveExp exp) {
        this.check(exp.exp1);
        this.check(exp.exp2);
        this.compare(exp.exp1, exp.exp2);
    }

    public void onSequence(SequenceExp exp) {
        this.check(exp.exp1);
        this.check(exp.exp2);
        this.compare(exp.exp1, exp.exp2);
    }

    public Object onSuper(SuperClassItem exp) {
        return null;
    }

    private class FieldWalker
    extends BGMWalker {
        private HashSet visited = new HashSet();

        public void clear() {
            this.visited.clear();
        }

        public Object onField(FieldItem item) {
            this.visited.add(item);
            return item;
        }
    }
}

