/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.decorator;

import com.sun.codemodel.JClass;
import com.sun.msv.grammar.Expression;
import com.sun.msv.reader.ExpressionState;
import com.sun.msv.reader.GrammarReader;
import com.sun.msv.util.StartTagInfo;
import com.sun.tools.xjc.generator.field.ArrayFieldRenderer;
import com.sun.tools.xjc.generator.field.TypedListFieldRenderer;
import com.sun.tools.xjc.grammar.Accessor;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.FieldItem;
import com.sun.tools.xjc.grammar.IgnoreItem;
import com.sun.tools.xjc.grammar.JavaItem;
import com.sun.tools.xjc.grammar.SuperClassItem;
import com.sun.tools.xjc.reader.NameConverter;
import com.sun.tools.xjc.reader.PackageManager;
import com.sun.tools.xjc.reader.decorator.Decorator;
import com.sun.tools.xjc.reader.decorator.DecoratorImpl;
import com.sun.tools.xjc.reader.decorator.Messages;
import com.sun.tools.xjc.util.CodeModelClassFactory;

public class RoleBasedDecorator
extends DecoratorImpl {
    private final CodeModelClassFactory classFactory;
    private final Decorator defaultDecorator;
    private final PackageManager packageManager;

    public RoleBasedDecorator(GrammarReader _reader, AnnotatedGrammar _grammar, NameConverter _nc, PackageManager pkgMan, Decorator _defaultDecorator) {
        super(_reader, _grammar, _nc);
        this.defaultDecorator = _defaultDecorator;
        this.packageManager = pkgMan;
        this.classFactory = new CodeModelClassFactory(_reader.controller);
    }

    public Expression decorate(ExpressionState state, Expression exp) {
        JavaItem roleExp;
        StartTagInfo tag = state.getStartTag();
        String role = this.getAttribute(tag, "role");
        if (role == null) {
            if (this.defaultDecorator != null) {
                exp = this.defaultDecorator.decorate(state, exp);
            }
            return exp;
        }
        if (role.equals("none")) {
            return exp;
        }
        if (role.equals("superClass")) {
            roleExp = new SuperClassItem(null);
        } else if (role.equals("class")) {
            roleExp = this.grammar.createClassItem(this.classFactory.createInterface(this.packageManager.getCurrentPackage(), this.decideName(state, exp, role), state.getLocation()), null);
        } else if (role.equals("field")) {
            String collection = this.getAttribute(tag, "collection");
            String access = this.getAttribute(tag, "access");
            String method = this.getAttribute(tag, "method");
            String typeAtt = this.getAttribute(tag, "type");
            JClass type = null;
            if (typeAtt != null) {
                try {
                    type = this.codeModel.ref(typeAtt);
                }
                catch (ClassNotFoundException e) {
                    Messages.format("ClassNotFound", typeAtt);
                }
            }
            FieldItem fi = new FieldItem(this.decideName(state, exp, role), null, type, this.reader.locator);
            roleExp = fi;
            if (collection != null) {
                if (collection.equals("array")) {
                    fi.realization = ArrayFieldRenderer.theFactory;
                }
                if (collection.equals("list")) {
                    fi.realization = TypedListFieldRenderer.theFactory;
                }
                if (fi.realization == null) {
                    Messages.format("InvalidCollectionType", collection);
                }
            }
            if (method != null) {
                fi.accessor = Accessor.parse(method);
                if (fi.accessor == null) {
                    Messages.format("InvalidAccessor", method);
                }
            }
        } else if (role.equals("interface")) {
            roleExp = this.grammar.createInterfaceItem(this.classFactory.createInterface(this.packageManager.getCurrentPackage(), this.decideName(state, exp, role), state.getLocation()), null);
        } else if (role.equals("ignore")) {
            roleExp = new IgnoreItem();
        } else {
            Messages.format("UndefinedRole", role);
            return exp;
        }
        this.reader.setDeclaredLocationOf(roleExp);
        roleExp.exp = exp;
        return roleExp;
    }
}

