/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.annotator;

import com.sun.codemodel.JType;
import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ConcurExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.ExpressionVisitorExpression;
import com.sun.msv.grammar.InterleaveExp;
import com.sun.msv.grammar.ListExp;
import com.sun.msv.grammar.MixedExp;
import com.sun.msv.grammar.OneOrMoreExp;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SequenceExp;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.grammar.trex.ElementPattern;
import com.sun.msv.grammar.util.ExpressionPrinter;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.ClassItem;
import com.sun.tools.xjc.grammar.FieldItem;
import com.sun.tools.xjc.grammar.FieldUse;
import com.sun.tools.xjc.grammar.IgnoreItem;
import com.sun.tools.xjc.grammar.InterfaceItem;
import com.sun.tools.xjc.grammar.JavaItem;
import com.sun.tools.xjc.grammar.PrimitiveItem;
import com.sun.tools.xjc.grammar.SuperClassItem;
import com.sun.tools.xjc.grammar.TypeItem;
import com.sun.tools.xjc.grammar.util.AnnotationRemover;
import com.sun.tools.xjc.grammar.util.FieldMultiplicityCounter;
import com.sun.tools.xjc.grammar.util.Multiplicity;
import com.sun.tools.xjc.reader.TypeUtil;
import com.sun.tools.xjc.reader.annotator.AnnotatorController;
import com.sun.tools.xjc.reader.annotator.Messages;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.Locator;

public final class RelationNormalizer {
    private final AnnotatorController controller;
    private final ExpressionPool pool;

    private RelationNormalizer(AnnotatorController _controller, ExpressionPool _pool) {
        this.controller = _controller;
        this.pool = _pool;
    }

    public static void normalize(AnnotatedGrammar grammar, AnnotatorController controller) {
        RelationNormalizer n = new RelationNormalizer(controller, grammar.getPool());
        ClassItem[] classItems = grammar.getClasses();
        InterfaceItem[] interfaceItems = grammar.getInterfaces();
        Pass1 pass1 = n.new Pass1();
        grammar.topLevel = grammar.topLevel.visit(pass1);
        int i = 0;
        while (i < classItems.length) {
            classItems[i].visit(pass1);
            ++i;
        }
        int i2 = 0;
        while (i2 < interfaceItems.length) {
            interfaceItems[i2].visit(pass1);
            ++i2;
        }
        int i3 = 0;
        while (i3 < classItems.length) {
            FieldUse[] fieldUses = classItems[i3].getDeclaredFieldUses();
            int j = 0;
            while (j < fieldUses.length) {
                fieldUses[j].multiplicity = FieldMultiplicityCounter.count(classItems[i3].exp, fieldUses[j]);
                HashSet<JType> possibleTypes = new HashSet<JType>();
                FieldItem[] fields = fieldUses[j].items.toArray(new FieldItem[0]);
                int k = 0;
                while (k < fields.length) {
                    possibleTypes.add(fields[k].getType(grammar.codeModel));
                    ++k;
                }
                fieldUses[j].type = TypeUtil.getCommonBaseType(grammar.codeModel, possibleTypes);
                ++j;
            }
            ++i3;
        }
    }

    private static void _assert(boolean b) {
        if (!b) {
            throw new InternalError();
        }
    }

    private static boolean isClass(Object exp) {
        return exp instanceof ClassItem;
    }

    private static boolean isSuperClass(Object exp) {
        return exp instanceof SuperClassItem;
    }

    private static boolean isInterface(Object exp) {
        return exp instanceof InterfaceItem;
    }

    private static boolean isField(Object exp) {
        return exp instanceof FieldItem;
    }

    private static boolean isType(Object exp) {
        return exp instanceof TypeItem;
    }

    private static boolean isPrimitive(Object exp) {
        return exp instanceof PrimitiveItem;
    }

    private static boolean isIgnore(Object exp) {
        return exp instanceof IgnoreItem;
    }

    private class Pass1
    implements ExpressionVisitorExpression {
        private final Set visitedClasses = new HashSet();
        private JavaItem parentItem = null;
        private Multiplicity multiplicity = null;

        private Pass1() {
        }

        public Expression onAttribute(AttributeExp exp) {
            Expression newContent = exp.exp.visit(this);
            if (newContent != exp.exp) {
                return RelationNormalizer.this.pool.createAttribute(exp.getNameClass(), newContent);
            }
            return exp;
        }

        public Expression onElement(ElementExp exp) {
            Expression body = exp.contentModel.visit(this);
            if (body == exp.contentModel) {
                return exp;
            }
            return new ElementPattern(exp.getNameClass(), body);
        }

        public Expression onMixed(MixedExp exp) {
            return RelationNormalizer.this.pool.createMixed(exp.exp.visit(this));
        }

        public Expression onList(ListExp exp) {
            return RelationNormalizer.this.pool.createList(exp.exp.visit(this));
        }

        public Expression onConcur(ConcurExp exp) {
            throw new Error("concur is not supported");
        }

        public Expression onChoice(ChoiceExp exp) {
            Expression lhs = exp.exp1.visit(this);
            Multiplicity lhc = this.multiplicity;
            Expression rhs = exp.exp2.visit(this);
            Multiplicity rhc = this.multiplicity;
            this.multiplicity = Multiplicity.choice(lhc, rhc);
            return RelationNormalizer.this.pool.createChoice(lhs, rhs);
        }

        public Expression onSequence(SequenceExp exp) {
            Expression lhs = exp.exp1.visit(this);
            Multiplicity lhc = this.multiplicity;
            Expression rhs = exp.exp2.visit(this);
            Multiplicity rhc = this.multiplicity;
            this.multiplicity = Multiplicity.group(lhc, rhc);
            return RelationNormalizer.this.pool.createSequence(lhs, rhs);
        }

        public Expression onInterleave(InterleaveExp exp) {
            Expression lhs = exp.exp1.visit(this);
            Multiplicity lhc = this.multiplicity;
            Expression rhs = exp.exp2.visit(this);
            Multiplicity rhc = this.multiplicity;
            this.multiplicity = Multiplicity.group(lhc, rhc);
            return RelationNormalizer.this.pool.createInterleave(lhs, rhs);
        }

        public Expression onOneOrMore(OneOrMoreExp exp) {
            Expression p = RelationNormalizer.this.pool.createOneOrMore(exp.exp.visit(this));
            this.multiplicity = Multiplicity.oneOrMore(this.multiplicity);
            return p;
        }

        public Expression onEpsilon() {
            this.multiplicity = Multiplicity.zero;
            return Expression.epsilon;
        }

        public Expression onNullSet() {
            this.multiplicity = Multiplicity.zero;
            return Expression.nullSet;
        }

        public Expression onAnyString() {
            throw new Error();
        }

        public Expression onData(DataExp exp) {
            this.multiplicity = Multiplicity.zero;
            return exp;
        }

        public Expression onValue(ValueExp exp) {
            this.multiplicity = Multiplicity.zero;
            return exp;
        }

        public Expression onRef(ReferenceExp exp) {
            return exp.exp.visit(this);
        }

        public Expression onOther(OtherExp exp) {
            FieldItem fi;
            if (!(exp instanceof JavaItem)) {
                exp.exp = exp.exp.visit(this);
                return exp;
            }
            if (RelationNormalizer.isIgnore(this.parentItem)) {
                return exp.exp.visit(this);
            }
            if (exp instanceof IgnoreItem) {
                exp.exp = AnnotationRemover.remove(exp.exp, RelationNormalizer.this.pool);
                this.multiplicity = Multiplicity.zero;
                return exp;
            }
            JavaItem old = this.parentItem;
            if (exp instanceof JavaItem) {
                this.sanityCheck(this.parentItem, (JavaItem)exp);
                if (RelationNormalizer.isClass(this.parentItem) && RelationNormalizer.isField(exp)) {
                    fi = (FieldItem)exp;
                    ((ClassItem)this.parentItem).getOrCreateFieldUse((String)fi.name).items.add(fi);
                }
                if (RelationNormalizer.isField(this.parentItem) && exp instanceof TypeItem) {
                    TypeItem ti = (TypeItem)exp;
                    FieldItem fi2 = (FieldItem)this.parentItem;
                    try {
                        fi2.addType(ti);
                    }
                    catch (FieldItem.BadTypeException e) {
                        RelationNormalizer.this.controller.reportError(new Locator[]{fi2.locator}, Messages.format("Normalizer.ConflictBetweenUserTypeAndActualType", fi2.name, e.getUserSpecifiedType().name(), ti.getType().name()));
                    }
                }
                if (!this.visitedClasses.add(exp)) {
                    this.multiplicity = this.getJavaItemMultiplicity(exp);
                    return exp;
                }
                this.parentItem = (JavaItem)exp;
            }
            exp.exp = exp.exp.visit(this);
            this.parentItem = old;
            if (RelationNormalizer.isSuperClass(exp)) {
                SuperClassItem sci = (SuperClassItem)exp;
                if (sci.definition == null) {
                    RelationNormalizer.this.controller.reportError(new Expression[]{exp}, Messages.format("Normalizer.MissingSuperClassBody"));
                } else {
                    if (!this.multiplicity.isUnique()) {
                        RelationNormalizer.this.controller.reportError(new Expression[]{exp, sci.definition}, Messages.format("Normalizer.BadSuperClassBodyMultiplicity", new Object[]{sci.definition.name}));
                    }
                    if (RelationNormalizer.isClass(this.parentItem)) {
                        ((ClassItem)this.parentItem).getTypeAsDefined()._implements(sci.definition.getTypeAsDefined());
                    }
                }
            }
            if (RelationNormalizer.isClass(exp)) {
                ClassItem ci = (ClassItem)exp;
                ci.removeDuplicateFieldUses();
            }
            if (RelationNormalizer.isField(exp)) {
                fi = (FieldItem)exp;
                if (fi.multiplicity == null) {
                    fi.multiplicity = this.multiplicity;
                } else {
                    RelationNormalizer._assert(fi.multiplicity.includes(this.multiplicity));
                }
            }
            if (RelationNormalizer.isInterface(exp)) {
                InterfaceItem ii = (InterfaceItem)exp;
                if (!this.multiplicity.isAtMostOnce()) {
                    System.out.println(ExpressionPrinter.printContentModel(exp.exp));
                    RelationNormalizer.this.controller.reportError(new Expression[]{ii}, Messages.format("Normalizer.BadInterfaceToClassMultiplicity", new Object[]{ii.name}));
                }
                return exp;
            }
            this.multiplicity = this.getJavaItemMultiplicity(exp);
            return exp;
        }

        private Multiplicity getJavaItemMultiplicity(OtherExp item) {
            if (item instanceof IgnoreItem) {
                return Multiplicity.zero;
            }
            return Multiplicity.one;
        }

        private void sanityCheck(JavaItem parent, JavaItem child) {
            if (RelationNormalizer.isSuperClass(parent) && !RelationNormalizer.isClass(child)) {
                RelationNormalizer.this.controller.reportError(new Expression[]{parent, child}, Messages.format("Normalizer.BadSuperClassUse"));
                return;
            }
            if (RelationNormalizer.isPrimitive(parent)) {
                throw new Error("internal error: use of primitive-" + child + " relation.");
            }
            if (RelationNormalizer.isField(parent) && (RelationNormalizer.isSuperClass(child) || RelationNormalizer.isField(child)) || RelationNormalizer.isInterface(parent) && (RelationNormalizer.isSuperClass(child) || RelationNormalizer.isField(child) || RelationNormalizer.isPrimitive(child))) {
                RelationNormalizer.this.controller.reportError(new Expression[]{parent, child}, Messages.format("Normalizer.BadItemUse", parent, child));
                return;
            }
            if (RelationNormalizer.isClass(parent) && child instanceof TypeItem) {
                throw new Error("internal error. C-C/C-I/C-P relation " + ((ClassItem)parent).getTypeAsDefined().name() + " " + child.toString() + " " + ExpressionPrinter.printContentModel(parent));
            }
        }
    }
}

