/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.grammar;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.Grammar;
import com.sun.msv.grammar.util.ExpressionPrinter;
import com.sun.tools.xjc.grammar.ClassItem;
import com.sun.tools.xjc.grammar.InterfaceItem;
import com.sun.tools.xjc.grammar.id.SymbolSpace;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public final class AnnotatedGrammar
implements Grammar {
    public Expression topLevel;
    private final ExpressionPool pool;
    public final JCodeModel codeModel;
    public final SymbolSpace defaultSymbolSpace = new SymbolSpace();
    private final Map classes = new HashMap();
    private final Map interfaces = new HashMap();
    public JClass rootClass;
    public Long serialVersionUID = null;

    public AnnotatedGrammar(ExpressionPool pool) {
        this(null, pool, new JCodeModel());
    }

    public AnnotatedGrammar(Grammar source, JCodeModel _codeModel) {
        this(source.getTopLevel(), source.getPool(), _codeModel);
    }

    public AnnotatedGrammar(Expression topLevel, ExpressionPool pool, JCodeModel _codeModel) {
        this.topLevel = topLevel;
        this.pool = pool;
        this.codeModel = _codeModel;
    }

    public Expression getTopLevel() {
        return this.topLevel;
    }

    public ExpressionPool getPool() {
        return this.pool;
    }

    public ClassItem[] getClasses() {
        return this.classes.values().toArray(new ClassItem[this.classes.size()]);
    }

    public Iterator iterateClasses() {
        return this.classes.values().iterator();
    }

    public InterfaceItem[] getInterfaces() {
        return this.interfaces.values().toArray(new InterfaceItem[this.interfaces.size()]);
    }

    public Iterator iterateInterfaces() {
        return this.interfaces.values().iterator();
    }

    public ClassItem getClassItem(JDefinedClass type) {
        return (ClassItem)this.classes.get(type);
    }

    public ClassItem createClassItem(JDefinedClass type, Expression body) {
        if (this.classes.containsKey(type)) {
            System.err.println("class name " + type.fullName() + " is already defined");
            Iterator itr = this.classes.keySet().iterator();
            while (itr.hasNext()) {
                JDefinedClass cls = (JDefinedClass)itr.next();
                System.err.println(cls.fullName());
            }
            AnnotatedGrammar._assert(false);
        }
        ClassItem o = new ClassItem(this, type, body);
        this.classes.put(type, o);
        return o;
    }

    public InterfaceItem getInterfaceItem(JDefinedClass type) {
        return (InterfaceItem)this.interfaces.get(type);
    }

    public InterfaceItem createInterfaceItem(JClass type, Expression body) {
        AnnotatedGrammar._assert(!this.interfaces.containsKey(type));
        InterfaceItem o = new InterfaceItem(type, body);
        this.interfaces.put(type, o);
        return o;
    }

    public void removeClassItem(ClassItem c) {
        if (!c.isTemporary) {
            System.out.println(ExpressionPrinter.printContentModel(c));
            System.out.println(c.getTypeAsDefined().name());
        }
        AnnotatedGrammar._assert(c.isTemporary);
        c.getTypeAsDefined()._package().remove(c.getTypeAsDefined());
        Object o = this.classes.remove(c.getType());
        AnnotatedGrammar._assert(o != null);
    }

    public void removeClassItems(Collection col) {
        Object[] o = col.toArray();
        int i = 0;
        while (i < o.length) {
            this.removeClassItem((ClassItem)o[i]);
            ++i;
        }
    }

    public JPackage[] getUsedPackages() {
        HashSet<JPackage> s = new HashSet<JPackage>();
        Iterator itr = this.iterateClasses();
        while (itr.hasNext()) {
            s.add(((ClassItem)itr.next()).getTypeAsDefined()._package());
        }
        itr = this.iterateInterfaces();
        while (itr.hasNext()) {
            s.add(((InterfaceItem)itr.next()).getTypeAsClass()._package());
        }
        return s.toArray(new JPackage[s.size()]);
    }

    private static final void _assert(boolean b) {
        if (!b) {
            throw new InternalError();
        }
    }
}

