/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.generator.unmarshaller;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JVar;
import com.sun.msv.grammar.AnyNameClass;
import com.sun.msv.grammar.ChoiceNameClass;
import com.sun.msv.grammar.DifferenceNameClass;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.NameClass;
import com.sun.msv.grammar.NameClassVisitor;
import com.sun.msv.grammar.NamespaceNameClass;
import com.sun.msv.grammar.NotNameClass;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.SimpleNameClass;
import com.sun.msv.grammar.util.ExpressionWalker;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.generator.GeneratorContext;
import com.sun.tools.xjc.generator.PackageContext;
import com.sun.tools.xjc.generator.unmarshaller.Automaton;
import com.sun.tools.xjc.generator.unmarshaller.AutomatonBuilder;
import com.sun.tools.xjc.generator.unmarshaller.PerClassGenerator;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.ClassItem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class UnmarshallerGenerator {
    final Options options;
    final AnnotatedGrammar grammar;
    final JCodeModel codeModel;
    final GeneratorContext context;
    final boolean trace;
    final Vector probePoints = new Vector();
    static /* synthetic */ Class class$com$sun$xml$bind$GrammarInfo;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;

    public static Automaton[] generate(AnnotatedGrammar grammar, GeneratorContext context, Options opt) {
        return new UnmarshallerGenerator(grammar, context, opt)._generate();
    }

    private Automaton[] _generate() {
        int i;
        ClassItem[] cis = this.grammar.getClasses();
        Automaton[] automata = new Automaton[cis.length];
        HashMap<ClassItem, Automaton> automataDic = new HashMap<ClassItem, Automaton>();
        int i2 = 0;
        while (i2 < cis.length) {
            automata[i2] = new Automaton(cis[i2]);
            automataDic.put(cis[i2], automata[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < automata.length) {
            AutomatonBuilder.build(automata[i3], this.context, automataDic);
            ++i3;
        }
        if (this.options.debugMode && this.options.verbose) {
            i = 0;
            while (i < cis.length) {
                System.out.println(cis[i].getType().fullName());
                System.out.println("nullable: " + automata[i].isNullable());
                System.out.println();
                ++i;
            }
        }
        i = 0;
        while (i < automata.length) {
            new PerClassGenerator(this, automata[i]).generate();
            ++i;
        }
        this.generateGrammarInfoImpl();
        return automata;
    }

    private void generateGrammarInfoImpl() {
        PackageContext[] pcs = this.context.getAllPackageContexts();
        int i = 0;
        while (i < pcs.length) {
            final JPackage currentPackage = pcs[i]._package();
            JDefinedClass impl = pcs[i].getGrammarInfo();
            impl._extends(this.codeModel.ref(class$com$sun$xml$bind$GrammarInfo == null ? UnmarshallerGenerator.class$("com.sun.xml.bind.GrammarInfo") : class$com$sun$xml$bind$GrammarInfo));
            this.probePoints.clear();
            final HashMap roots = new HashMap();
            this.grammar.getTopLevel().visit(new ExpressionWalker(){
                private NameClass nc;
                private boolean inClass;

                public void onElement(ElementExp exp) {
                    if (!this.inClass) {
                        throw new UnsupportedOperationException();
                    }
                    this.nc = this.nc == null ? exp.getNameClass() : new ChoiceNameClass(this.nc, exp.getNameClass());
                }

                public void onOther(OtherExp exp) {
                    if (!this.inClass && exp instanceof ClassItem) {
                        ClassItem ci = (ClassItem)exp;
                        if (ci.getTypeAsDefined()._package() == currentPackage) {
                            this.inClass = true;
                            this.nc = null;
                            exp.exp.visit(this);
                            this.inClass = false;
                            roots.put(exp, this.nc);
                        }
                    } else {
                        super.onOther(exp);
                    }
                }
            });
            JMethod $method = impl.method(1, this.codeModel.ref(class$java$lang$Class == null ? UnmarshallerGenerator.class$("java.lang.Class") : class$java$lang$Class), "getRootElement");
            JVar $uri = $method.param(this.codeModel.ref(class$java$lang$String == null ? UnmarshallerGenerator.class$("java.lang.String") : class$java$lang$String), "uri");
            JVar $local = $method.param(this.codeModel.ref(class$java$lang$String == null ? UnmarshallerGenerator.class$("java.lang.String") : class$java$lang$String), "local");
            JMethod $method2 = impl.method(1, this.codeModel.ref(class$java$lang$String == null ? UnmarshallerGenerator.class$("java.lang.String") : class$java$lang$String).array(), "getProbePoints");
            Iterator itr = roots.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry e = itr.next();
                ClassItem ci = (ClassItem)e.getKey();
                NameClass nc = (NameClass)e.getValue();
                $method.body()._if(this.generateNameClassTest(nc, $uri, $local))._then().block()._return(JExpr.dotclass(this.context.getImpl(ci)));
                this.calculateProbePoint(nc);
            }
            $method.body()._return(JExpr._null());
            JInvocation $expr = JExpr._new(this.codeModel.ref(class$java$lang$String == null ? UnmarshallerGenerator.class$("java.lang.String") : class$java$lang$String).array());
            int j = 0;
            while (j < this.probePoints.size()) {
                String uriPart = (String)this.probePoints.elementAt(j);
                String localPart = (String)this.probePoints.elementAt(j + 1);
                $expr.arg(JExpr.lit(uriPart)).arg(JExpr.lit(localPart));
                j += 2;
            }
            $method2.body()._return($expr);
            ++i;
        }
    }

    UnmarshallerGenerator(AnnotatedGrammar _grammar, GeneratorContext _context, Options _opt) {
        this.options = _opt;
        this.trace = this.options.traceUnmarshaller;
        this.grammar = _grammar;
        this.codeModel = this.grammar.codeModel;
        this.context = _context;
    }

    protected JExpression generateNameClassTest(NameClass nc, final JVar $uri, final JVar $local) {
        return (JExpression)nc.visit(new NameClassVisitor(){

            public Object onSimple(SimpleNameClass nc) {
                return JOp.cand(JExpr.lit(nc.namespaceURI).eq($uri), JExpr.lit(nc.localName).eq($local));
            }

            public Object onNsName(NamespaceNameClass nc) {
                return JExpr.lit(nc.namespaceURI).eq($uri);
            }

            public Object onAnyName(AnyNameClass nc) {
                return JExpr.lit(true);
            }

            public Object onNot(NotNameClass nc) {
                return JOp.not((JExpression)nc.child.visit(this));
            }

            public Object onDifference(DifferenceNameClass nc) {
                return JOp.cand((JExpression)nc.nc1.visit(this), JOp.not((JExpression)nc.nc2.visit(this)));
            }

            public Object onChoice(ChoiceNameClass nc) {
                return JOp.cor((JExpression)nc.nc1.visit(this), (JExpression)nc.nc2.visit(this));
            }
        });
    }

    protected void calculateProbePoint(NameClass nc) {
        nc.visit(new NameClassVisitor(){

            public Object onSimple(SimpleNameClass nc) {
                UnmarshallerGenerator.this.probePoints.add(nc.namespaceURI);
                UnmarshallerGenerator.this.probePoints.add(nc.localName);
                return null;
            }

            public Object onNsName(NamespaceNameClass nc) {
                UnmarshallerGenerator.this.probePoints.add(nc.namespaceURI);
                UnmarshallerGenerator.this.probePoints.add("*");
                return null;
            }

            public Object onAnyName(AnyNameClass nc) {
                UnmarshallerGenerator.this.probePoints.add("*");
                UnmarshallerGenerator.this.probePoints.add("*");
                return null;
            }

            public Object onNot(NotNameClass nc) {
                nc.child.visit(this);
                return null;
            }

            public Object onDifference(DifferenceNameClass nc) {
                nc.nc1.visit(this);
                nc.nc2.visit(this);
                return null;
            }

            public Object onChoice(ChoiceNameClass nc) {
                nc.nc1.visit(this);
                nc.nc2.visit(this);
                return null;
            }
        });
    }

    private static final void _assert(boolean b) {
        if (!b) {
            throw new InternalError();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

