/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc;

import com.sun.codemodel.CodeWriter;
import com.sun.msv.reader.Controller;
import com.sun.tools.xjc.ConsoleErrorReporter;
import com.sun.tools.xjc.Driver;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XJCTask
extends Task {
    private final ArrayList schemas = new ArrayList();
    private final ArrayList bindings = new ArrayList();
    private final Options options = new Options();
    private String packageName = "";
    private File targetDir = null;
    private int schemaLanguage = -1;
    private boolean readonly = false;
    private long stackSize = -1L;
    private final ArrayList schemaSets = new ArrayList();
    private final ArrayList bindSets = new ArrayList();
    private final Path classpath;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$ThreadGroup;
    static /* synthetic */ Class class$java$lang$Runnable;
    static /* synthetic */ Class class$java$lang$String;

    public XJCTask() {
        this.classpath = new Path(((ProjectComponent)this).project);
    }

    public void setSchema(File schema) {
        this.schemas.add(this.getInputSource(schema));
    }

    public void addSchema(FileSet fs) {
        this.schemaSets.add(fs);
    }

    public void setClasspath(Path cp) {
        this.classpath.createPath().append(cp);
    }

    public Path createClasspath() {
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.classpath.createPath().setRefid(r);
    }

    public void setBinding(File binding) {
        this.bindings.add(this.getInputSource(binding));
    }

    public void addBinding(FileSet fs) {
        this.bindSets.add(fs);
    }

    public void setPackage(String pkg) {
        this.packageName = pkg;
    }

    public void setStackSize(String ss) {
        try {
            this.stackSize = Long.parseLong(ss);
            return;
        }
        catch (NumberFormatException e) {
            if (ss.length() > 2) {
                String head = ss.substring(0, ss.length() - 2);
                String tail = ss.substring(ss.length() - 2);
                if (tail.equalsIgnoreCase("kb")) {
                    try {
                        this.stackSize = Long.parseLong(head) * 1024L;
                        return;
                    }
                    catch (NumberFormatException ee) {
                        // empty catch block
                    }
                }
                if (tail.equalsIgnoreCase("mb")) {
                    try {
                        this.stackSize = Long.parseLong(head) * 1024L * 1024L;
                        return;
                    }
                    catch (NumberFormatException ee) {
                        // empty catch block
                    }
                }
            }
            throw new BuildException("Unrecognizable stack size: " + ss);
        }
    }

    public void setReadonly(boolean flg) {
        this.readonly = flg;
    }

    public void setExtension(boolean flg) {
        this.options.compatibilityMode = flg ? 2 : 1;
    }

    public void setTarget(File dir) {
        this.targetDir = dir;
    }

    private InputSource getInputSource(File f) {
        try {
            return new InputSource(f.toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            return new InputSource(f.getPath());
        }
    }

    public void execute() throws BuildException {
        if (this.stackSize == -1L) {
            this.doXJC();
        } else {
            try {
                Thread t;
                final Throwable[] e = new Throwable[1];
                Runnable job = new Runnable(){

                    public void run() {
                        try {
                            XJCTask.this.doXJC();
                        }
                        catch (Throwable be) {
                            e[0] = be;
                        }
                    }
                };
                try {
                    Constructor<?>[] o = (class$java$lang$Thread == null ? (class$java$lang$Thread = XJCTask.class$("java.lang.Thread")) : class$java$lang$Thread).getConstructors();
                    Constructor c = (class$java$lang$Thread == null ? (class$java$lang$Thread = XJCTask.class$("java.lang.Thread")) : class$java$lang$Thread).getConstructor(class$java$lang$ThreadGroup == null ? (class$java$lang$ThreadGroup = XJCTask.class$("java.lang.ThreadGroup")) : class$java$lang$ThreadGroup, class$java$lang$Runnable == null ? (class$java$lang$Runnable = XJCTask.class$("java.lang.Runnable")) : class$java$lang$Runnable, class$java$lang$String == null ? (class$java$lang$String = XJCTask.class$("java.lang.String")) : class$java$lang$String, Long.TYPE);
                    t = (Thread)c.newInstance(Thread.currentThread().getThreadGroup(), job, Thread.currentThread().getName() + ":XJC", new Long(this.stackSize));
                }
                catch (Throwable err) {
                    this.log("Unable to set the stack size. Use JDK1.4 or above", 1);
                    this.doXJC();
                    return;
                }
                t.start();
                t.join();
                if (e[0] instanceof Error) {
                    throw (Error)e[0];
                }
                if (e[0] instanceof RuntimeException) {
                    throw (RuntimeException)e[0];
                }
                if (e[0] instanceof BuildException) {
                    throw (BuildException)e[0];
                }
                if (e[0] != null) {
                    throw new BuildException(e[0]);
                }
            }
            catch (InterruptedException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private void doXJC() throws BuildException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)new AntClassLoader(((ProjectComponent)this).project, this.classpath));
            this._doXJC();
            Object var3_2 = null;
            Thread.currentThread().setContextClassLoader(old);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Thread.currentThread().setContextClassLoader(old);
            throw throwable;
        }
    }

    private void _doXJC() throws BuildException {
        this.processFileSets(this.schemaSets, this.schemas);
        this.processFileSets(this.bindSets, this.bindings);
        if (this.targetDir == null) {
            throw new BuildException("A target attribute needs to be specified");
        }
        if (this.schemas.size() == 0) {
            throw new BuildException("No schema file is given");
        }
        String msg = "Compiling " + ((InputSource)this.schemas.get(0)).getSystemId();
        if (this.schemas.size() > 1) {
            msg = msg + " and others";
        }
        this.log(msg, 2);
        Controller controller = new Controller(new ConsoleErrorReporter(System.out));
        AnnotatedGrammar grammar = null;
        try {
            grammar = Driver.loadGrammar(this.schemaLanguage, this.schemas.toArray(new InputSource[0]), this.bindings.toArray(new InputSource[0]), controller, this.packageName, this.options);
            if (grammar == null) {
                throw new BuildException("unable to parse the schema. Error messages should have been provided");
            }
            CodeWriter cw = Driver.createCodeWriter(this.targetDir, this.readonly);
            if (!Driver.generateCode(grammar, this.options, controller, cw)) {
                throw new BuildException("failed to compile a schema");
            }
        }
        catch (IOException e) {
            throw new BuildException("unable to write files", (Throwable)e);
        }
        catch (SAXException e) {
            throw new BuildException("failed to compile a schema", (Throwable)e);
        }
    }

    private void processFileSets(ArrayList filesets, ArrayList inputSources) {
        Iterator itr = ((AbstractList)filesets).iterator();
        while (itr.hasNext()) {
            FileSet fs = (FileSet)itr.next();
            DirectoryScanner ds = fs.getDirectoryScanner(((ProjectComponent)this).project);
            String[] includedFiles = ds.getIncludedFiles();
            File baseDir = ds.getBasedir();
            int j = 0;
            while (j < includedFiles.length) {
                File file = new File(baseDir, includedFiles[j]);
                inputSources.add(this.getInputSource(file));
                ++j;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

