/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc;

import com.sun.msv.reader.GrammarReaderController;
import com.sun.tools.xjc.Messages;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ConsoleErrorReporter
implements GrammarReaderController {
    private PrintStream output;

    public ConsoleErrorReporter(PrintStream out) {
        this.output = out;
    }

    public ConsoleErrorReporter(OutputStream out) {
        this(new PrintStream(out));
    }

    public ConsoleErrorReporter() {
        this(System.out);
    }

    public void warning(Locator[] locs, String msg) {
        this.print(locs, Messages.format("Driver.WarningMessage", msg));
    }

    public void error(Locator[] locs, String msg, Exception e) {
        this.print(locs, Messages.format("Driver.ErrorMessage", msg));
    }

    private void print(Locator[] locs, String msg) {
        this.output.println(msg);
        boolean locationProvided = false;
        int i = 0;
        while (i < locs.length) {
            if (locs[i] != null && (locs[i].getLineNumber() != -1 || locs[i].getSystemId() != null)) {
                this.print(locs[i]);
                locationProvided = true;
            }
            ++i;
        }
        if (!locationProvided) {
            this.output.println(Messages.format("ConsoleErrorReporter.UnknownLocation"));
        }
        this.output.println();
    }

    private void print(Locator loc) {
        int line = loc.getLineNumber();
        this.output.println(Messages.format("ConsoleErrorReporter.LineXOfY", line == -1 ? "?" : Integer.toString(line), this.getShortName(loc.getSystemId())));
    }

    private String getShortName(String url) {
        if (url == null) {
            return Messages.format("ConsoleErrorReporter.UnknownFile");
        }
        int idx = url.lastIndexOf(47);
        if (idx != -1) {
            return url.substring(idx + 1);
        }
        idx = url.lastIndexOf(92);
        if (idx != -1) {
            return url.substring(idx + 1);
        }
        return url;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return null;
    }
}

