/*
 * Decompiled with CFR 0.152.
 */
package com.sun.relaxng.javadt;

import java.util.HashSet;

public class Name {
    private static HashSet reservedKeywords = new HashSet();

    static {
        String[] words = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "assert"};
        int i = 0;
        while (i < words.length) {
            reservedKeywords.add(words[i]);
            ++i;
        }
    }

    public static boolean isJavaIdentifier(String token) {
        if (token.length() == 0) {
            return false;
        }
        if (reservedKeywords.contains(token)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(token.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < token.length()) {
            if (!Character.isJavaIdentifierPart(token.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isJavaPackageName(String s) {
        while (s.length() != 0) {
            int idx = s.indexOf(46);
            if (idx == -1) {
                idx = s.length();
            }
            if (!Name.isJavaIdentifier(s.substring(0, idx))) {
                return false;
            }
            if ((s = s.substring(idx)).length() == 0) continue;
            s = s.substring(1);
        }
        return true;
    }
}

