/*
 * Decompiled with CFR 0.152.
 */
package com.securitycentric.metacoretex.lib;

import com.securitycentric.metacoretex.Init;
import com.securitycentric.metacoretex.interfaces.Probe;
import com.securitycentric.metacoretex.lib.ProbeClassLoader;
import com.securitycentric.metacoretex.lib.Version;
import com.securitycentric.metacoretex.lib.VersionException;
import com.sun.tools.javac.Main;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class ProbeToolz {
    public static void setProbesEnabled(Vector vect, boolean enabled) {
        Iterator i = vect.iterator();
        while (i.hasNext()) {
            Probe prb = (Probe)i.next();
            prb.setEnabled(enabled);
        }
    }

    public static Version confFileVersion(File confFile) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(confFile));
            String line = br.readLine().trim();
            Version ver = new Version(line);
            return ver;
        }
        catch (IOException e) {
        }
        catch (VersionException versionException) {
            // empty catch block
        }
        return null;
    }

    public static void loadProbesFromDir(File prDir, Vector vect) throws IOException {
        if (!prDir.isDirectory()) {
            throw new IOException(prDir.getName() + " is not a Directory!");
        }
        String[] names = prDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".class");
            }
        });
        for (int i = 0; i < names.length; ++i) {
            Probe prb = ProbeToolz.loadProbeFromFile(new File(prDir.getPath() + "/" + names[i]));
            if (prb == null) continue;
            vect.add(prb);
        }
    }

    public static Probe loadProbeFromFile(File prFile) {
        if (!prFile.exists()) {
            return null;
        }
        try {
            String path = prFile.getParent();
            String className = prFile.getName().substring(0, prFile.getName().indexOf(46));
            ProbeClassLoader pldr = new ProbeClassLoader(path + "/");
            Class probClass = pldr.loadClass(className);
            Probe newProbe = (Probe)probClass.newInstance();
            return newProbe;
        }
        catch (Exception ex) {
            System.out.println("loadProbeFromFile threw: " + ex.getClass().toString() + " : " + ex.getMessage());
            return null;
        }
    }

    public static String getNameById(int id) {
        String name = "Probe Id Not Set!";
        Probe probeTmp = ProbeToolz.getProbeById(id);
        if (probeTmp == null) {
            return name;
        }
        return probeTmp.getName();
    }

    public static Probe getProbeById(int id) {
        Iterator piter = Init.allProbeVect.iterator();
        while (piter.hasNext()) {
            Probe probeTmp = (Probe)piter.next();
            if (probeTmp.getProbeId() != id) continue;
            return probeTmp;
        }
        return null;
    }

    public static boolean isLoaded(Vector probeVect, int probeId) {
        Iterator i = probeVect.iterator();
        while (i.hasNext()) {
            Probe pTmp = (Probe)i.next();
            if (pTmp.getProbeId() != probeId) continue;
            return true;
        }
        return false;
    }

    public static void removeProbe(int probeId) {
        Hashtable tab = Init.probeVectHash;
        Iterator famIter = tab.keySet().iterator();
        block0: while (famIter.hasNext()) {
            String fam = (String)famIter.next();
            Vector famVect = (Vector)tab.get(fam);
            Iterator vectIter = famVect.iterator();
            while (vectIter.hasNext()) {
                Probe tmpPrb = (Probe)vectIter.next();
                if (tmpPrb.getProbeId() != probeId) continue;
                vectIter.remove();
                continue block0;
            }
        }
    }

    public static int getIndex(Vector probeVect, Probe probe) {
        if (probe.provides().size() == 0) {
            return probeVect.size();
        }
        if (probe.depends().size() == 0) {
            return 0;
        }
        int depIndex = ProbeToolz.getDepIndex(probeVect, probe);
        int provIndex = ProbeToolz.getProvIndex(probeVect, probe);
        if (provIndex == 0) {
            return depIndex;
        }
        if (depIndex <= provIndex) {
            return depIndex;
        }
        System.out.println("Dep Failure: depIndex = " + depIndex + " provIndex = " + provIndex + "depIndex must be <= provIndex");
        return -1;
    }

    public static int getDepIndex(Vector probeVect, Probe probe) {
        int index = -1;
        Iterator probeIter = probeVect.iterator();
        while (probeIter.hasNext()) {
            Probe ptmp = (Probe)probeIter.next();
            if (!ProbeToolz.testDepends(probe, ptmp)) continue;
            index = probeVect.indexOf(ptmp) + 1;
        }
        return index;
    }

    public static int getProvIndex(Vector probeVect, Probe probe) {
        int index = 0;
        Iterator probeIter = probeVect.iterator();
        while (probeIter.hasNext()) {
            Probe ptmp = (Probe)probeIter.next();
            if (!ProbeToolz.testDepends(ptmp, probe)) continue;
            index = probeVect.indexOf(ptmp);
        }
        return index;
    }

    public static boolean testDepends(Probe depOne, Probe provOne) {
        Hashtable provHash = provOne.provides();
        Iterator depIter = depOne.depends().iterator();
        while (depIter.hasNext()) {
            String key = (String)depIter.next();
            if (!provHash.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public static int nextProbeId() {
        Iterator i = Init.allProbeVect.iterator();
        int id = 0;
        while (i.hasNext()) {
            Probe x = (Probe)i.next();
            if (x.getProbeId() <= id) continue;
            id = x.getProbeId();
        }
        return ++id;
    }

    public static boolean compileProbe(File prbJava) {
        String mess;
        String title = "MetaCoretex Probe Compiler";
        int stat = 1;
        Object javac = null;
        String[] args = new String[]{"-classpath", (String)Init.config.get("probe.compiler.classpath"), prbJava.getPath()};
        try {
            Class<?> compClass = Class.forName("com.sun.tools.javac.Main");
            javac = compClass.newInstance();
        }
        catch (Exception e) {
            Init.doError("Compiler Error", new Exception("Compiler Classes Not-Found"));
            return false;
        }
        try {
            stat = Main.compile(args);
        }
        catch (Exception e) {
            Init.doError("Compiler Error", e);
        }
        switch (stat) {
            case 0: {
                int reply = Init.askYesNo("Compile Complete", "Compile Successful!\nWould you like to load your new probe?");
                if (reply == 0) {
                    String prbClass = prbJava.getPath().replaceAll("\\.java", ".class");
                    Probe prb = ProbeToolz.loadProbeFromFile(new File(prbClass));
                    System.out.println("Loading :" + prbClass);
                    if (prb != null) {
                        Init.depVect.add(prb);
                        Init.processDepVect();
                    }
                }
                return true;
            }
            case 1: {
                mess = "Compiler Error!";
                break;
            }
            default: {
                mess = "WTF did you do?!?!?";
            }
        }
        Init.doError(mess, new Exception("Unknown Exception"));
        return false;
    }
}

