/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind;

import com.sun.msv.datatype.xsd.Base64BinaryType;
import com.sun.msv.datatype.xsd.BooleanType;
import com.sun.msv.datatype.xsd.ByteType;
import com.sun.msv.datatype.xsd.DateTimeType;
import com.sun.msv.datatype.xsd.DateType;
import com.sun.msv.datatype.xsd.DoubleType;
import com.sun.msv.datatype.xsd.FloatType;
import com.sun.msv.datatype.xsd.HexBinaryType;
import com.sun.msv.datatype.xsd.IntType;
import com.sun.msv.datatype.xsd.IntegerType;
import com.sun.msv.datatype.xsd.LongType;
import com.sun.msv.datatype.xsd.NumberType;
import com.sun.msv.datatype.xsd.ShortType;
import com.sun.msv.datatype.xsd.SimpleURType;
import com.sun.msv.datatype.xsd.TimeType;
import com.sun.msv.datatype.xsd.XmlNames;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class DatatypeConverterImpl
implements DatatypeConverterInterface {
    public static final DatatypeConverterInterface theInstance = new DatatypeConverterImpl();

    protected DatatypeConverterImpl() {
    }

    public String parseString(String lexicalXSDString) {
        return lexicalXSDString;
    }

    public BigInteger parseInteger(String lexicalXSDInteger) {
        return IntegerType.load((String)lexicalXSDInteger);
    }

    public int parseInt(String lexicalXSDInt) {
        return IntType.load((String)lexicalXSDInt);
    }

    public long parseLong(String lexicalXSLong) {
        return LongType.load((String)lexicalXSLong);
    }

    public short parseShort(String lexicalXSDShort) {
        return ShortType.load((String)lexicalXSDShort);
    }

    public BigDecimal parseDecimal(String lexicalXSDDecimal) {
        return NumberType.load((String)lexicalXSDDecimal);
    }

    public float parseFloat(String lexicalXSDFloat) {
        return FloatType.load((String)lexicalXSDFloat).floatValue();
    }

    public double parseDouble(String lexicalXSDDouble) {
        return DoubleType.load((String)lexicalXSDDouble);
    }

    public boolean parseBoolean(String lexicalXSDBoolean) {
        return BooleanType.load((String)lexicalXSDBoolean);
    }

    public byte parseByte(String lexicalXSDByte) {
        return ByteType.load((String)lexicalXSDByte);
    }

    public QName parseQName(String lexicalXSDQName, NamespaceContext nsc) {
        String uri = null;
        String localPart = null;
        int first = lexicalXSDQName.indexOf(58);
        if (first <= 0) {
            uri = this.resolveNamespacePrefix("", nsc);
            localPart = lexicalXSDQName;
        } else {
            String prefix = lexicalXSDQName.substring(0, first);
            localPart = lexicalXSDQName.substring(first + 1);
            uri = this.resolveNamespacePrefix(prefix, nsc);
        }
        if (uri == null) {
            return null;
        }
        if (!XmlNames.isUnqualifiedName((String)localPart)) {
            return null;
        }
        return new QName(uri, localPart);
    }

    private String resolveNamespacePrefix(String prefix, NamespaceContext nsc) {
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return nsc.getNamespaceURI(prefix);
    }

    public Calendar parseDateTime(String lexicalXSDDateTime) {
        return (Calendar)DateTimeType.theInstance.createJavaObject(lexicalXSDDateTime, null);
    }

    public byte[] parseBase64Binary(String lexicalXSDBase64Binary) {
        return Base64BinaryType.load((String)lexicalXSDBase64Binary);
    }

    public byte[] parseHexBinary(String lexicalXSDHexBinary) {
        return HexBinaryType.load((String)lexicalXSDHexBinary);
    }

    public long parseUnsignedInt(String lexicalXSDUnsignedInt) {
        return LongType.load((String)lexicalXSDUnsignedInt);
    }

    public int parseUnsignedShort(String lexicalXSDUnsignedShort) {
        return IntType.load((String)lexicalXSDUnsignedShort).shortValue();
    }

    public Calendar parseTime(String lexicalXSDTime) {
        return (Calendar)TimeType.theInstance.createJavaObject(lexicalXSDTime, null);
    }

    public Calendar parseDate(String lexicalXSDDate) {
        return (Calendar)DateType.theInstance.createJavaObject(lexicalXSDDate, null);
    }

    public String parseAnySimpleType(String lexicalXSDAnySimpleType) {
        return lexicalXSDAnySimpleType;
    }

    public String printString(String val) {
        return val;
    }

    public String printInteger(BigInteger val) {
        return IntegerType.save((BigInteger)val);
    }

    public String printInt(int val) {
        return IntType.save((Integer)new Integer(val));
    }

    public String printLong(long val) {
        return LongType.save((Long)new Long(val));
    }

    public String printShort(short val) {
        return ShortType.save((Short)new Short(val));
    }

    public String printDecimal(BigDecimal val) {
        return NumberType.save((Object)val);
    }

    public String printFloat(float val) {
        return FloatType.save((Float)new Float(val));
    }

    public String printDouble(double val) {
        return DoubleType.save((Double)new Double(val));
    }

    public String printBoolean(boolean val) {
        return BooleanType.save((Boolean)new Boolean(val));
    }

    public String printByte(byte val) {
        return ByteType.save((Byte)new Byte(val));
    }

    public String printQName(QName val, NamespaceContext nsc) {
        String qname = null;
        String prefix = nsc.getPrefix(val.getNamespaceURI());
        String localPart = val.getLocalPart();
        qname = prefix == null ? localPart : prefix + ":" + localPart;
        return qname;
    }

    public String printDateTime(Calendar val) {
        return DateTimeType.theInstance.serializeJavaObject((Object)val, null);
    }

    public String printBase64Binary(byte[] val) {
        return Base64BinaryType.save((byte[])val);
    }

    public String printHexBinary(byte[] val) {
        return HexBinaryType.save((byte[])val);
    }

    public String printUnsignedInt(long val) {
        return LongType.save((Long)new Long(val));
    }

    public String printUnsignedShort(int val) {
        return IntType.save((Integer)new Integer(val));
    }

    public String printTime(Calendar val) {
        return TimeType.theInstance.serializeJavaObject((Object)val, null);
    }

    public String printDate(Calendar val) {
        return DateType.theInstance.serializeJavaObject((Object)val, null);
    }

    public String printAnySimpleType(String val) {
        return SimpleURType.theInstance.convertToLexicalValue((Object)val, null);
    }

    public static String installHook(String s) {
        DatatypeConverter.setDatatypeConverter((DatatypeConverterInterface)theInstance);
        return s;
    }
}

