/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class UnicodeEscapeWriter
extends FilterWriter {
    public UnicodeEscapeWriter(Writer next) {
        super(next);
    }

    public void write(int ch) throws IOException {
        if (ch < 128) {
            this.out.write(ch);
        } else {
            this.out.write("\\u");
            String s = Integer.toHexString(ch);
            int i = s.length();
            while (i < 4) {
                this.out.write(48);
                ++i;
            }
            this.out.write(s);
        }
    }

    public void write(char[] buf, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.write(buf[off + i]);
            ++i;
        }
    }

    public void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(String buf, int off, int len) throws IOException {
        this.write(buf.toCharArray(), off, len);
    }

    public void write(String buf) throws IOException {
        this.write(buf.toCharArray(), 0, buf.length());
    }
}

