/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.impl.dv.DatatypeException;
import org.apache.xerces.impl.dv.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSFacets;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.xs.AnySimpleDV;
import org.apache.xerces.impl.dv.xs.AnyURIDV;
import org.apache.xerces.impl.dv.xs.Base64BinaryDV;
import org.apache.xerces.impl.dv.xs.BooleanDV;
import org.apache.xerces.impl.dv.xs.DateDV;
import org.apache.xerces.impl.dv.xs.DateTimeDV;
import org.apache.xerces.impl.dv.xs.DayDV;
import org.apache.xerces.impl.dv.xs.DecimalDV;
import org.apache.xerces.impl.dv.xs.DoubleDV;
import org.apache.xerces.impl.dv.xs.DurationDV;
import org.apache.xerces.impl.dv.xs.EntityDV;
import org.apache.xerces.impl.dv.xs.FloatDV;
import org.apache.xerces.impl.dv.xs.HexBinaryDV;
import org.apache.xerces.impl.dv.xs.IDDV;
import org.apache.xerces.impl.dv.xs.IDREFDV;
import org.apache.xerces.impl.dv.xs.IntegerDV;
import org.apache.xerces.impl.dv.xs.ListDV;
import org.apache.xerces.impl.dv.xs.ListData;
import org.apache.xerces.impl.dv.xs.MonthDV;
import org.apache.xerces.impl.dv.xs.MonthDayDV;
import org.apache.xerces.impl.dv.xs.QNameDV;
import org.apache.xerces.impl.dv.xs.StringDV;
import org.apache.xerces.impl.dv.xs.TimeDV;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.impl.dv.xs.UnionDV;
import org.apache.xerces.impl.dv.xs.YearDV;
import org.apache.xerces.impl.dv.xs.YearMonthDV;
import org.apache.xerces.impl.xpath.regex.RegularExpression;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.psvi.StringList;
import org.apache.xerces.impl.xs.psvi.XSAnnotation;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.psvi.XSSimpleTypeDefinition;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.impl.xs.util.StringListImpl;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.NamespaceContext;

public class XSSimpleTypeDecl
implements XSSimpleType {
    static final short DV_STRING = 1;
    static final short DV_BOOLEAN = 2;
    static final short DV_DECIMAL = 3;
    static final short DV_FLOAT = 4;
    static final short DV_DOUBLE = 5;
    static final short DV_DURATION = 6;
    static final short DV_DATETIME = 7;
    static final short DV_TIME = 8;
    static final short DV_DATE = 9;
    static final short DV_GYEARMONTH = 10;
    static final short DV_GYEAR = 11;
    static final short DV_GMONTHDAY = 12;
    static final short DV_GDAY = 13;
    static final short DV_GMONTH = 14;
    static final short DV_HEXBINARY = 15;
    static final short DV_BASE64BINARY = 16;
    static final short DV_ANYURI = 17;
    static final short DV_QNAME = 18;
    static final short DV_NOTATION = 19;
    static final short DV_ANYSIMPLETYPE = 0;
    static final short DV_ID = 20;
    static final short DV_IDREF = 21;
    static final short DV_ENTITY = 22;
    static final short DV_INTEGER = 23;
    static final short DV_LIST = 24;
    static final short DV_UNION = 25;
    static final TypeValidator[] fDVs = new TypeValidator[]{new AnySimpleDV(), new StringDV(), new BooleanDV(), new DecimalDV(), new FloatDV(), new DoubleDV(), new DurationDV(), new DateTimeDV(), new TimeDV(), new DateDV(), new YearMonthDV(), new YearDV(), new MonthDayDV(), new DayDV(), new MonthDV(), new HexBinaryDV(), new Base64BinaryDV(), new AnyURIDV(), new QNameDV(), new QNameDV(), new IDDV(), new IDREFDV(), new EntityDV(), new IntegerDV(), new ListDV(), new UnionDV()};
    static final short NORMALIZE_NONE = 0;
    static final short NORMALIZE_TRIM = 1;
    static final short NORMALIZE_FULL = 2;
    static final short[] fDVNormalizeType = new short[]{0, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 2, 0};
    static final short SPECIAL_PATTERN_NONE = 0;
    static final short SPECIAL_PATTERN_NMTOKEN = 1;
    static final short SPECIAL_PATTERN_NAME = 2;
    static final short SPECIAL_PATTERN_NCNAME = 3;
    static final String[] SPECIAL_PATTERN_STRING = new String[]{"NONE", "NMTOKEN", "Name", "NCName", "integer"};
    static final String[] WS_FACET_STRING = new String[]{"preserve", "collapse", "replace"};
    static final String URI_SCHEMAFORSCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String ANY_TYPE = "anyType";
    static final ValidationContext fEmptyContext = new ValidationContext(){

        public boolean needFacetChecking() {
            return true;
        }

        public boolean needExtraChecking() {
            return false;
        }

        public boolean needToNormalize() {
            return true;
        }

        public boolean isEntityDeclared(String name) {
            return false;
        }

        public boolean isEntityUnparsed(String name) {
            return false;
        }

        public boolean isIdDeclared(String name) {
            return false;
        }

        public void addId(String name) {
        }

        public void addIdRef(String name) {
        }

        public String getSymbol(String symbol) {
            return null;
        }

        public String getURI(String prefix) {
            return null;
        }
    };
    private boolean fIsImmutable = false;
    private XSSimpleTypeDecl fItemType;
    private XSSimpleTypeDecl[] fMemberTypes;
    private String fTypeName;
    private String fTargetNamespace;
    private short fFinalSet = 0;
    private XSSimpleTypeDecl fBase;
    private short fVariety = (short)-1;
    private short fValidationDV = (short)-1;
    private short fFacetsDefined = 0;
    private short fFixedFacet = 0;
    private short fWhiteSpace = 0;
    private int fLength = -1;
    private int fMinLength = -1;
    private int fMaxLength = -1;
    private int fTotalDigits = -1;
    private int fFractionDigits = -1;
    private Vector fPattern;
    private Vector fPatternStr;
    private Vector fEnumeration;
    private Object fMaxInclusive;
    private Object fMaxExclusive;
    private Object fMinExclusive;
    private Object fMinInclusive;
    private short fPatternType = 0;
    private short fOrdered;
    private boolean fFinite;
    private boolean fBounded;
    private boolean fNumeric;
    static final XSSimpleTypeDecl fAnySimpleType = new XSSimpleTypeDecl(null, "anySimpleType", 0, 0, false, true, false, true);
    static final ValidationContext fDummyContext = new ValidationContext(){

        public boolean needFacetChecking() {
            return true;
        }

        public boolean needExtraChecking() {
            return false;
        }

        public boolean needToNormalize() {
            return false;
        }

        public boolean isEntityDeclared(String name) {
            return false;
        }

        public boolean isEntityUnparsed(String name) {
            return false;
        }

        public boolean isIdDeclared(String name) {
            return false;
        }

        public void addId(String name) {
        }

        public void addIdRef(String name) {
        }

        public String getSymbol(String symbol) {
            return null;
        }

        public String getURI(String prefix) {
            return null;
        }
    };

    public XSSimpleTypeDecl() {
    }

    protected XSSimpleTypeDecl(XSSimpleTypeDecl base, String name, short validateDV, short ordered, boolean bounded, boolean finite, boolean numeric, boolean isImmutable) {
        this.fIsImmutable = isImmutable;
        this.fBase = base;
        this.fTypeName = name;
        this.fTargetNamespace = URI_SCHEMAFORSCHEMA;
        this.fVariety = 1;
        this.fValidationDV = validateDV;
        this.fFacetsDefined = (short)64;
        if (validateDV == 1) {
            this.fWhiteSpace = 0;
        } else {
            this.fWhiteSpace = (short)2;
            this.fFixedFacet = (short)64;
        }
        this.fOrdered = ordered;
        this.fBounded = bounded;
        this.fFinite = finite;
        this.fNumeric = numeric;
    }

    protected XSSimpleTypeDecl(XSSimpleTypeDecl base, String name, String uri, short finalSet, boolean isImmutable) {
        this.fBase = base;
        this.fTypeName = name;
        this.fTargetNamespace = uri;
        this.fFinalSet = finalSet;
        this.fVariety = this.fBase.fVariety;
        this.fValidationDV = this.fBase.fValidationDV;
        switch (this.fVariety) {
            case 1: {
                break;
            }
            case 2: {
                this.fItemType = this.fBase.fItemType;
                break;
            }
            case 3: {
                this.fMemberTypes = this.fBase.fMemberTypes;
            }
        }
        this.fLength = this.fBase.fLength;
        this.fMinLength = this.fBase.fMinLength;
        this.fMaxLength = this.fBase.fMaxLength;
        this.fPattern = this.fBase.fPattern;
        this.fPatternStr = this.fBase.fPatternStr;
        this.fEnumeration = this.fBase.fEnumeration;
        this.fWhiteSpace = this.fBase.fWhiteSpace;
        this.fMaxExclusive = this.fBase.fMaxExclusive;
        this.fMaxInclusive = this.fBase.fMaxInclusive;
        this.fMinExclusive = this.fBase.fMinExclusive;
        this.fMinInclusive = this.fBase.fMinInclusive;
        this.fTotalDigits = this.fBase.fTotalDigits;
        this.fFractionDigits = this.fBase.fFractionDigits;
        this.fPatternType = this.fBase.fPatternType;
        this.fFixedFacet = this.fBase.fFixedFacet;
        this.fFacetsDefined = this.fBase.fFacetsDefined;
        this.caclFundamentalFacets();
        this.fIsImmutable = isImmutable;
    }

    protected XSSimpleTypeDecl(String name, String uri, short finalSet, XSSimpleTypeDecl itemType, boolean isImmutable) {
        this.fBase = fAnySimpleType;
        this.fTypeName = name;
        this.fTargetNamespace = uri;
        this.fFinalSet = finalSet;
        this.fVariety = (short)2;
        this.fItemType = itemType;
        this.fValidationDV = (short)24;
        this.fFacetsDefined = (short)64;
        this.fFixedFacet = (short)64;
        this.fWhiteSpace = (short)2;
        this.caclFundamentalFacets();
        this.fIsImmutable = isImmutable;
    }

    protected XSSimpleTypeDecl(String name, String uri, short finalSet, XSSimpleTypeDecl[] memberTypes) {
        this.fBase = fAnySimpleType;
        this.fTypeName = name;
        this.fTargetNamespace = uri;
        this.fFinalSet = finalSet;
        this.fVariety = (short)3;
        this.fMemberTypes = memberTypes;
        this.fValidationDV = (short)25;
        this.fFacetsDefined = (short)64;
        this.fWhiteSpace = (short)2;
        this.caclFundamentalFacets();
        this.fIsImmutable = false;
    }

    protected XSSimpleTypeDecl setRestrictionValues(XSSimpleTypeDecl base, String name, String uri, short finalSet) {
        if (this.fIsImmutable) {
            return null;
        }
        this.fBase = base;
        this.fTypeName = name;
        this.fTargetNamespace = uri;
        this.fFinalSet = finalSet;
        this.fVariety = this.fBase.fVariety;
        this.fValidationDV = this.fBase.fValidationDV;
        switch (this.fVariety) {
            case 1: {
                break;
            }
            case 2: {
                this.fItemType = this.fBase.fItemType;
                break;
            }
            case 3: {
                this.fMemberTypes = this.fBase.fMemberTypes;
            }
        }
        this.fLength = this.fBase.fLength;
        this.fMinLength = this.fBase.fMinLength;
        this.fMaxLength = this.fBase.fMaxLength;
        this.fPattern = this.fBase.fPattern;
        this.fPatternStr = this.fBase.fPatternStr;
        this.fEnumeration = this.fBase.fEnumeration;
        this.fWhiteSpace = this.fBase.fWhiteSpace;
        this.fMaxExclusive = this.fBase.fMaxExclusive;
        this.fMaxInclusive = this.fBase.fMaxInclusive;
        this.fMinExclusive = this.fBase.fMinExclusive;
        this.fMinInclusive = this.fBase.fMinInclusive;
        this.fTotalDigits = this.fBase.fTotalDigits;
        this.fFractionDigits = this.fBase.fFractionDigits;
        this.fPatternType = this.fBase.fPatternType;
        this.fFixedFacet = this.fBase.fFixedFacet;
        this.fFacetsDefined = this.fBase.fFacetsDefined;
        this.caclFundamentalFacets();
        return this;
    }

    protected XSSimpleTypeDecl setListValues(String name, String uri, short finalSet, XSSimpleTypeDecl itemType) {
        if (this.fIsImmutable) {
            return null;
        }
        this.fBase = fAnySimpleType;
        this.fTypeName = name;
        this.fTargetNamespace = uri;
        this.fFinalSet = finalSet;
        this.fVariety = (short)2;
        this.fItemType = itemType;
        this.fValidationDV = (short)24;
        this.fFacetsDefined = (short)64;
        this.fFixedFacet = (short)64;
        this.fWhiteSpace = (short)2;
        this.caclFundamentalFacets();
        return this;
    }

    protected XSSimpleTypeDecl setUnionValues(String name, String uri, short finalSet, XSSimpleTypeDecl[] memberTypes) {
        if (this.fIsImmutable) {
            return null;
        }
        this.fBase = fAnySimpleType;
        this.fTypeName = name;
        this.fTargetNamespace = uri;
        this.fFinalSet = finalSet;
        this.fVariety = (short)3;
        this.fMemberTypes = memberTypes;
        this.fValidationDV = (short)25;
        this.fFacetsDefined = (short)64;
        this.fWhiteSpace = (short)2;
        this.caclFundamentalFacets();
        return this;
    }

    public short getType() {
        return 3;
    }

    public short getTypeCategory() {
        return 14;
    }

    public String getName() {
        return this.fTypeName;
    }

    public String getNamespace() {
        return this.fTargetNamespace;
    }

    public short getFinal() {
        return this.fFinalSet;
    }

    public boolean getIsFinal(short derivation) {
        return (this.fFinalSet & derivation) != 0;
    }

    public XSTypeDefinition getBaseType() {
        return this.fBase;
    }

    public boolean getIsAnonymous() {
        return this.fTypeName == null;
    }

    public short getVariety() {
        return this.fValidationDV == 0 ? (short)0 : this.fVariety;
    }

    public boolean isIDType() {
        switch (this.fVariety) {
            case 1: {
                return this.fValidationDV == 20;
            }
            case 2: {
                return this.fItemType.isIDType();
            }
            case 3: {
                int i = 0;
                while (i < this.fMemberTypes.length) {
                    if (this.fMemberTypes[i].isIDType()) {
                        return true;
                    }
                    ++i;
                }
                break;
            }
        }
        return false;
    }

    public short getWhitespace() throws DatatypeException {
        if (this.fVariety == 3) {
            throw new DatatypeException("dt-whitespace", new Object[]{this.fTypeName});
        }
        return this.fWhiteSpace;
    }

    public short getPrimitiveKind() {
        if (this.fVariety == 1 && this.fValidationDV != 0) {
            if (this.fValidationDV == 20 || this.fValidationDV == 21 || this.fValidationDV == 22) {
                return 1;
            }
            if (this.fValidationDV == 23) {
                return 3;
            }
            return this.fValidationDV;
        }
        return 0;
    }

    public XSSimpleTypeDefinition getPrimitiveType() {
        if (this.fVariety == 1 && this.fValidationDV != 0) {
            XSSimpleTypeDecl pri = this;
            while (pri.fBase != fAnySimpleType) {
                pri = pri.fBase;
            }
            return pri;
        }
        return null;
    }

    public XSSimpleTypeDefinition getItemType() {
        if (this.fVariety == 2) {
            return this.fItemType;
        }
        return null;
    }

    public XSObjectList getMemberTypes() {
        if (this.fVariety == 3) {
            return new XSObjectListImpl(this.fMemberTypes, this.fMemberTypes.length);
        }
        return null;
    }

    public void applyFacets(XSFacets facets, short presentFacet, short fixedFacet, ValidationContext context) throws InvalidDatatypeFacetException {
        this.applyFacets(facets, presentFacet, fixedFacet, (short)0, context);
    }

    void applyFacets1(XSFacets facets, short presentFacet, short fixedFacet) {
        try {
            this.applyFacets(facets, presentFacet, fixedFacet, (short)0, fDummyContext);
        }
        catch (InvalidDatatypeFacetException e) {
            throw new RuntimeException("internal error");
        }
        this.fIsImmutable = true;
    }

    void applyFacets1(XSFacets facets, short presentFacet, short fixedFacet, short patternType) {
        try {
            this.applyFacets(facets, presentFacet, fixedFacet, patternType, fDummyContext);
        }
        catch (InvalidDatatypeFacetException e) {
            throw new RuntimeException("internal error");
        }
        this.fIsImmutable = true;
    }

    void applyFacets(XSFacets facets, short presentFacet, short fixedFacet, short patternType, ValidationContext context) throws InvalidDatatypeFacetException {
        if (this.fIsImmutable) {
            return;
        }
        ValidatedInfo tempInfo = new ValidatedInfo();
        this.fFacetsDefined = 0;
        this.fFixedFacet = 0;
        int result = 0;
        short allowedFacet = fDVs[this.fValidationDV].getAllowedFacets();
        if ((presentFacet & 2) != 0) {
            if ((allowedFacet & 2) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"length"});
            } else {
                this.fLength = facets.length;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 2);
                if ((fixedFacet & 2) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 2);
                }
            }
        }
        if ((presentFacet & 4) != 0) {
            if ((allowedFacet & 4) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"minLength"});
            } else {
                this.fMinLength = facets.minLength;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 4);
                if ((fixedFacet & 4) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 4);
                }
            }
        }
        if ((presentFacet & 8) != 0) {
            if ((allowedFacet & 8) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"maxLength"});
            } else {
                this.fMaxLength = facets.maxLength;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                if ((fixedFacet & 8) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 8);
                }
            }
        }
        if ((presentFacet & 0x10) != 0) {
            if ((allowedFacet & 0x10) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"pattern"});
            } else {
                RegularExpression regex = null;
                try {
                    regex = new RegularExpression(facets.pattern, "X");
                }
                catch (Exception e) {
                    this.reportError("InvalidRegex", new Object[]{facets.pattern, e.getLocalizedMessage()});
                }
                if (regex != null) {
                    this.fPattern = new Vector();
                    this.fPattern.addElement(regex);
                    this.fPatternStr = new Vector();
                    this.fPatternStr.addElement(facets.pattern);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                    if ((fixedFacet & 0x10) != 0) {
                        this.fFixedFacet = (short)(this.fFixedFacet | 0x10);
                    }
                }
            }
        }
        if ((presentFacet & 0x20) != 0) {
            if ((allowedFacet & 0x20) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"enumeration"});
            } else {
                this.fEnumeration = new Vector();
                Vector enumVals = facets.enumeration;
                Vector enumNSDecls = facets.enumNSDecls;
                ValidationContextImpl ctx = new ValidationContextImpl(context);
                int i = 0;
                while (i < enumVals.size()) {
                    if (enumNSDecls != null) {
                        ctx.setNSContext((NamespaceContext)enumNSDecls.elementAt(i));
                    }
                    try {
                        this.fEnumeration.addElement(this.fBase.validate((String)enumVals.elementAt(i), (ValidationContext)ctx, tempInfo));
                    }
                    catch (InvalidDatatypeValueException ide) {
                        this.reportError("enumeration-valid-restriction", new Object[]{enumVals.elementAt(i)});
                    }
                    ++i;
                }
                this.fFacetsDefined = (short)(this.fFacetsDefined | 0x20);
                if ((fixedFacet & 0x20) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 0x20);
                }
            }
        }
        if ((presentFacet & 0x40) != 0) {
            if ((allowedFacet & 0x40) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"whiteSpace"});
            } else {
                this.fWhiteSpace = facets.whiteSpace;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 0x40);
                if ((fixedFacet & 0x40) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 0x40);
                }
            }
        }
        boolean needCheckBase = true;
        if ((presentFacet & 0x80) != 0) {
            if ((allowedFacet & 0x80) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"maxInclusive"});
            } else {
                try {
                    this.fMaxInclusive = this.getActualValue(facets.maxInclusive, context, tempInfo, true);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x80);
                    if ((fixedFacet & 0x80) != 0) {
                        this.fFixedFacet = (short)(this.fFixedFacet | 0x80);
                    }
                }
                catch (InvalidDatatypeValueException ide) {
                    this.reportError("FacetValueFromBase", new Object[]{facets.maxInclusive, "maxInclusive"});
                }
                if ((this.fBase.fFacetsDefined & 0x80) != 0) {
                    result = fDVs[this.fValidationDV].compare(this.fMaxInclusive, this.fBase.fMaxInclusive);
                    if ((this.fBase.fFixedFacet & 0x80) != 0 && result != 0) {
                        this.reportError("FixedFacetValue", new Object[]{"maxInclusive", this.fMaxInclusive, this.fBase.fMaxInclusive});
                    }
                    if (result == 0) {
                        needCheckBase = false;
                    }
                }
                if (needCheckBase) {
                    try {
                        this.fBase.validate(context, tempInfo);
                    }
                    catch (InvalidDatatypeValueException ide) {
                        this.reportError("FacetValueFromBase", new Object[]{facets.maxInclusive, "maxInclusive"});
                    }
                }
            }
        }
        needCheckBase = true;
        if ((presentFacet & 0x100) != 0) {
            if ((allowedFacet & 0x100) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"maxExclusive"});
            } else {
                try {
                    this.fMaxExclusive = this.getActualValue(facets.maxExclusive, context, tempInfo, true);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x100);
                    if ((fixedFacet & 0x100) != 0) {
                        this.fFixedFacet = (short)(this.fFixedFacet | 0x100);
                    }
                }
                catch (InvalidDatatypeValueException ide) {
                    this.reportError("FacetValueFromBase", new Object[]{facets.maxExclusive, "maxExclusive"});
                }
                if ((this.fBase.fFacetsDefined & 0x100) != 0) {
                    result = fDVs[this.fValidationDV].compare(this.fMaxExclusive, this.fBase.fMaxExclusive);
                    if ((this.fBase.fFixedFacet & 0x100) != 0 && result != 0) {
                        this.reportError("FixedFacetValue", new Object[]{"maxExclusive", facets.maxExclusive, this.fBase.fMaxExclusive});
                    }
                    if (result == 0) {
                        needCheckBase = false;
                    }
                }
                if (needCheckBase) {
                    try {
                        this.fBase.validate(context, tempInfo);
                    }
                    catch (InvalidDatatypeValueException ide) {
                        this.reportError("FacetValueFromBase", new Object[]{facets.maxExclusive, "maxExclusive"});
                    }
                }
            }
        }
        needCheckBase = true;
        if ((presentFacet & 0x200) != 0) {
            if ((allowedFacet & 0x200) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"minExclusive"});
            } else {
                try {
                    this.fMinExclusive = this.getActualValue(facets.minExclusive, context, tempInfo, true);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x200);
                    if ((fixedFacet & 0x200) != 0) {
                        this.fFixedFacet = (short)(this.fFixedFacet | 0x200);
                    }
                }
                catch (InvalidDatatypeValueException ide) {
                    this.reportError("FacetValueFromBase", new Object[]{facets.minExclusive, "minExclusive"});
                }
                if ((this.fBase.fFacetsDefined & 0x200) != 0) {
                    result = fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fBase.fMinExclusive);
                    if ((this.fBase.fFixedFacet & 0x200) != 0 && result != 0) {
                        this.reportError("FixedFacetValue", new Object[]{"minExclusive", facets.minExclusive, this.fBase.fMinExclusive});
                    }
                    if (result == 0) {
                        needCheckBase = false;
                    }
                }
                if (needCheckBase) {
                    try {
                        this.fBase.validate(context, tempInfo);
                    }
                    catch (InvalidDatatypeValueException ide) {
                        this.reportError("FacetValueFromBase", new Object[]{facets.minExclusive, "minExclusive"});
                    }
                }
            }
        }
        needCheckBase = true;
        if ((presentFacet & 0x400) != 0) {
            if ((allowedFacet & 0x400) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"minInclusive"});
            } else {
                try {
                    this.fMinInclusive = this.getActualValue(facets.minInclusive, context, tempInfo, true);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x400);
                    if ((fixedFacet & 0x400) != 0) {
                        this.fFixedFacet = (short)(this.fFixedFacet | 0x400);
                    }
                }
                catch (InvalidDatatypeValueException ide) {
                    this.reportError("FacetValueFromBase", new Object[]{facets.minInclusive, "minInclusive"});
                }
                if ((this.fBase.fFacetsDefined & 0x400) != 0) {
                    result = fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fBase.fMinInclusive);
                    if ((this.fBase.fFixedFacet & 0x400) != 0 && result != 0) {
                        this.reportError("FixedFacetValue", new Object[]{"minInclusive", facets.minInclusive, this.fBase.fMinInclusive});
                    }
                    if (result == 0) {
                        needCheckBase = false;
                    }
                }
                if (needCheckBase) {
                    try {
                        this.fBase.validate(context, tempInfo);
                    }
                    catch (InvalidDatatypeValueException ide) {
                        this.reportError("FacetValueFromBase", new Object[]{facets.minInclusive, "minInclusive"});
                    }
                }
            }
        }
        if ((presentFacet & 0x800) != 0) {
            if ((allowedFacet & 0x800) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"totalDigits"});
            } else {
                this.fTotalDigits = facets.totalDigits;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 0x800);
                if ((fixedFacet & 0x800) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 0x800);
                }
            }
        }
        if ((presentFacet & 0x1000) != 0) {
            if ((allowedFacet & 0x1000) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"fractionDigits"});
            } else {
                this.fFractionDigits = facets.fractionDigits;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 0x1000);
                if ((fixedFacet & 0x1000) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 0x1000);
                }
            }
        }
        if (patternType != 0) {
            this.fPatternType = patternType;
        }
        if (this.fFacetsDefined != 0) {
            if ((this.fFacetsDefined & 2) != 0 && ((this.fFacetsDefined & 4) != 0 || (this.fFacetsDefined & 8) != 0)) {
                this.reportError("length-minLength-maxLength", null);
            }
            if ((this.fFacetsDefined & 4) != 0 && (this.fFacetsDefined & 8) != 0 && this.fMinLength > this.fMaxLength) {
                this.reportError("minLength-less-than-equal-to-maxLength", new Object[]{Integer.toString(this.fMinLength), Integer.toString(this.fMaxLength)});
            }
            if ((this.fFacetsDefined & 0x100) != 0 && (this.fFacetsDefined & 0x80) != 0) {
                this.reportError("maxInclusive-maxExclusive", null);
            }
            if ((this.fFacetsDefined & 0x200) != 0 && (this.fFacetsDefined & 0x400) != 0) {
                this.reportError("minInclusive-minExclusive", null);
            }
            if ((this.fFacetsDefined & 0x80) != 0 && (this.fFacetsDefined & 0x400) != 0 && (result = fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fMaxInclusive)) != -1 && result != 0) {
                this.reportError("minInclusive-less-than-equal-to-maxInclusive", new Object[]{this.fMinInclusive, this.fMaxInclusive});
            }
            if ((this.fFacetsDefined & 0x100) != 0 && (this.fFacetsDefined & 0x200) != 0 && (result = fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fMaxExclusive)) != -1 && result != 0) {
                this.reportError("minExclusive-less-than-equal-to-maxExclusive", new Object[]{this.fMinExclusive, this.fMaxExclusive});
            }
            if ((this.fFacetsDefined & 0x80) != 0 && (this.fFacetsDefined & 0x200) != 0 && fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fMaxInclusive) != -1) {
                this.reportError("minExclusive-less-than-maxInclusive", new Object[]{this.fMinExclusive, this.fMaxInclusive});
            }
            if ((this.fFacetsDefined & 0x100) != 0 && (this.fFacetsDefined & 0x400) != 0 && fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fMaxExclusive) != -1) {
                this.reportError("minInclusive-less-than-maxExclusive", new Object[]{this.fMinInclusive, this.fMaxExclusive});
            }
            if ((this.fFacetsDefined & 0x1000) != 0 && (this.fFacetsDefined & 0x800) != 0 && this.fFractionDigits > this.fTotalDigits) {
                this.reportError("fractionDigits-totalDigits", new Object[]{Integer.toString(this.fFractionDigits), Integer.toString(this.fTotalDigits)});
            }
            if ((this.fFacetsDefined & 2) != 0) {
                if ((this.fBase.fFacetsDefined & 8) != 0 || (this.fBase.fFacetsDefined & 4) != 0) {
                    this.reportError("length-minLength-maxLength", null);
                } else if ((this.fBase.fFacetsDefined & 2) != 0 && this.fLength != this.fBase.fLength) {
                    this.reportError("length-valid-restriction", new Object[]{Integer.toString(this.fLength), Integer.toString(this.fBase.fLength)});
                }
            }
            if ((this.fBase.fFacetsDefined & 2) != 0 && ((this.fFacetsDefined & 8) != 0 || (this.fFacetsDefined & 4) != 0)) {
                this.reportError("length-minLength-maxLength", null);
            }
            if ((this.fFacetsDefined & 4) != 0) {
                if ((this.fBase.fFacetsDefined & 8) != 0) {
                    if (this.fMinLength > this.fBase.fMaxLength) {
                        this.reportError("minLength-less-than-equal-to-maxLength", new Object[]{Integer.toString(this.fMinLength), Integer.toString(this.fBase.fMaxLength)});
                    }
                } else if ((this.fBase.fFacetsDefined & 4) != 0) {
                    if ((this.fBase.fFixedFacet & 4) != 0 && this.fMinLength != this.fBase.fMinLength) {
                        this.reportError("FixedFacetValue", new Object[]{"minLength", Integer.toString(this.fMinLength), Integer.toString(this.fBase.fMinLength)});
                    }
                    if (this.fMinLength < this.fBase.fMinLength) {
                        this.reportError("minLength-valid-restriction", new Object[]{Integer.toString(this.fMinLength), Integer.toString(this.fBase.fMinLength)});
                    }
                }
            }
            if ((this.fFacetsDefined & 8) != 0 && (this.fBase.fFacetsDefined & 4) != 0 && this.fMaxLength < this.fBase.fMinLength) {
                this.reportError("minLength-less-than-equal-to-maxLength", new Object[]{Integer.toString(this.fBase.fMinLength), Integer.toString(this.fMaxLength)});
            }
            if ((this.fFacetsDefined & 8) != 0 && (this.fBase.fFacetsDefined & 8) != 0) {
                if ((this.fBase.fFixedFacet & 8) != 0 && this.fMaxLength != this.fBase.fMaxLength) {
                    this.reportError("FixedFacetValue", new Object[]{"maxLength", Integer.toString(this.fMaxLength), Integer.toString(this.fBase.fMaxLength)});
                }
                if (this.fMaxLength > this.fBase.fMaxLength) {
                    this.reportError("maxLength-valid-restriction", new Object[]{Integer.toString(this.fMaxLength), Integer.toString(this.fBase.fMaxLength)});
                }
            }
            if ((this.fFacetsDefined & 0x800) != 0 && (this.fBase.fFacetsDefined & 0x800) != 0) {
                if ((this.fBase.fFixedFacet & 0x800) != 0 && this.fTotalDigits != this.fBase.fTotalDigits) {
                    this.reportError("FixedFacetValue", new Object[]{"totalDigits", Integer.toString(this.fTotalDigits), Integer.toString(this.fBase.fTotalDigits)});
                }
                if (this.fTotalDigits > this.fBase.fTotalDigits) {
                    this.reportError("totalDigits-valid-restriction", new Object[]{Integer.toString(this.fTotalDigits), Integer.toString(this.fBase.fTotalDigits)});
                }
            }
            if ((this.fFacetsDefined & 0x1000) != 0 && (this.fBase.fFacetsDefined & 0x1000) != 0 && (this.fBase.fFixedFacet & 0x1000) != 0 && this.fFractionDigits != this.fBase.fFractionDigits) {
                this.reportError("FixedFacetValue", new Object[]{"fractionDigits", Integer.toString(this.fFractionDigits), Integer.toString(this.fBase.fFractionDigits)});
            }
            if ((this.fFacetsDefined & 0x40) != 0 && (this.fBase.fFacetsDefined & 0x40) != 0) {
                if ((this.fBase.fFixedFacet & 0x40) != 0 && this.fWhiteSpace != this.fBase.fWhiteSpace) {
                    this.reportError("FixedFacetValue", new Object[]{"whiteSpace", this.whiteSpaceValue(this.fWhiteSpace), this.whiteSpaceValue(this.fBase.fWhiteSpace)});
                }
                if ((this.fWhiteSpace == 0 || this.fWhiteSpace == 1) && this.fBase.fWhiteSpace == 2) {
                    this.reportError("whiteSpace-valid-restriction.1", null);
                }
                if (this.fWhiteSpace == 0 && this.fBase.fWhiteSpace == 1) {
                    this.reportError("whiteSpace-valid-restriction.2", null);
                }
            }
        }
        if ((this.fFacetsDefined & 2) == 0 && (this.fBase.fFacetsDefined & 2) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 2);
            this.fLength = this.fBase.fLength;
        }
        if ((this.fFacetsDefined & 4) == 0 && (this.fBase.fFacetsDefined & 4) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 4);
            this.fMinLength = this.fBase.fMinLength;
        }
        if ((this.fFacetsDefined & 8) == 0 && (this.fBase.fFacetsDefined & 8) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
            this.fMaxLength = this.fBase.fMaxLength;
        }
        if ((this.fBase.fFacetsDefined & 0x10) != 0) {
            if ((this.fFacetsDefined & 0x10) == 0) {
                this.fPattern = this.fBase.fPattern;
                this.fPatternStr = this.fBase.fPatternStr;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
            } else {
                int i = this.fBase.fPattern.size() - 1;
                while (i >= 0) {
                    this.fPattern.addElement(this.fBase.fPattern.elementAt(i));
                    this.fPatternStr.addElement(this.fBase.fPatternStr.elementAt(i));
                    --i;
                }
            }
        }
        if ((this.fFacetsDefined & 0x40) == 0 && (this.fBase.fFacetsDefined & 0x40) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x40);
            this.fWhiteSpace = this.fBase.fWhiteSpace;
        }
        if ((this.fFacetsDefined & 0x20) == 0 && (this.fBase.fFacetsDefined & 0x20) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x20);
            this.fEnumeration = this.fBase.fEnumeration;
        }
        if ((this.fBase.fFacetsDefined & 0x100) != 0 && (this.fFacetsDefined & 0x100) == 0 && (this.fFacetsDefined & 0x80) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x100);
            this.fMaxExclusive = this.fBase.fMaxExclusive;
        }
        if ((this.fBase.fFacetsDefined & 0x80) != 0 && (this.fFacetsDefined & 0x100) == 0 && (this.fFacetsDefined & 0x80) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x80);
            this.fMaxInclusive = this.fBase.fMaxInclusive;
        }
        if ((this.fBase.fFacetsDefined & 0x200) != 0 && (this.fFacetsDefined & 0x200) == 0 && (this.fFacetsDefined & 0x400) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x200);
            this.fMinExclusive = this.fBase.fMinExclusive;
        }
        if ((this.fBase.fFacetsDefined & 0x400) != 0 && (this.fFacetsDefined & 0x200) == 0 && (this.fFacetsDefined & 0x400) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x400);
            this.fMinInclusive = this.fBase.fMinInclusive;
        }
        if ((this.fBase.fFacetsDefined & 0x800) != 0 && (this.fFacetsDefined & 0x800) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x800);
            this.fTotalDigits = this.fBase.fTotalDigits;
        }
        if ((this.fBase.fFacetsDefined & 0x1000) != 0 && (this.fFacetsDefined & 0x1000) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x1000);
            this.fFractionDigits = this.fBase.fFractionDigits;
        }
        if (this.fPatternType == 0 && this.fBase.fPatternType != 0) {
            this.fPatternType = this.fBase.fPatternType;
        }
        this.fFixedFacet = (short)(this.fFixedFacet | this.fBase.fFixedFacet);
        this.caclFundamentalFacets();
    }

    public Object validate(String content, ValidationContext context, ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        if (context == null) {
            context = fEmptyContext;
        }
        if (validatedInfo == null) {
            validatedInfo = new ValidatedInfo();
        }
        boolean needNormalize = context == null || context.needToNormalize();
        Object ob = this.getActualValue(content, context, validatedInfo, needNormalize);
        this.validate(context, validatedInfo);
        return ob;
    }

    public Object validate(Object content, ValidationContext context, ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        if (context == null) {
            context = fEmptyContext;
        }
        if (validatedInfo == null) {
            validatedInfo = new ValidatedInfo();
        }
        boolean needNormalize = context == null || context.needToNormalize();
        Object ob = this.getActualValue(content, context, validatedInfo, needNormalize);
        this.validate(context, validatedInfo);
        return ob;
    }

    public void validate(ValidationContext context, ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        if (context == null) {
            context = fEmptyContext;
        }
        if (context.needFacetChecking() && this.fFacetsDefined != 0 && this.fFacetsDefined != 64) {
            this.checkFacets(validatedInfo);
        }
        if (context.needExtraChecking()) {
            this.checkExtraRules(context, validatedInfo);
        }
    }

    private void checkFacets(ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        int compare;
        int totalDigits;
        int scale;
        Object ob = validatedInfo.actualValue;
        String content = validatedInfo.normalizedValue;
        int length = fDVs[this.fValidationDV].getDataLength(ob);
        if ((this.fFacetsDefined & 8) != 0 && length > this.fMaxLength) {
            throw new InvalidDatatypeValueException("cvc-maxLength-valid", new Object[]{content, Integer.toString(length), Integer.toString(this.fMaxLength)});
        }
        if ((this.fFacetsDefined & 4) != 0 && length < this.fMinLength) {
            throw new InvalidDatatypeValueException("cvc-minLength-valid", new Object[]{content, Integer.toString(length), Integer.toString(this.fMinLength)});
        }
        if ((this.fFacetsDefined & 2) != 0 && length != this.fLength) {
            throw new InvalidDatatypeValueException("cvc-length-valid", new Object[]{content, Integer.toString(length), Integer.toString(this.fLength)});
        }
        if ((this.fFacetsDefined & 0x20) != 0) {
            boolean present = false;
            int i = 0;
            while (i < this.fEnumeration.size()) {
                if (this.fEnumeration.elementAt(i).equals(ob)) {
                    present = true;
                    break;
                }
                ++i;
            }
            if (!present) {
                throw new InvalidDatatypeValueException("cvc-enumeration-valid", new Object[]{content, this.fEnumeration.toString()});
            }
        }
        if ((this.fFacetsDefined & 0x1000) != 0 && (scale = fDVs[this.fValidationDV].getFractionDigits(ob)) > this.fFractionDigits) {
            throw new InvalidDatatypeValueException("cvc-fractionDigits-valid", new Object[]{content, Integer.toString(scale), Integer.toString(this.fFractionDigits)});
        }
        if ((this.fFacetsDefined & 0x800) != 0 && (totalDigits = fDVs[this.fValidationDV].getTotalDigits(ob)) > this.fTotalDigits) {
            throw new InvalidDatatypeValueException("cvc-totalDigits-valid", new Object[]{content, Integer.toString(totalDigits), Integer.toString(this.fTotalDigits)});
        }
        if ((this.fFacetsDefined & 0x80) != 0 && (compare = fDVs[this.fValidationDV].compare(ob, this.fMaxInclusive)) != -1 && compare != 0) {
            throw new InvalidDatatypeValueException("cvc-maxInclusive-valid", new Object[]{content, this.fMaxInclusive});
        }
        if ((this.fFacetsDefined & 0x100) != 0 && (compare = fDVs[this.fValidationDV].compare(ob, this.fMaxExclusive)) != -1) {
            throw new InvalidDatatypeValueException("cvc-maxExclusive-valid", new Object[]{content, this.fMaxExclusive});
        }
        if ((this.fFacetsDefined & 0x400) != 0 && (compare = fDVs[this.fValidationDV].compare(ob, this.fMinInclusive)) != 1 && compare != 0) {
            throw new InvalidDatatypeValueException("cvc-minInclusive-valid", new Object[]{content, this.fMinInclusive});
        }
        if ((this.fFacetsDefined & 0x200) != 0 && (compare = fDVs[this.fValidationDV].compare(ob, this.fMinExclusive)) != 1) {
            throw new InvalidDatatypeValueException("cvc-minExclusive-valid", new Object[]{content, this.fMinExclusive});
        }
    }

    private void checkExtraRules(ValidationContext context, ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        Object ob = validatedInfo.actualValue;
        if (this.fVariety == 1) {
            fDVs[this.fValidationDV].checkExtraRules(ob, context);
        } else if (this.fVariety == 2) {
            ListData values = (ListData)ob;
            int len = values.length();
            if (this.fItemType.fVariety == 3) {
                XSSimpleTypeDecl[] memberTypes = (XSSimpleTypeDecl[])validatedInfo.memberTypes;
                XSSimpleType memberType = validatedInfo.memberType;
                int i = len - 1;
                while (i >= 0) {
                    validatedInfo.actualValue = values.item(i);
                    validatedInfo.memberType = memberTypes[i];
                    this.fItemType.checkExtraRules(context, validatedInfo);
                    --i;
                }
                validatedInfo.memberType = memberType;
            } else {
                int i = len - 1;
                while (i >= 0) {
                    validatedInfo.actualValue = values.item(i);
                    this.fItemType.checkExtraRules(context, validatedInfo);
                    --i;
                }
            }
            validatedInfo.actualValue = values;
        } else {
            ((XSSimpleTypeDecl)validatedInfo.memberType).checkExtraRules(context, validatedInfo);
        }
    }

    private Object getActualValue(Object content, ValidationContext context, ValidatedInfo validatedInfo, boolean needNormalize) throws InvalidDatatypeValueException {
        String nvalue = needNormalize ? this.normalize(content, this.fWhiteSpace) : content.toString();
        if ((this.fFacetsDefined & 0x10) != 0) {
            int idx = this.fPattern.size() - 1;
            while (idx >= 0) {
                RegularExpression regex = (RegularExpression)this.fPattern.elementAt(idx);
                if (!regex.matches(nvalue)) {
                    throw new InvalidDatatypeValueException("cvc-pattern-valid", new Object[]{content, this.fPatternStr.elementAt(idx)});
                }
                --idx;
            }
        }
        if (this.fVariety == 1) {
            Object avalue;
            if (this.fPatternType != 0) {
                boolean seenErr = false;
                if (this.fPatternType == 1) {
                    seenErr = !XMLChar.isValidNmtoken(nvalue);
                } else if (this.fPatternType == 2) {
                    seenErr = !XMLChar.isValidName(nvalue);
                } else if (this.fPatternType == 3) {
                    boolean bl = seenErr = !XMLChar.isValidNCName(nvalue);
                }
                if (seenErr) {
                    throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{nvalue, SPECIAL_PATTERN_STRING[this.fPatternType]});
                }
            }
            validatedInfo.normalizedValue = nvalue;
            validatedInfo.actualValue = avalue = fDVs[this.fValidationDV].getActualValue(nvalue, context);
            return avalue;
        }
        if (this.fVariety == 2) {
            StringTokenizer parsedList = new StringTokenizer(nvalue, " ");
            int countOfTokens = parsedList.countTokens();
            Object[] avalue = new Object[countOfTokens];
            XSSimpleTypeDecl[] memberTypes = new XSSimpleTypeDecl[countOfTokens];
            int i = 0;
            while (i < countOfTokens) {
                avalue[i] = this.fItemType.getActualValue(parsedList.nextToken(), context, validatedInfo, false);
                if (context.needFacetChecking() && this.fItemType.fFacetsDefined != 0 && this.fItemType.fFacetsDefined != 64) {
                    this.fItemType.checkFacets(validatedInfo);
                }
                memberTypes[i] = (XSSimpleTypeDecl)validatedInfo.memberType;
                ++i;
            }
            ListData v = new ListData(avalue);
            validatedInfo.actualValue = v;
            validatedInfo.memberType = null;
            validatedInfo.memberTypes = memberTypes;
            validatedInfo.normalizedValue = nvalue;
            return v;
        }
        int i = 0;
        while (i < this.fMemberTypes.length) {
            try {
                Object aValue = this.fMemberTypes[i].getActualValue(content, context, validatedInfo, true);
                if (context.needFacetChecking() && this.fMemberTypes[i].fFacetsDefined != 0 && this.fMemberTypes[i].fFacetsDefined != 64) {
                    this.fMemberTypes[i].checkFacets(validatedInfo);
                }
                validatedInfo.memberType = this.fMemberTypes[i];
                return aValue;
            }
            catch (InvalidDatatypeValueException invalidValue) {
                ++i;
            }
        }
        throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.2", new Object[]{content, this.fTypeName});
    }

    public boolean isEqual(Object value1, Object value2) {
        if (value1 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    /*
     * Unable to fully structure code
     */
    public static String normalize(String content, short ws) {
        block8: {
            block7: {
                v0 = len = content == null ? 0 : content.length();
                if (len == 0 || ws == 0) {
                    return content;
                }
                sb = new StringBuffer();
                if (ws != 1) break block7;
                i = 0;
                while (i < len) {
                    ch = content.charAt(i);
                    if (ch != '\t' && ch != '\n' && ch != '\r') {
                        sb.append(ch);
                    } else {
                        sb.append(' ');
                    }
                    ++i;
                }
                break block8;
            }
            isLeading = true;
            i = 0;
            while (i < len) {
                block9: {
                    ch = content.charAt(i);
                    if (ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ') ** GOTO lbl30
                    sb.append(ch);
                    isLeading = false;
                    break block9;
                    while ((ch = content.charAt(i + 1)) == '\t' || ch == '\n' || ch == '\r' || ch == ' ') {
                        ++i;
lbl30:
                        // 2 sources

                        if (i < len - 1) continue;
                    }
                    if (i < len - 1 && !isLeading) {
                        sb.append(' ');
                    }
                }
                ++i;
            }
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    protected String normalize(Object content, short ws) {
        block13: {
            block12: {
                if (content == null) {
                    return null;
                }
                if ((this.fFacetsDefined & 16) == 0) {
                    norm_type = XSSimpleTypeDecl.fDVNormalizeType[this.fValidationDV];
                    if (norm_type == 0) {
                        return content.toString();
                    }
                    if (norm_type == 1) {
                        return content.toString().trim();
                    }
                }
                if (!(content instanceof StringBuffer)) {
                    strContent = content.toString();
                    return XSSimpleTypeDecl.normalize(strContent, ws);
                }
                sb = (StringBuffer)content;
                len = sb.length();
                if (len == 0) {
                    return "";
                }
                if (ws == 0) {
                    return sb.toString();
                }
                if (ws != 1) break block12;
                i = 0;
                while (i < len) {
                    ch = sb.charAt(i);
                    if (ch == '\t' || ch == '\n' || ch == '\r') {
                        sb.setCharAt(i, ' ');
                    }
                    ++i;
                }
                break block13;
            }
            j = 0;
            isLeading = true;
            i = 0;
            while (i < len) {
                block14: {
                    ch = sb.charAt(i);
                    if (ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ') ** GOTO lbl39
                    sb.setCharAt(j++, ch);
                    isLeading = false;
                    break block14;
                    while ((ch = sb.charAt(i + 1)) == '\t' || ch == '\n' || ch == '\r' || ch == ' ') {
                        ++i;
lbl39:
                        // 2 sources

                        if (i < len - 1) continue;
                    }
                    if (i < len - 1 && !isLeading) {
                        sb.setCharAt(j++, ' ');
                    }
                }
                ++i;
            }
            sb.setLength(j);
        }
        return sb.toString();
    }

    void reportError(String key, Object[] args) throws InvalidDatatypeFacetException {
        throw new InvalidDatatypeFacetException(key, args);
    }

    private String whiteSpaceValue(short ws) {
        return WS_FACET_STRING[ws];
    }

    public short getOrdered() {
        return this.fOrdered;
    }

    public boolean getIsBounded() {
        return this.fBounded;
    }

    public boolean getIsFinite() {
        return this.fFinite;
    }

    public boolean getIsNumeric() {
        return this.fNumeric;
    }

    public boolean getIsDefinedFacet(short facetName) {
        return (this.fFacetsDefined & facetName) != 0;
    }

    public short getDefinedFacets() {
        return this.fFacetsDefined;
    }

    public boolean getIsFixedFacet(short facetName) {
        return (this.fFixedFacet & facetName) != 0;
    }

    public short getFixedFacets() {
        return this.fFixedFacet;
    }

    public String getLexicalFacetValue(short facetName) {
        switch (facetName) {
            case 2: {
                return Integer.toString(this.fLength);
            }
            case 4: {
                return Integer.toString(this.fMinLength);
            }
            case 8: {
                return Integer.toString(this.fMaxLength);
            }
            case 64: {
                return WS_FACET_STRING[this.fWhiteSpace];
            }
            case 128: {
                return this.fMaxInclusive.toString();
            }
            case 256: {
                return this.fMaxExclusive.toString();
            }
            case 512: {
                return this.fMinExclusive.toString();
            }
            case 1024: {
                return this.fMinInclusive.toString();
            }
            case 2048: {
                return Integer.toString(this.fTotalDigits);
            }
            case 4096: {
                return Integer.toString(this.fFractionDigits);
            }
        }
        return null;
    }

    public StringList getLexicalEnumerations() {
        if (this.fEnumeration == null) {
            return null;
        }
        int size = this.fEnumeration.size();
        String[] strs = new String[size];
        int i = 0;
        while (i < size) {
            strs[i] = this.fEnumeration.elementAt(i).toString();
            ++i;
        }
        return new StringListImpl(strs, size);
    }

    public StringList getLexicalPatterns() {
        if (this.fPatternStr == null) {
            return null;
        }
        int size = this.fPatternStr.size();
        String[] strs = new String[size];
        int i = 0;
        while (i < size) {
            strs[i] = (String)this.fPatternStr.elementAt(i);
            ++i;
        }
        return new StringListImpl(strs, size);
    }

    public XSAnnotation getAnnotation() {
        return null;
    }

    private void caclFundamentalFacets() {
        this.setOrdered();
        this.setNumeric();
        this.setBounded();
        this.setCardinality();
    }

    private void setOrdered() {
        if (this.fVariety == 1) {
            this.fOrdered = this.fBase.fOrdered;
        } else if (this.fVariety == 2) {
            this.fOrdered = 0;
        } else if (this.fVariety == 3) {
            int length = this.fMemberTypes.length;
            if (length == 0) {
                this.fOrdered = 1;
                return;
            }
            short ancestorId = this.getPrimitiveDV(this.fMemberTypes[0].fValidationDV);
            boolean commonAnc = ancestorId != 0;
            boolean allFalse = this.fMemberTypes[0].fOrdered == 0;
            int i = 1;
            while (i < this.fMemberTypes.length && (commonAnc || allFalse)) {
                if (commonAnc) {
                    boolean bl = commonAnc = ancestorId == this.getPrimitiveDV(this.fMemberTypes[i].fValidationDV);
                }
                if (allFalse) {
                    allFalse = this.fMemberTypes[i].fOrdered == 0;
                }
                ++i;
            }
            this.fOrdered = commonAnc ? this.fMemberTypes[0].fOrdered : (allFalse ? (short)0 : 1);
        }
    }

    private void setNumeric() {
        if (this.fVariety == 1) {
            this.fNumeric = this.fBase.fNumeric;
        } else if (this.fVariety == 2) {
            this.fNumeric = false;
        } else if (this.fVariety == 3) {
            XSSimpleTypeDecl[] memberTypes = this.fMemberTypes;
            int i = 0;
            while (i < memberTypes.length) {
                if (!memberTypes[i].getIsNumeric()) {
                    this.fNumeric = false;
                    return;
                }
                ++i;
            }
            this.fNumeric = true;
        }
    }

    private void setBounded() {
        if (this.fVariety == 1) {
            this.fBounded = !((this.fFacetsDefined & 0x400) == 0 && (this.fFacetsDefined & 0x200) == 0 || (this.fFacetsDefined & 0x80) == 0 && (this.fFacetsDefined & 0x100) == 0);
        } else if (this.fVariety == 2) {
            this.fBounded = (this.fFacetsDefined & 2) != 0 || (this.fFacetsDefined & 4) != 0 && (this.fFacetsDefined & 8) != 0;
        } else if (this.fVariety == 3) {
            XSSimpleTypeDecl[] memberTypes = this.fMemberTypes;
            short ancestorId = 0;
            if (memberTypes.length > 0) {
                ancestorId = this.getPrimitiveDV(memberTypes[0].fValidationDV);
            }
            int i = 0;
            while (i < memberTypes.length) {
                if (!memberTypes[i].getIsBounded() || ancestorId != this.getPrimitiveDV(memberTypes[i].fValidationDV)) {
                    this.fBounded = false;
                    return;
                }
                ++i;
            }
            this.fBounded = true;
        }
    }

    private boolean specialCardinalityCheck() {
        return this.fBase.fValidationDV == 9 || this.fBase.fValidationDV == 10 || this.fBase.fValidationDV == 11 || this.fBase.fValidationDV == 12 || this.fBase.fValidationDV == 13 || this.fBase.fValidationDV == 14;
    }

    private void setCardinality() {
        if (this.fVariety == 1) {
            this.fFinite = this.fBase.fFinite ? true : ((this.fFacetsDefined & 2) != 0 || (this.fFacetsDefined & 8) != 0 || (this.fFacetsDefined & 0x800) != 0 ? true : (!((this.fFacetsDefined & 0x400) == 0 && (this.fFacetsDefined & 0x200) == 0 || (this.fFacetsDefined & 0x80) == 0 && (this.fFacetsDefined & 0x100) == 0) ? (this.fFacetsDefined & 0x1000) != 0 || this.specialCardinalityCheck() : false));
        } else if (this.fVariety == 2) {
            this.fFinite = (this.fFacetsDefined & 2) != 0 || (this.fFacetsDefined & 4) != 0 && (this.fFacetsDefined & 8) != 0;
        } else if (this.fVariety == 3) {
            XSSimpleTypeDecl[] memberTypes = this.fMemberTypes;
            int i = 0;
            while (i < memberTypes.length) {
                if (!memberTypes[i].getIsFinite()) {
                    this.fFinite = false;
                    return;
                }
                ++i;
            }
            this.fFinite = true;
        }
    }

    private short getPrimitiveDV(short validationDV) {
        if (validationDV == 20 || validationDV == 21 || validationDV == 22) {
            return 1;
        }
        if (validationDV == 23) {
            return 3;
        }
        return validationDV;
    }

    public boolean derivedFrom(XSTypeDefinition ancestor) {
        if (ancestor == null) {
            return false;
        }
        if (ancestor.getBaseType() == ancestor) {
            return true;
        }
        XSTypeDefinition type = this;
        while (type != ancestor && type != fAnySimpleType) {
            type = type.getBaseType();
        }
        return type == ancestor;
    }

    public boolean derivedFrom(String ancestorNS, String ancestorName) {
        if (ancestorName == null) {
            return false;
        }
        if (URI_SCHEMAFORSCHEMA.equals(ancestorNS) && ANY_TYPE.equals(ancestorName)) {
            return true;
        }
        XSTypeDecl type = this;
        while (!(ancestorName.equals(type.getName()) && (ancestorNS == null && type.getNamespace() == null || ancestorNS != null && ancestorNS.equals(type.getNamespace())) || type == fAnySimpleType)) {
            type = (XSTypeDecl)type.getBaseType();
        }
        return type != fAnySimpleType;
    }

    public void reset() {
        if (this.fIsImmutable) {
            return;
        }
        this.fItemType = null;
        this.fMemberTypes = null;
        this.fTypeName = null;
        this.fTargetNamespace = null;
        this.fFinalSet = 0;
        this.fBase = null;
        this.fVariety = (short)-1;
        this.fValidationDV = (short)-1;
        this.fFacetsDefined = 0;
        this.fFixedFacet = 0;
        this.fWhiteSpace = 0;
        this.fLength = -1;
        this.fMinLength = -1;
        this.fMaxLength = -1;
        this.fTotalDigits = -1;
        this.fFractionDigits = -1;
        this.fPattern = null;
        this.fPatternStr = null;
        this.fEnumeration = null;
        this.fMaxInclusive = null;
        this.fMaxExclusive = null;
        this.fMinExclusive = null;
        this.fMinInclusive = null;
        this.fPatternType = 0;
    }

    class ValidationContextImpl
    implements ValidationContext {
        ValidationContext fExternal;
        NamespaceContext fNSContext;

        ValidationContextImpl(ValidationContext external) {
            this.fExternal = external;
        }

        void setNSContext(NamespaceContext nsContext) {
            this.fNSContext = nsContext;
        }

        public boolean needFacetChecking() {
            return this.fExternal.needFacetChecking();
        }

        public boolean needExtraChecking() {
            return this.fExternal.needExtraChecking();
        }

        public boolean needToNormalize() {
            return this.fExternal.needToNormalize();
        }

        public boolean isEntityDeclared(String name) {
            return this.fExternal.isEntityDeclared(name);
        }

        public boolean isEntityUnparsed(String name) {
            return this.fExternal.isEntityUnparsed(name);
        }

        public boolean isIdDeclared(String name) {
            return this.fExternal.isIdDeclared(name);
        }

        public void addId(String name) {
            this.fExternal.addId(name);
        }

        public void addIdRef(String name) {
            this.fExternal.addIdRef(name);
        }

        public String getSymbol(String symbol) {
            return this.fExternal.getSymbol(symbol);
        }

        public String getURI(String prefix) {
            if (this.fNSContext == null) {
                return this.fExternal.getURI(prefix);
            }
            return this.fNSContext.getURI(prefix);
        }
    }
}

