/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.IOException;
import org.apache.xerces.impl.XMLDocumentScannerImpl;
import org.apache.xerces.impl.XMLScanner;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;

public class XML11DocumentScannerImpl
extends XMLDocumentScannerImpl {
    private String[] fStrings = new String[3];
    private XMLString fString = new XMLString();
    private XMLStringBuffer fStringBuffer = new XMLStringBuffer();
    private XMLStringBuffer fStringBuffer2 = new XMLStringBuffer();
    private XMLStringBuffer fStringBuffer3 = new XMLStringBuffer();

    protected int scanContent() throws IOException, XNIException {
        XMLString content = this.fString;
        int c = this.fEntityScanner.scanContent(content);
        if (c == 13 || c == 133 || c == 8232) {
            this.fEntityScanner.scanChar();
            this.fStringBuffer.clear();
            this.fStringBuffer.append(this.fString);
            this.fStringBuffer.append((char)c);
            content = this.fStringBuffer;
            c = -1;
        }
        if (this.fDocumentHandler != null && content.length > 0) {
            this.fDocumentHandler.characters(content, null);
        }
        if (c == 93 && this.fString.length == 0) {
            this.fStringBuffer.clear();
            this.fStringBuffer.append((char)this.fEntityScanner.scanChar());
            this.fInScanContent = true;
            if (this.fEntityScanner.skipChar(93)) {
                this.fStringBuffer.append(']');
                while (this.fEntityScanner.skipChar(93)) {
                    this.fStringBuffer.append(']');
                }
                if (this.fEntityScanner.skipChar(62)) {
                    this.reportFatalError("CDEndInContent", null);
                }
            }
            if (this.fDocumentHandler != null && this.fStringBuffer.length != 0) {
                this.fDocumentHandler.characters(this.fStringBuffer, null);
            }
            this.fInScanContent = false;
            c = -1;
        }
        return c;
    }

    protected void scanXMLDeclOrTextDecl(boolean scanningTextDecl, String[] pseudoAttributeValues) throws IOException, XNIException {
        String version = null;
        String encoding = null;
        String standalone = null;
        boolean STATE_VERSION = false;
        boolean STATE_ENCODING = true;
        int STATE_STANDALONE = 2;
        int STATE_DONE = 3;
        int state = 0;
        boolean dataFoundForTarget = false;
        boolean sawSpace = this.fEntityScanner.skipSpaces();
        while (this.fEntityScanner.peekChar() != 63) {
            dataFoundForTarget = true;
            String name = this.scanPseudoAttribute(scanningTextDecl, this.fString);
            switch (state) {
                case 0: {
                    if (name == XMLScanner.fVersionSymbol) {
                        if (!sawSpace) {
                            this.reportFatalError(scanningTextDecl ? "SpaceRequiredBeforeVersionInTextDecl" : "SpaceRequiredBeforeVersionInXMLDecl", null);
                        }
                        version = this.fString.toString();
                        state = 1;
                        if (version.equals("1.0") && version.equals("1.1")) break;
                        this.reportFatalError("VersionNotSupported", new Object[]{version});
                        break;
                    }
                    if (name == XMLScanner.fEncodingSymbol) {
                        if (!scanningTextDecl) {
                            this.reportFatalError("VersionInfoRequired", null);
                        }
                        if (!sawSpace) {
                            this.reportFatalError(scanningTextDecl ? "SpaceRequiredBeforeEncodingInTextDecl" : "SpaceRequiredBeforeEncodingInXMLDecl", null);
                        }
                        encoding = this.fString.toString();
                        state = scanningTextDecl ? 3 : 2;
                        break;
                    }
                    if (scanningTextDecl) {
                        this.reportFatalError("EncodingDeclRequired", null);
                        break;
                    }
                    this.reportFatalError("VersionInfoRequired", null);
                    break;
                }
                case 1: {
                    if (name == XMLScanner.fEncodingSymbol) {
                        if (!sawSpace) {
                            this.reportFatalError(scanningTextDecl ? "SpaceRequiredBeforeEncodingInTextDecl" : "SpaceRequiredBeforeEncodingInXMLDecl", null);
                        }
                        encoding = this.fString.toString();
                        state = scanningTextDecl ? 3 : 2;
                        break;
                    }
                    if (!scanningTextDecl && name == XMLScanner.fStandaloneSymbol) {
                        if (!sawSpace) {
                            this.reportFatalError("SpaceRequiredBeforeStandalone", null);
                        }
                        standalone = this.fString.toString();
                        state = 3;
                        if (standalone.equals("yes") || standalone.equals("no")) break;
                        this.reportFatalError("SDDeclInvalid", null);
                        break;
                    }
                    this.reportFatalError("EncodingDeclRequired", null);
                    break;
                }
                case 2: {
                    if (name == XMLScanner.fStandaloneSymbol) {
                        if (!sawSpace) {
                            this.reportFatalError("SpaceRequiredBeforeStandalone", null);
                        }
                        standalone = this.fString.toString();
                        state = 3;
                        if (standalone.equals("yes") || standalone.equals("no")) break;
                        this.reportFatalError("SDDeclInvalid", null);
                        break;
                    }
                    this.reportFatalError("EncodingDeclRequired", null);
                    break;
                }
                default: {
                    this.reportFatalError("NoMorePseudoAttributes", null);
                }
            }
            sawSpace = this.fEntityScanner.skipSpaces();
        }
        if (scanningTextDecl && state != 3) {
            this.reportFatalError("MorePseudoAttributes", null);
        }
        if (scanningTextDecl) {
            if (!dataFoundForTarget && encoding == null) {
                this.reportFatalError("EncodingDeclRequired", null);
            }
        } else if (!dataFoundForTarget && version == null) {
            this.reportFatalError("VersionInfoRequired", null);
        }
        if (!this.fEntityScanner.skipChar(63)) {
            this.reportFatalError("XMLDeclUnterminated", null);
        }
        if (!this.fEntityScanner.skipChar(62)) {
            this.reportFatalError("XMLDeclUnterminated", null);
        }
        pseudoAttributeValues[0] = version;
        pseudoAttributeValues[1] = encoding;
        pseudoAttributeValues[2] = standalone;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void scanAttributeValue(XMLString value, XMLString nonNormalizedValue, String atName, XMLAttributes attributes, int attrIndex, boolean checkEntities) throws IOException, XNIException {
        int quote;
        block26: {
            quote = this.fEntityScanner.peekChar();
            if (quote != 39 && quote != 34) {
                this.reportFatalError("OpenQuoteExpected", new Object[]{atName});
            }
            this.fEntityScanner.scanChar();
            int entityDepth = this.fEntityDepth;
            int c = this.fEntityScanner.scanLiteral(quote, value);
            this.fStringBuffer2.clear();
            this.fStringBuffer2.append(value);
            this.normalizeWhitespace(value);
            if (c == quote) break block26;
            this.fScanningAttribute = true;
            this.fStringBuffer.clear();
            do {
                block29: {
                    block38: {
                        block37: {
                            block36: {
                                block35: {
                                    block27: {
                                        String entityName;
                                        block34: {
                                            block33: {
                                                block32: {
                                                    block31: {
                                                        block30: {
                                                            block28: {
                                                                int ch;
                                                                this.fStringBuffer.append(value);
                                                                if (c != 38) break block27;
                                                                this.fEntityScanner.skipChar(38);
                                                                if (entityDepth == this.fEntityDepth) {
                                                                    this.fStringBuffer2.append('&');
                                                                }
                                                                if (!this.fEntityScanner.skipChar(35)) break block28;
                                                                if (entityDepth == this.fEntityDepth) {
                                                                    this.fStringBuffer2.append('#');
                                                                }
                                                                if ((ch = this.scanCharReferenceValue(this.fStringBuffer, this.fStringBuffer2)) == -1) {
                                                                    // empty if block
                                                                }
                                                                break block29;
                                                            }
                                                            entityName = this.fEntityScanner.scanName();
                                                            if (entityName == null) {
                                                                this.reportFatalError("NameRequiredInReference", null);
                                                            } else if (entityDepth == this.fEntityDepth) {
                                                                this.fStringBuffer2.append(entityName);
                                                            }
                                                            if (!this.fEntityScanner.skipChar(59)) {
                                                                this.reportFatalError("SemicolonRequiredInReference", new Object[]{entityName});
                                                            } else if (entityDepth == this.fEntityDepth) {
                                                                this.fStringBuffer2.append(';');
                                                            }
                                                            if (entityName != XMLScanner.fAmpSymbol) break block30;
                                                            this.fStringBuffer.append('&');
                                                            break block29;
                                                        }
                                                        if (entityName != XMLScanner.fAposSymbol) break block31;
                                                        this.fStringBuffer.append('\'');
                                                        break block29;
                                                    }
                                                    if (entityName != XMLScanner.fLtSymbol) break block32;
                                                    this.fStringBuffer.append('<');
                                                    break block29;
                                                }
                                                if (entityName != XMLScanner.fGtSymbol) break block33;
                                                this.fStringBuffer.append('>');
                                                break block29;
                                            }
                                            if (entityName != XMLScanner.fQuotSymbol) break block34;
                                            this.fStringBuffer.append('\"');
                                            break block29;
                                        }
                                        if (this.fEntityManager.isExternalEntity(entityName)) {
                                            this.reportFatalError("ReferenceToExternalEntity", new Object[]{entityName});
                                            break block29;
                                        } else {
                                            if (!this.fEntityManager.isDeclaredEntity(entityName)) {
                                                if (checkEntities) {
                                                    if (this.fValidation) {
                                                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EntityNotDeclared", new Object[]{entityName}, (short)1);
                                                    }
                                                } else {
                                                    this.reportFatalError("EntityNotDeclared", new Object[]{entityName});
                                                }
                                            }
                                            this.fEntityManager.startEntity(entityName, true);
                                        }
                                        break block29;
                                    }
                                    if (c != 60) break block35;
                                    this.reportFatalError("LessthanInAttValue", new Object[]{null, atName});
                                    this.fEntityScanner.scanChar();
                                    if (entityDepth == this.fEntityDepth) {
                                        this.fStringBuffer2.append((char)c);
                                    }
                                    break block29;
                                }
                                if (c != 37 && c != 93) break block36;
                                this.fEntityScanner.scanChar();
                                this.fStringBuffer.append((char)c);
                                if (entityDepth == this.fEntityDepth) {
                                    this.fStringBuffer2.append((char)c);
                                }
                                break block29;
                            }
                            if (c != 10 && c != 13 && c != 133 && c != 8232) break block37;
                            this.fEntityScanner.scanChar();
                            this.fStringBuffer.append(' ');
                            if (entityDepth == this.fEntityDepth) {
                                this.fStringBuffer2.append('\n');
                            }
                            break block29;
                        }
                        if (c == -1 || !XMLChar.isHighSurrogate(c)) break block38;
                        if (this.scanSurrogates(this.fStringBuffer3)) {
                            this.fStringBuffer.append(this.fStringBuffer3);
                            if (entityDepth == this.fEntityDepth) {
                                this.fStringBuffer2.append(this.fStringBuffer3);
                            }
                        }
                        break block29;
                    }
                    if (c != -1 && XMLChar.isInvalid(c)) {
                        this.reportFatalError("InvalidCharInAttValue", new Object[]{Integer.toString(c, 16)});
                        this.fEntityScanner.scanChar();
                        if (entityDepth == this.fEntityDepth) {
                            this.fStringBuffer2.append((char)c);
                        }
                    }
                }
                c = this.fEntityScanner.scanLiteral(quote, value);
                if (entityDepth == this.fEntityDepth) {
                    this.fStringBuffer2.append(value);
                }
                this.normalizeWhitespace(value);
            } while (c != quote || entityDepth != this.fEntityDepth);
            this.fStringBuffer.append(value);
            value.setValues(this.fStringBuffer);
            this.fScanningAttribute = false;
        }
        nonNormalizedValue.setValues(this.fStringBuffer2);
        int cquote = this.fEntityScanner.scanChar();
        if (cquote != quote) {
            this.reportFatalError("CloseQuoteExpected", new Object[]{atName});
        }
    }

    protected boolean scanPubidLiteral(XMLString literal) throws IOException, XNIException {
        int quote = this.fEntityScanner.scanChar();
        if (quote != 39 && quote != 34) {
            this.reportFatalError("QuoteRequiredInPublicID", null);
            return false;
        }
        this.fStringBuffer.clear();
        boolean skipSpace = true;
        boolean dataok = true;
        while (true) {
            int c;
            if ((c = this.fEntityScanner.scanChar()) == 32 || c == 10 || c == 13 || c == 133 || c == 8232) {
                if (skipSpace) continue;
                this.fStringBuffer.append(' ');
                skipSpace = true;
                continue;
            }
            if (c == quote) {
                if (skipSpace) {
                    --this.fStringBuffer.length;
                }
                break;
            }
            if (XMLChar.isPubid(c)) {
                this.fStringBuffer.append((char)c);
                skipSpace = false;
                continue;
            }
            if (c == -1) {
                this.reportFatalError("PublicIDUnterminated", null);
                return false;
            }
            dataok = false;
            this.reportFatalError("InvalidCharInPublicID", new Object[]{Integer.toHexString(c)});
        }
        literal.setValues(this.fStringBuffer);
        return dataok;
    }

    protected void normalizeWhitespace(XMLString value) {
        int end = value.offset + value.length;
        int i = value.offset;
        while (i < end) {
            char c = value.ch[i];
            if (XMLChar.isXML11Space(c)) {
                value.ch[i] = 32;
            }
            ++i;
        }
    }
}

