/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import junit.framework.AssertionFailedError;
import junit.textui.TestRunner;
import net.sourceforge.jtds.test.TestBase;

public class PerformanceTest
extends TestBase {
    long count;
    long start;
    long duration;
    static /* synthetic */ Class class$net$sourceforge$jtds$test$PerformanceTest;

    public PerformanceTest(String string) {
        super(string);
    }

    public void testCursorScrollODBC() throws Exception {
        try {
            this.connectODBC();
        }
        catch (AssertionFailedError assertionFailedError) {
            if ("Connection properties not found (conf/odbc-connection.properties).".equals(assertionFailedError.getMessage())) {
                System.err.println("Skipping ODBC tests.");
                return;
            }
            throw assertionFailedError;
        }
        this.runCursorScroll("ODBC", this.con);
    }

    public void testCursorScroll() throws Exception {
        this.runCursorScroll("jTDS", this.con);
    }

    public void testDiscard() throws Exception {
        Statement statement = this.con.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery("Select top 10000 * from CustomGoods");
        this.start("Discard");
        while (resultSet.next()) {
            resultSet.getObject(1);
            this.progress();
        }
        this.end();
        resultSet.close();
        statement.close();
    }

    void runCursorScroll(String string, Connection connection) throws Exception {
        Statement statement = connection.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery("Select top 10000 * from CustomGoods");
        this.start(string);
        while (resultSet.next()) {
            resultSet.getObject(1);
            this.progress();
        }
        while (resultSet.previous()) {
            resultSet.getObject(1);
            this.progress();
        }
        this.end();
        resultSet.close();
        statement.close();
    }

    void start(String string) {
        System.out.print("Starting " + string);
        System.out.flush();
        this.count = 0L;
        this.start = System.currentTimeMillis();
    }

    void progress() {
        ++this.count;
        if (this.count % 100L == 0L) {
            System.out.print(".");
            System.out.flush();
        }
    }

    void end() {
        this.duration = System.currentTimeMillis() - this.start;
        System.out.println("OK");
        System.out.println("Time " + this.duration + "ms.");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Class)(class$net$sourceforge$jtds$test$PerformanceTest == null ? (class$net$sourceforge$jtds$test$PerformanceTest = PerformanceTest.class$("net.sourceforge.jtds.test.PerformanceTest")) : class$net$sourceforge$jtds$test$PerformanceTest));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

