/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import net.sourceforge.jtds.jdbc.AbstractResultSet;
import net.sourceforge.jtds.jdbc.CallableStatement_base;
import net.sourceforge.jtds.jdbc.Columns;
import net.sourceforge.jtds.jdbc.Context;
import net.sourceforge.jtds.jdbc.PacketColumnInfoResult;
import net.sourceforge.jtds.jdbc.PacketColumnNamesResult;
import net.sourceforge.jtds.jdbc.PacketColumnOrderResult;
import net.sourceforge.jtds.jdbc.PacketControlResult;
import net.sourceforge.jtds.jdbc.PacketEndTokenResult;
import net.sourceforge.jtds.jdbc.PacketMsgResult;
import net.sourceforge.jtds.jdbc.PacketOutputParamResult;
import net.sourceforge.jtds.jdbc.PacketResult;
import net.sourceforge.jtds.jdbc.PacketRowResult;
import net.sourceforge.jtds.jdbc.PacketTabNameResult;
import net.sourceforge.jtds.jdbc.PacketUnknown;
import net.sourceforge.jtds.jdbc.SQLWarningChain;
import net.sourceforge.jtds.jdbc.Tds;
import net.sourceforge.jtds.jdbc.TdsException;
import net.sourceforge.jtds.jdbc.TdsStatement;

public class TdsResultSet
extends AbstractResultSet
implements ResultSet {
    Tds tds = null;
    TdsStatement stmt = null;
    Context context = null;
    int row = 0;
    boolean hitEndOfData = false;
    boolean isClosed = false;
    int rowIndex = -1;
    int rowCount = 0;
    PacketRowResult[] rowCache = null;
    public static final String cvsVersion = "$Id: TdsResultSet.java,v 1.3 2002/11/11 15:22:42 alin_sinpalean Exp $";

    public TdsResultSet(Tds tds, TdsStatement tdsStatement, SQLWarningChain sQLWarningChain, int n) throws SQLException {
        this.tds = tds;
        this.stmt = tdsStatement;
        this.warningChain = new SQLWarningChain();
        this.hitEndOfData = false;
        this.rowCache = new PacketRowResult[this.fetchSize];
        if (n > 0) {
            this.fetchSize = n;
        }
        this.startResultSet(this.tds, sQLWarningChain);
    }

    private void startResultSet(Tds tds, SQLWarningChain sQLWarningChain) throws SQLException {
        Columns columns = null;
        Columns columns2 = null;
        try {
            while (!tds.isResultRow() && !tds.isEndOfResults()) {
                PacketResult packetResult = tds.processSubPacket();
                if (packetResult instanceof PacketColumnNamesResult) {
                    columns = ((PacketColumnNamesResult)packetResult).getColumnNames();
                    continue;
                }
                if (packetResult instanceof PacketColumnInfoResult) {
                    columns2 = ((PacketColumnInfoResult)packetResult).getColumnInfo();
                    continue;
                }
                if (packetResult instanceof PacketMsgResult) {
                    sQLWarningChain.addOrReturn((PacketMsgResult)packetResult);
                    continue;
                }
                if (packetResult instanceof PacketColumnOrderResult || packetResult instanceof PacketTabNameResult || packetResult instanceof PacketControlResult || packetResult instanceof PacketUnknown) continue;
                sQLWarningChain.addException(new SQLException("Trying to get a ResultSet. Found a " + packetResult.getClass().getName()));
                break;
            }
            sQLWarningChain.checkForExceptions();
            if (columns2 != null) {
                columns.merge(columns2);
            }
            this.context = new Context(columns, tds.getEncoder());
        }
        catch (TdsException tdsException) {
            sQLWarningChain.addException(new SQLException(tdsException.getMessage()));
        }
        catch (IOException iOException) {
            sQLWarningChain.addException(new SQLException(iOException.getMessage()));
        }
        sQLWarningChain.checkForExceptions();
    }

    public Context getContext() {
        return this.context;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.checkClosed();
        if (n != 1000) {
            throw new SQLException("The result set type is TYPE_FORWARD_ONLY and the fetch direction is not FETCH_FORWARD.");
        }
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        this.checkClosed();
        int n2 = this.stmt.getMaxRows();
        if (n < 0 || n2 > 0 && n > n2) {
            throw new SQLException("Illegal fetch size: " + n);
        }
        if (n == 0) {
            this.fetchSize = this.rowCache.length;
            return;
        }
        if (n > this.rowCache.length) {
            PacketRowResult[] packetRowResultArray = new PacketRowResult[n];
            System.arraycopy(this.rowCache, 0, packetRowResultArray, 0, this.rowCache.length);
            this.rowCache = packetRowResultArray;
        }
        this.fetchSize = n;
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("Not implemented (getCursorName)");
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warningChain.getWarnings();
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        return this.row == 0 && this.haveMoreResults();
    }

    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        return this.hitEndOfData;
    }

    public boolean isFirst() throws SQLException {
        this.checkClosed();
        return this.row == 1;
    }

    public boolean isLast() throws SQLException {
        throw new SQLException("Cannot determine position on a FORWARD_ONLY RecordSet.");
    }

    public int getRow() throws SQLException {
        this.checkClosed();
        return this.row;
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    public int getType() throws SQLException {
        return 1003;
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.stmt;
    }

    public void clearWarnings() throws SQLException {
        this.warningChain.clearWarnings();
    }

    public synchronized void close() throws SQLException {
        this.close(true);
    }

    public synchronized void close(boolean bl) throws SQLException {
        Exception exception = null;
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (!this.hitEndOfData) {
            try {
                this.tds.discardResultSetOld(this.context);
                this.hitEndOfData = true;
                if (bl) {
                    this.stmt.releaseTds();
                }
            }
            catch (TdsException tdsException) {
                exception = tdsException;
            }
            catch (IOException iOException) {
                exception = iOException;
            }
        }
        this.rowCache = null;
        this.metaData = null;
        this.context = null;
        this.stmt = null;
        this.tds = null;
        if (exception != null) {
            throw new SQLException(exception.toString());
        }
    }

    public synchronized boolean next() throws SQLException {
        this.checkClosed();
        if (this.haveMoreResults()) {
            ++this.rowIndex;
            ++this.row;
            return true;
        }
        return false;
    }

    private PacketRowResult fetchNextRow() throws SQLException {
        this.checkClosed();
        PacketRowResult packetRowResult = null;
        try {
            this.clearWarnings();
            while (!(this.tds.isResultSet() || this.tds.isEndOfResults() || this.tds.isResultRow())) {
                if (this.tds.isProcId() || this.tds.isRetStat()) {
                    this.tds.processSubPacket();
                    continue;
                }
                if (this.tds.isParamResult()) {
                    PacketResult packetResult = this.tds.processSubPacket();
                    if (this.stmt == null || !(this.stmt instanceof CallableStatement_base)) continue;
                    ((CallableStatement_base)this.stmt).addOutputParam(((PacketOutputParamResult)packetResult).getValue());
                    continue;
                }
                if (this.tds.isMessagePacket() || this.tds.isErrorPacket()) {
                    this.warningChain.addOrReturn((PacketMsgResult)this.tds.processSubPacket());
                    continue;
                }
                throw new SQLException("Protocol confusion. Got a 0x" + Integer.toHexString(this.tds.peek() & 0xFF) + " packet");
            }
            this.stmt.releaseTds();
            this.warningChain.checkForExceptions();
            if (this.tds.isResultRow()) {
                packetRowResult = (PacketRowResult)this.tds.processSubPacket(this.context);
            } else if (this.tds.isEndOfResults()) {
                if (((PacketEndTokenResult)this.tds.processSubPacket(this.context)).wasCanceled()) {
                    this.warningChain.addException(new SQLException("Query was canceled or timed out."));
                }
                this.tds.goToNextResult(this.warningChain);
                packetRowResult = null;
                this.hitEndOfData = true;
                this.stmt.releaseTds();
            } else if (!this.tds.isResultSet()) {
                throw new SQLException("Protocol confusion. Got a 0x" + Integer.toHexString(this.tds.peek() & 0xFF) + " packet");
            }
        }
        catch (IOException iOException) {
            this.stmt.releaseTds();
            throw new SQLException(iOException.getMessage());
        }
        catch (TdsException tdsException) {
            this.stmt.releaseTds();
            throw new SQLException(tdsException.getMessage());
        }
        this.warningChain.checkForExceptions();
        return packetRowResult;
    }

    public void beforeFirst() throws SQLException {
        throw new SQLException("The result set type is TYPE_FORWARD_ONLY");
    }

    public void afterLast() throws SQLException {
        throw new SQLException("The result set type is TYPE_FORWARD_ONLY");
    }

    public boolean first() throws SQLException {
        throw new SQLException("The result set type is TYPE_FORWARD_ONLY");
    }

    public boolean last() throws SQLException {
        throw new SQLException("The result set type is TYPE_FORWARD_ONLY");
    }

    public boolean absolute(int n) throws SQLException {
        throw new SQLException("The result set type is TYPE_FORWARD_ONLY");
    }

    public boolean relative(int n) throws SQLException {
        throw new SQLException("The result set type is TYPE_FORWARD_ONLY");
    }

    public boolean previous() throws SQLException {
        throw new SQLException("The result set type is TYPE_FORWARD_ONLY");
    }

    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    public void insertRow() throws SQLException {
        throw new SQLException("ResultSet is not updateable");
    }

    public void updateRow() throws SQLException {
        throw new SQLException("ResultSet is not updateable");
    }

    public void deleteRow() throws SQLException {
        throw new SQLException("ResultSet is not updateable");
    }

    public void refreshRow() throws SQLException {
        this.checkClosed();
    }

    public void cancelRowUpdates() throws SQLException {
        this.checkClosed();
    }

    public void moveToInsertRow() throws SQLException {
        throw new SQLException("ResultSet is not updateable");
    }

    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("ResultSet is not updateable");
    }

    public synchronized PacketRowResult currentRow() throws SQLException {
        this.checkClosed();
        if (this.rowIndex < 0) {
            throw new SQLException("No current row in the ResultSet");
        }
        if (this.rowIndex >= this.rowCount) {
            throw new SQLException("No more results in ResultSet");
        }
        return this.rowCache[this.rowIndex];
    }

    private boolean haveMoreResults() throws SQLException {
        if (this.rowCount > 0 && this.rowIndex < this.rowCount - 1) {
            return true;
        }
        if (this.hitEndOfData) {
            this.rowCount = 0;
            return false;
        }
        return this.internalFetchRows() > 0;
    }

    private int internalFetchRows() throws SQLException {
        this.rowCount = 0;
        do {
            PacketRowResult packetRowResult = this.fetchNextRow();
            if (this.hitEndOfData) break;
            this.rowCache[this.rowCount] = packetRowResult;
            ++this.rowCount;
            this.rowIndex = -1;
        } while (this.rowCount < this.fetchSize);
        return this.rowCount;
    }

    private void reallocCache() {
        if (this.rowCache.length == this.fetchSize) {
            PacketRowResult[] packetRowResultArray = new PacketRowResult[this.fetchSize * 2];
            System.arraycopy(this.rowCache, 0, packetRowResultArray, 0, this.rowCache.length);
            this.rowCache = packetRowResultArray;
            this.fetchSize *= 2;
        } else {
            this.fetchSize = this.rowCache.length;
        }
    }

    synchronized void fetchIntoCache() throws SQLException {
        this.checkClosed();
        if (this.rowCount == 0) {
            this.internalFetchRows();
        }
        if (this.hitEndOfData) {
            return;
        }
        if (this.rowIndex > 0 && this.rowIndex < this.rowCount) {
            System.arraycopy(this.rowCache, this.rowIndex, this.rowCache, 0, this.rowCount - this.rowIndex);
            this.rowCount -= this.rowIndex;
            this.rowIndex = 0;
        } else if (this.rowIndex <= 0 && this.rowCount == this.fetchSize) {
            this.reallocCache();
        }
        while (!this.hitEndOfData) {
            do {
                PacketRowResult packetRowResult = this.fetchNextRow();
                if (this.hitEndOfData) break;
                this.rowCache[this.rowCount] = packetRowResult;
                ++this.rowCount;
            } while (this.rowCount < this.fetchSize);
            if (this.hitEndOfData) continue;
            this.reallocCache();
        }
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Invalid state: ResultSet closed.");
        }
    }
}

