/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.SQLException;
import java.util.StringTokenizer;
import net.sourceforge.jtds.jdbc.EncodingHelper;
import net.sourceforge.jtds.jdbc.ParameterListItem;
import net.sourceforge.jtds.jdbc.Tds;
import net.sourceforge.jtds.jdbc.TdsUtil;

public class ParameterUtils {
    public static final String cvsVersion = "$Id: ParameterUtils.java,v 1.1 2002/10/14 10:48:59 alin_sinpalean Exp $";

    public static int countParameters(String string) throws SQLException {
        int n = 0;
        if (string == null) {
            throw new SQLException("No statement");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "'?\\", true);
        int n2 = 1;
        block5: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (n2) {
                case 1: {
                    if (string2.equals("?")) {
                        ++n;
                        break;
                    }
                    if (!string2.equals("'")) continue block5;
                    n2 = 2;
                    break;
                }
                case 2: {
                    if (string2.equals("'")) {
                        n2 = 1;
                        break;
                    }
                    if (!string2.equals("\\")) continue block5;
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
                default: {
                    throw new SQLException("Internal error.  Bad State " + n2);
                }
            }
        }
        return n;
    }

    public static void verifyThatParametersAreSet(ParameterListItem[] parameterListItemArray) throws SQLException {
        boolean bl = true;
        int n = 0;
        while (bl && n < parameterListItemArray.length) {
            if (parameterListItemArray[n].isOutput) {
                parameterListItemArray[n].isSet = true;
            }
            boolean bl2 = bl = bl && parameterListItemArray[n].isSet;
            if (!bl) {
                throw new SQLException("parameter #" + (n + 1) + " has not been set");
            }
            ++n;
        }
    }

    public static void createParameterMapping(String string, ParameterListItem[] parameterListItemArray, Tds tds) throws SQLException {
        int n = 0;
        int n2 = tds.getTdsVer();
        EncodingHelper encodingHelper = tds.getEncoder();
        int n3 = 0;
        while (n3 < parameterListItemArray.length) {
            String string2;
            while (-1 != string.indexOf(string2 = "P" + ++n)) {
            }
            parameterListItemArray[n3].formalName = string2;
            switch (parameterListItemArray[n3].type) {
                case 1: 
                case 12: {
                    String string3 = (String)parameterListItemArray[n3].value;
                    if (string3 == null && n2 != 70) {
                        parameterListItemArray[n3].formalType = "varchar(255)";
                        parameterListItemArray[n3].maxLength = 255;
                        break;
                    }
                    if (n2 == 70) {
                        if (string3 == null || string3.length() < 4001) {
                            parameterListItemArray[n3].formalType = "nvarchar(4000)";
                            parameterListItemArray[n3].maxLength = 4000;
                            break;
                        }
                        if (string3.length() < 8001 && !encodingHelper.isDBCS() && encodingHelper.canBeConverted(string3)) {
                            parameterListItemArray[n3].formalType = "varchar(8000)";
                            parameterListItemArray[n3].maxLength = 8000;
                            break;
                        }
                        parameterListItemArray[n3].formalType = "ntext";
                        parameterListItemArray[n3].maxLength = Integer.MAX_VALUE;
                        break;
                    }
                    int n4 = string3.length();
                    if (encodingHelper.isDBCS() && n4 > 127 && n4 < 256) {
                        n4 = encodingHelper.getBytes(string3).length;
                    }
                    if (n4 < 256) {
                        parameterListItemArray[n3].formalType = "varchar(255)";
                        parameterListItemArray[n3].maxLength = 255;
                        break;
                    }
                    parameterListItemArray[n3].formalType = "text";
                    parameterListItemArray[n3].maxLength = Integer.MAX_VALUE;
                    break;
                }
                case -1: {
                    parameterListItemArray[n3].formalType = n2 == 70 ? "ntext" : "text";
                    parameterListItemArray[n3].maxLength = Integer.MAX_VALUE;
                    break;
                }
                case 4: {
                    parameterListItemArray[n3].formalType = "integer";
                    break;
                }
                case 6: 
                case 7: {
                    parameterListItemArray[n3].formalType = "real";
                    break;
                }
                case 8: {
                    parameterListItemArray[n3].formalType = "float";
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    parameterListItemArray[n3].formalType = "datetime";
                    break;
                }
                case -4: 
                case -3: {
                    parameterListItemArray[n3].formalType = "image";
                    break;
                }
                case -7: {
                    parameterListItemArray[n3].formalType = "bit";
                    break;
                }
                case -5: {
                    parameterListItemArray[n3].formalType = "decimal(28,10)";
                    break;
                }
                case 5: {
                    parameterListItemArray[n3].formalType = "smallint";
                    break;
                }
                case -6: {
                    parameterListItemArray[n3].formalType = "tinyint";
                    break;
                }
                case 2: 
                case 3: {
                    parameterListItemArray[n3].formalType = "decimal(28,10)";
                    break;
                }
                case -2: 
                case 0: 
                case 1111: {
                    throw new SQLException("Not implemented (type is java.sql.Types." + TdsUtil.javaSqlTypeToString(parameterListItemArray[n3].type) + ")");
                }
                default: {
                    throw new SQLException("Internal error.  Unrecognized type " + parameterListItemArray[n3].type);
                }
            }
            ++n3;
        }
    }
}

