/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class EncodingHelper {
    public static final String cvsVersion = "$Id: EncodingHelper.java,v 1.1 2002/10/14 10:48:59 alin_sinpalean Exp $";
    private static byte[] convArray;
    private static Hashtable knownEncodings;
    private static boolean initialized;
    private String name;
    private boolean wideChars;
    private String converted;
    static /* synthetic */ Class class$net$sourceforge$jtds$jdbc$EncodingHelper;

    private EncodingHelper(String string) throws UnsupportedEncodingException {
        this.name = string;
        this.converted = new String(convArray, string);
        boolean bl = this.wideChars = this.converted.length() != convArray.length;
        if (this.wideChars) {
            this.converted = null;
        }
    }

    public byte[] getBytes(String string) {
        try {
            return string.getBytes(this.name);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    public String getString(byte[] byArray) {
        return this.getString(byArray, 0, byArray.length);
    }

    public String getString(byte[] byArray, int n, int n2) {
        try {
            return new String(byArray, n, n2, this.name);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, n, n2);
        }
    }

    public boolean isDBCS() {
        return this.wideChars;
    }

    public boolean canBeConverted(String string) {
        if (this.isDBCS()) {
            throw new IllegalStateException(this.name + " is a DBCS charset");
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (this.converted.indexOf(string.charAt(n2)) == -1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static EncodingHelper getHelper(String string) {
        EncodingHelper encodingHelper;
        if (!initialized) {
            Class clazz = class$net$sourceforge$jtds$jdbc$EncodingHelper == null ? (class$net$sourceforge$jtds$jdbc$EncodingHelper = EncodingHelper.class$("net.sourceforge.jtds.jdbc.EncodingHelper")) : class$net$sourceforge$jtds$jdbc$EncodingHelper;
            synchronized (clazz) {
                if (!initialized) {
                    EncodingHelper.initialize();
                }
            }
        }
        if ((encodingHelper = (EncodingHelper)knownEncodings.get(string)) == null) {
            try {
                encodingHelper = new EncodingHelper(string);
                knownEncodings.put(string, encodingHelper);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                encodingHelper = (EncodingHelper)knownEncodings.get("iso_1");
            }
        }
        return encodingHelper;
    }

    private static synchronized void initialize() {
        convArray = new byte[256];
        int n = 0;
        while (n < 256) {
            EncodingHelper.convArray[n] = (byte)n;
            ++n;
        }
        knownEncodings = new Hashtable();
        try {
            knownEncodings.put("iso_1", new EncodingHelper("Cp1252"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        initialized = true;
    }

    public String getName() {
        return this.name;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        EncodingHelper.initialize();
    }
}

