/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.asm;

import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class LdcOptimizeAdapter
extends MethodAdapter
implements Opcodes {
    public LdcOptimizeAdapter(MethodVisitor mv) {
        super(mv);
    }

    public void visitLdcInsn(Object cst) {
        if (cst == null) {
            this.visitInsn(1);
        } else if (cst instanceof Integer) {
            int value = (Integer)cst;
            if (value >= -1 && value <= 5) {
                super.visitInsn(3 + value);
            } else if (value <= 127 && value >= -128) {
                super.visitIntInsn(16, value);
            } else if (value <= Short.MAX_VALUE && value >= Short.MIN_VALUE) {
                super.visitIntInsn(17, value);
            } else {
                super.visitLdcInsn(cst);
            }
        } else if (cst instanceof Long) {
            long value = (Long)cst;
            if (value == 0L || value == 1L) {
                super.visitInsn(9 + (int)value);
            } else {
                super.visitLdcInsn(cst);
            }
        } else if (cst instanceof Float) {
            float value = ((Float)cst).floatValue();
            if (value == 0.0f) {
                super.visitInsn(11);
            } else if (value == 1.0f) {
                super.visitInsn(12);
            } else if (value == 2.0f) {
                super.visitInsn(13);
            } else {
                super.visitLdcInsn(cst);
            }
        } else if (cst instanceof Double) {
            double value = (Double)cst;
            if (value == 0.0) {
                super.visitInsn(14);
            } else if (value == 1.0) {
                super.visitInsn(15);
            } else {
                super.visitLdcInsn(cst);
            }
        } else {
            super.visitLdcInsn(cst);
        }
    }
}

