/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.DynamicCallSite;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataFilters;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.Predicates;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.JavaResolver;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.LambdaExpression;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.MethodGroupExpression;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.ReturnStatement;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LambdaTransform
extends ContextTrackingVisitor<Void> {
    private final JavaResolver _resolver;
    private final Map<String, MethodDeclaration> _methodDeclarations = new HashMap<String, MethodDeclaration>();

    public LambdaTransform(DecompilerContext context) {
        super(context);
        this._resolver = new JavaResolver(context);
    }

    @Override
    public void run(AstNode compilationUnit) {
        compilationUnit.acceptVisitor(new ContextTrackingVisitor<Void>(this.context){

            @Override
            public Void visitMethodDeclaration(MethodDeclaration node, Void _) {
                MemberReference methodReference = node.getUserData(Keys.MEMBER_REFERENCE);
                if (methodReference instanceof MethodReference) {
                    LambdaTransform.this._methodDeclarations.put(LambdaTransform.makeMethodKey((MethodReference)methodReference), node);
                }
                return (Void)super.visitMethodDeclaration(node, _);
            }
        }, null);
        super.run(compilationUnit);
    }

    @Override
    public Void visitMethodGroupExpression(MethodGroupExpression node, Void data) {
        MemberReference reference = node.getUserData(Keys.MEMBER_REFERENCE);
        if (reference instanceof MethodReference) {
            MethodReference method = (MethodReference)reference;
            MethodDefinition resolvedMethod = method.resolve();
            DynamicCallSite callSite = node.getUserData(Keys.DYNAMIC_CALL_SITE);
            if (resolvedMethod != null && resolvedMethod.isSynthetic() && callSite != null) {
                this.inlineLambda(node, resolvedMethod);
                return null;
            }
        }
        return (Void)super.visitMethodGroupExpression(node, data);
    }

    private void inlineLambda(MethodGroupExpression methodGroup, MethodDefinition method) {
        TypeDefinition resolvedType;
        MethodDeclaration declaration = this._methodDeclarations.get(LambdaTransform.makeMethodKey(method));
        if (declaration == null) {
            return;
        }
        BlockStatement body = (BlockStatement)declaration.getBody().clone();
        AstNodeCollection<ParameterDeclaration> parameters = declaration.getParameters();
        final HashMap<String, IdentifierExpression> renamedVariables = new HashMap<String, IdentifierExpression>();
        AstNodeCollection<Expression> closureArguments = methodGroup.getClosureArguments();
        Statement firstStatement = body.getStatements().firstOrNullObject();
        int offset = firstStatement != null && !firstStatement.isNull() ? firstStatement.getOffset() : -34;
        Expression a = closureArguments.firstOrNullObject();
        for (ParameterDeclaration p = parameters.firstOrNullObject(); p != null && !p.isNull() && a != null && !a.isNull(); p = (ParameterDeclaration)p.getNextSibling(p.getRole()), a = (Expression)a.getNextSibling(a.getRole())) {
            if (!(a instanceof IdentifierExpression)) continue;
            renamedVariables.put(p.getName(), (IdentifierExpression)a);
        }
        body.acceptVisitor(new ContextTrackingVisitor<Void>(this.context){

            @Override
            public Void visitIdentifier(Identifier node, Void _) {
                IdentifierExpression newName;
                String oldName = node.getName();
                if (oldName != null && (newName = (IdentifierExpression)renamedVariables.get(oldName)) != null && newName.getIdentifier() != null) {
                    node.setName(newName.getIdentifier());
                }
                return (Void)super.visitIdentifier(node, _);
            }

            @Override
            public Void visitIdentifierExpression(IdentifierExpression node, Void _) {
                IdentifierExpression newName;
                String oldName = node.getIdentifier();
                if (oldName != null && (newName = (IdentifierExpression)renamedVariables.get(oldName)) != null) {
                    node.replaceWith(newName.clone());
                    return null;
                }
                return (Void)super.visitIdentifierExpression(node, _);
            }
        }, null);
        LambdaExpression lambda = new LambdaExpression(offset);
        DynamicCallSite callSite = methodGroup.getUserData(Keys.DYNAMIC_CALL_SITE);
        TypeReference lambdaType = methodGroup.getUserData(Keys.TYPE_REFERENCE);
        if (callSite != null) {
            lambda.putUserData(Keys.DYNAMIC_CALL_SITE, callSite);
        }
        if (lambdaType != null) {
            lambda.putUserData(Keys.TYPE_REFERENCE, lambdaType);
        } else if (callSite != null) {
            lambdaType = callSite.getMethodType().getReturnType();
        } else {
            return;
        }
        body.remove();
        if (body.getStatements().size() == 1 && (firstStatement instanceof ExpressionStatement || firstStatement instanceof ReturnStatement)) {
            Expression simpleBody = firstStatement.getChildByRole(Roles.EXPRESSION);
            simpleBody.remove();
            lambda.setBody(simpleBody);
        } else {
            lambda.setBody(body);
        }
        int parameterCount = 0;
        int parametersToSkip = closureArguments.size();
        for (ParameterDeclaration p : declaration.getParameters()) {
            if (parametersToSkip-- > 0) continue;
            ParameterDeclaration lambdaParameter = (ParameterDeclaration)p.clone();
            lambdaParameter.setType(AstType.NULL);
            lambda.addChild(lambdaParameter, Roles.PARAMETER);
            ++parameterCount;
        }
        if (!MetadataHelper.isRawType(lambdaType) && (resolvedType = lambdaType.resolve()) != null) {
            TypeReference asMemberOf;
            MethodReference functionMethod = null;
            List<MethodReference> methods = MetadataHelper.findMethods(resolvedType, callSite != null ? MetadataFilters.matchName(callSite.getMethodName()) : Predicates.alwaysTrue());
            for (MethodReference m : methods) {
                MethodDefinition r = m.resolve();
                if (r == null || !r.isAbstract() || r.isStatic() || r.isDefault()) continue;
                functionMethod = r;
                break;
            }
            if (functionMethod != null && functionMethod.containsGenericParameters() && functionMethod.getParameters().size() == parameterCount && (asMemberOf = MetadataHelper.asSuper(functionMethod.getDeclaringType(), lambdaType)) != null && !MetadataHelper.isRawType(asMemberOf)) {
                functionMethod = MetadataHelper.asMemberOf(functionMethod, MetadataHelper.isRawType(asMemberOf) ? MetadataHelper.erase(asMemberOf) : asMemberOf);
                lambda.putUserData(Keys.MEMBER_REFERENCE, functionMethod);
                if (functionMethod != null) {
                    List<ParameterDefinition> fp = functionMethod.getParameters();
                    int i = 0;
                    ParameterDeclaration p = lambda.getParameters().firstOrNullObject();
                    while (i < parameterCount) {
                        p.putUserData(Keys.PARAMETER_DEFINITION, fp.get(i));
                        ++i;
                        p = p.getNextSibling(Roles.PARAMETER);
                    }
                }
            }
        }
        methodGroup.replaceWith(lambda);
        lambda.acceptVisitor(this, null);
    }

    private static String makeMethodKey(MethodReference method) {
        return method.getFullName() + ":" + method.getErasedSignature();
    }
}

