/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.util;

import org.ow2.asmdex.AnnotationVisitor;
import org.ow2.asmdex.FieldVisitor;
import org.ow2.asmdex.util.AsmDexPrinter;
import org.ow2.asmdex.util.AsmDexifierAnnotationVisitor;
import org.ow2.asmdex.util.TextComponent;

public class AsmDexifierFieldVisitor
extends FieldVisitor {
    private final AsmDexPrinter pr = new AsmDexPrinter();

    public AsmDexifierFieldVisitor(int api, int nbTabulations) {
        super(api);
        this.pr.currentTabulation = nbTabulations;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.pr.addTabulation();
        this.pr.addText("{\n");
        this.pr.addTabulation();
        this.pr.addText("\tav0 = fv.visitAnnotation(");
        this.pr.addConstant(desc, true);
        this.pr.addBoolean(visible, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
        AsmDexifierAnnotationVisitor av = new AsmDexifierAnnotationVisitor(this.api, 0, this.pr.currentTabulation + 1);
        this.pr.addTextToList(av.getTextComponent());
        this.pr.addTabulation();
        this.pr.addText("}\n");
        this.pr.closeText();
        return av;
    }

    @Override
    public void visitAttribute(Object attr) {
    }

    @Override
    public void visitEnd() {
        this.pr.addTabulation();
        this.pr.addText("fv.visitEnd();");
        this.pr.addEOL();
        this.pr.closeText();
    }

    public TextComponent getTextComponent() {
        return this.pr.getTextComponent();
    }
}

