/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.util;

import org.ow2.asmdex.AnnotationVisitor;
import org.ow2.asmdex.ClassVisitor;
import org.ow2.asmdex.FieldVisitor;
import org.ow2.asmdex.MethodVisitor;
import org.ow2.asmdex.util.AsmDexPrinter;
import org.ow2.asmdex.util.AsmDexifierAnnotationVisitor;
import org.ow2.asmdex.util.AsmDexifierFieldVisitor;
import org.ow2.asmdex.util.AsmDexifierMethodVisitor;
import org.ow2.asmdex.util.TextComponent;

public class AsmDexifierClassVisitor
extends ClassVisitor {
    final AsmDexPrinter pr = new AsmDexPrinter();

    public AsmDexifierClassVisitor(int api, int nbTabulations) {
        super(api);
        this.pr.currentTabulation = nbTabulations;
    }

    @Override
    public void visit(int version, int access, String name, String[] signature, String superName, String[] interfaces) {
        this.pr.addTabulation();
        this.pr.addText("cv.visit(0, ");
        this.pr.addAccessFlags(access, true);
        this.pr.addConstant(name, true);
        this.pr.addConstant(signature, true);
        this.pr.addConstant(superName, true);
        this.pr.addConstant(interfaces, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.pr.addTabulation();
        this.pr.addText("{\n");
        this.pr.addTabulation();
        this.pr.addText("av0 = cv.visitAnnotation(");
        this.pr.addConstant(desc, true);
        this.pr.addBoolean(visible, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
        AsmDexifierAnnotationVisitor av = new AsmDexifierAnnotationVisitor(this.api, 0, this.pr.currentTabulation + 1);
        this.pr.addTextToList(av.getTextComponent());
        this.pr.addTabulation();
        this.pr.addText("}\n");
        this.pr.closeText();
        return av;
    }

    @Override
    public void visitAttribute(Object attr) {
    }

    @Override
    public void visitEnd() {
        this.pr.addTabulation();
        this.pr.addText("cv.visitEnd();");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String[] signature, Object value) {
        this.pr.addTabulation();
        this.pr.addText("{\n");
        this.pr.addTabulation();
        this.pr.addText("\tfv = cv.visitField(");
        this.pr.addAccessFlags(access, true);
        this.pr.addConstant(name, true);
        this.pr.addConstant(desc, true);
        this.pr.addConstant(signature, true);
        this.pr.addConstant(value, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
        AsmDexifierFieldVisitor fv = new AsmDexifierFieldVisitor(this.api, this.pr.currentTabulation + 1);
        this.pr.addTextToList(fv.getTextComponent());
        this.pr.addTabulation();
        this.pr.addText("}\n");
        this.pr.closeText();
        return fv;
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.pr.addTabulation();
        this.pr.addText("cv.visitInnerClass(");
        this.pr.addConstant(name, true);
        this.pr.addConstant(outerName, true);
        this.pr.addConstant(innerName, true);
        this.pr.addAccessFlags(access, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String[] signature, String[] exceptions) {
        this.pr.addTabulation();
        this.pr.addText("{\n");
        this.pr.addTabulation();
        this.pr.addText("\tmv = cv.visitMethod(");
        this.pr.addAccessFlags(access, true);
        this.pr.addConstant(name, true);
        this.pr.addConstant(desc, true);
        this.pr.addConstant(signature, true);
        this.pr.addConstant(exceptions, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
        AsmDexifierMethodVisitor mv = new AsmDexifierMethodVisitor(this.api, this.pr.currentTabulation + 1);
        this.pr.addTextToList(mv.getTextComponent());
        this.pr.addTabulation();
        this.pr.addText("}\n");
        this.pr.closeText();
        return mv;
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        this.pr.addTabulation();
        this.pr.addText("cv.visitOuterClass(");
        this.pr.addConstant(owner, true);
        this.pr.addConstant(name, true);
        this.pr.addConstant(desc, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitSource(String source, String debug) {
        this.pr.addTabulation();
        this.pr.addText("cv.visitSource(");
        this.pr.addConstant(source, true);
        this.pr.addConstant(debug, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    public TextComponent getTextComponent() {
        return this.pr.getTextComponent();
    }
}

